/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.lockout;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.lockout.LockOutFlag;
import org.jivesoftware.openfire.lockout.LockOutProvider;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockOutProvider
implements LockOutProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultLockOutProvider.class);
    private static final String FLAG_ID = "lockout";
    private static final String DELETE_FLAG = "DELETE FROM ofUserFlag WHERE username=? AND name='lockout'";
    private static final String ADD_FLAG = "INSERT INTO ofUserFlag VALUES(?,'lockout',?,?)";
    private static final String RETRIEVE_FLAG = "SELECT name,startTime,endTime FROM ofUserFlag WHERE username=? AND name='lockout'";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockOutFlag getDisabledStatus(String username) {
        LockOutFlag ret;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block7: {
            con = null;
            pstmt = null;
            rs = null;
            ret = null;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(RETRIEVE_FLAG);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (rs.next()) break block7;
            LockOutFlag lockOutFlag = null;
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return lockOutFlag;
        }
        try {
            Date startTime = null;
            if (rs.getString(2) != null) {
                startTime = new Date(Long.parseLong(rs.getString(2).trim()));
            }
            Date endTime = null;
            if (rs.getString(3) != null) {
                endTime = new Date(Long.parseLong(rs.getString(3).trim()));
            }
            ret = new LockOutFlag(username, startTime, endTime);
        }
        catch (Exception e) {
            LockOutFlag lockOutFlag;
            try {
                Log.error("Error loading lockout information from DB", (Throwable)e);
                lockOutFlag = null;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return lockOutFlag;
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void setDisabledStatus(LockOutFlag flag) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_FLAG);
            pstmt.setString(1, flag.getUsername());
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            DbConnectionManager.closeConnection(pstmt, con);
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_FLAG);
            pstmt.setString(1, flag.getUsername());
            if (flag.getStartTime() != null) {
                pstmt.setString(2, StringUtils.dateToMillis(flag.getStartTime()));
            } else {
                pstmt.setNull(2, 12);
            }
            if (flag.getEndTime() != null) {
                pstmt.setString(3, StringUtils.dateToMillis(flag.getEndTime()));
            } else {
                pstmt.setNull(3, 12);
            }
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void unsetDisabledStatus(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_FLAG);
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            DbConnectionManager.closeConnection(pstmt, con);
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isDelayedStartSupported() {
        return true;
    }

    @Override
    public boolean isTimeoutSupported() {
        return true;
    }

    @Override
    public boolean shouldNotBeCached() {
        return false;
    }
}

