/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.JiveInitialLdapContext;
import org.jivesoftware.util.SimpleSSLSocketFactory;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapManager {
    private static final Logger Log = LoggerFactory.getLogger(LdapManager.class);
    private static final String DEFAULT_LDAP_CONTEXT_FACTORY = LdapCtxFactory.class.getName();
    private static LdapManager instance;
    private Collection<String> hosts = new ArrayList<String>();
    private int port;
    private int connTimeout = -1;
    private int readTimeout = -1;
    private String usernameField;
    private String usernameSuffix;
    private String nameField;
    private String emailField;
    private String baseDN;
    private String alternateBaseDN = null;
    private String adminDN = null;
    private String adminPassword;
    private boolean encloseDNs;
    private boolean ldapDebugEnabled = false;
    private boolean sslEnabled = false;
    private String initialContextFactory;
    private boolean followReferrals = false;
    private boolean followAliasReferrals = true;
    private boolean connectionPoolEnabled = true;
    private String searchFilter = null;
    private boolean subTreeSearch;
    private boolean encloseUserDN;
    private boolean encloseGroupDN;
    private boolean startTlsEnabled = false;
    private String groupNameField;
    private String groupMemberField;
    private String groupDescriptionField;
    private boolean posixMode = false;
    private String groupSearchFilter = null;
    private final Map<String, String> properties;
    private Cache<String, DNCacheEntry> userDNCache = null;
    private static Pattern dnPattern;

    public static LdapManager getInstance() {
        return instance;
    }

    public LdapManager(Map<String, String> properties) {
        String timeout;
        String cTimeout;
        String host;
        this.properties = properties;
        JiveGlobals.migrateProperty("ldap.host");
        JiveGlobals.migrateProperty("ldap.port");
        JiveGlobals.migrateProperty("ldap.readTimeout");
        JiveGlobals.migrateProperty("ldap.usernameField");
        JiveGlobals.migrateProperty("ldap.usernameSuffix");
        JiveGlobals.migrateProperty("ldap.baseDN");
        JiveGlobals.migrateProperty("ldap.alternateBaseDN");
        JiveGlobals.migrateProperty("ldap.nameField");
        JiveGlobals.migrateProperty("ldap.emailField");
        JiveGlobals.migrateProperty("ldap.connectionPoolEnabled");
        JiveGlobals.migrateProperty("ldap.searchFilter");
        JiveGlobals.migrateProperty("ldap.subTreeSearch");
        JiveGlobals.migrateProperty("ldap.groupNameField");
        JiveGlobals.migrateProperty("ldap.groupMemberField");
        JiveGlobals.migrateProperty("ldap.groupDescriptionField");
        JiveGlobals.migrateProperty("ldap.posixMode");
        JiveGlobals.migrateProperty("ldap.groupSearchFilter");
        JiveGlobals.migrateProperty("ldap.adminDN");
        JiveGlobals.migrateProperty("ldap.adminPassword");
        JiveGlobals.migrateProperty("ldap.debugEnabled");
        JiveGlobals.migrateProperty("ldap.sslEnabled");
        JiveGlobals.migrateProperty("ldap.startTlsEnabled");
        JiveGlobals.migrateProperty("ldap.autoFollowReferrals");
        JiveGlobals.migrateProperty("ldap.autoFollowAliasReferrals");
        JiveGlobals.migrateProperty("ldap.encloseUserDN");
        JiveGlobals.migrateProperty("ldap.encloseGroupDN");
        JiveGlobals.migrateProperty("ldap.encloseDNs");
        JiveGlobals.migrateProperty("ldap.initialContextFactory");
        JiveGlobals.migrateProperty("ldap.pagedResultsSize");
        JiveGlobals.migrateProperty("ldap.clientSideSorting");
        JiveGlobals.migrateProperty("ldap.ldapDebugEnabled");
        JiveGlobals.migrateProperty("ldap.encodeMultibyteCharacters");
        if (JiveGlobals.getBooleanProperty("ldap.userDNCache.enabled", true)) {
            String cacheName = "LDAP UserDN";
            this.userDNCache = CacheFactory.createCache(cacheName);
        }
        if ((host = properties.get("ldap.host")) != null) {
            StringTokenizer st = new StringTokenizer(host, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                this.hosts.add(st.nextToken());
            }
        }
        String portStr = properties.get("ldap.port");
        this.port = 389;
        if (portStr != null) {
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                Log.error(nfe.getMessage(), (Throwable)nfe);
            }
        }
        if ((cTimeout = properties.get("ldap.connectionTimeout")) != null) {
            try {
                this.connTimeout = Integer.parseInt(cTimeout);
            }
            catch (NumberFormatException nfe) {
                Log.error(nfe.getMessage(), (Throwable)nfe);
            }
        }
        if ((timeout = properties.get("ldap.readTimeout")) != null) {
            try {
                this.readTimeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                Log.error(nfe.getMessage(), (Throwable)nfe);
            }
        }
        this.usernameField = properties.get("ldap.usernameField");
        if (this.usernameField == null) {
            this.usernameField = "uid";
        }
        this.usernameSuffix = properties.get("ldap.usernameSuffix");
        if (this.usernameSuffix == null) {
            this.usernameSuffix = "";
        }
        this.encloseDNs = true;
        String encloseStr = properties.get("ldap.encloseDNs");
        if (encloseStr != null) {
            this.encloseDNs = Boolean.valueOf(encloseStr);
        }
        this.baseDN = properties.get("ldap.baseDN");
        if (this.baseDN == null) {
            this.baseDN = "";
        }
        if (this.encloseDNs) {
            this.baseDN = LdapManager.getEnclosedDN(this.baseDN);
        }
        this.alternateBaseDN = properties.get("ldap.alternateBaseDN");
        if (this.encloseDNs && this.alternateBaseDN != null) {
            this.alternateBaseDN = LdapManager.getEnclosedDN(this.alternateBaseDN);
        }
        this.nameField = properties.get("ldap.nameField");
        if (this.nameField == null) {
            this.nameField = "cn";
        }
        this.emailField = properties.get("ldap.emailField");
        if (this.emailField == null) {
            this.emailField = "mail";
        }
        this.connectionPoolEnabled = true;
        String connectionPoolStr = properties.get("ldap.connectionPoolEnabled");
        if (connectionPoolStr != null) {
            this.connectionPoolEnabled = Boolean.valueOf(connectionPoolStr);
        }
        this.searchFilter = properties.get("ldap.searchFilter");
        this.subTreeSearch = true;
        String subTreeStr = properties.get("ldap.subTreeSearch");
        if (subTreeStr != null) {
            this.subTreeSearch = Boolean.valueOf(subTreeStr);
        }
        this.groupNameField = properties.get("ldap.groupNameField");
        if (this.groupNameField == null) {
            this.groupNameField = "cn";
        }
        this.groupMemberField = properties.get("ldap.groupMemberField");
        if (this.groupMemberField == null) {
            this.groupMemberField = "member";
        }
        this.groupDescriptionField = properties.get("ldap.groupDescriptionField");
        if (this.groupDescriptionField == null) {
            this.groupDescriptionField = "description";
        }
        this.posixMode = false;
        String posixStr = properties.get("ldap.posixMode");
        if (posixStr != null) {
            this.posixMode = Boolean.valueOf(posixStr);
        }
        this.groupSearchFilter = properties.get("ldap.groupSearchFilter");
        this.adminDN = properties.get("ldap.adminDN");
        if (this.adminDN != null && this.adminDN.trim().equals("")) {
            this.adminDN = null;
        }
        if (this.encloseDNs && this.adminDN != null) {
            this.adminDN = LdapManager.getEnclosedDN(this.adminDN);
        }
        this.adminPassword = properties.get("ldap.adminPassword");
        this.ldapDebugEnabled = false;
        String ldapDebugStr = properties.get("ldap.debugEnabled");
        if (ldapDebugStr != null) {
            this.ldapDebugEnabled = Boolean.valueOf(ldapDebugStr);
        }
        this.sslEnabled = false;
        String sslEnabledStr = properties.get("ldap.sslEnabled");
        if (sslEnabledStr != null) {
            this.sslEnabled = Boolean.valueOf(sslEnabledStr);
        }
        this.startTlsEnabled = false;
        String startTlsEnabledStr = properties.get("ldap.startTlsEnabled");
        if (startTlsEnabledStr != null) {
            this.startTlsEnabled = Boolean.valueOf(startTlsEnabledStr);
        }
        this.followReferrals = false;
        String followReferralsStr = properties.get("ldap.autoFollowReferrals");
        if (followReferralsStr != null) {
            this.followReferrals = Boolean.valueOf(followReferralsStr);
        }
        this.followAliasReferrals = true;
        String followAliasReferralsStr = properties.get("ldap.autoFollowAliasReferrals");
        if (followAliasReferralsStr != null) {
            this.followAliasReferrals = Boolean.valueOf(followAliasReferralsStr);
        }
        this.encloseUserDN = true;
        String encloseUserStr = properties.get("ldap.encloseUserDN");
        if (encloseUserStr != null) {
            this.encloseUserDN = Boolean.valueOf(encloseUserStr) != false || this.encloseDNs;
        }
        this.encloseGroupDN = true;
        String encloseGroupStr = properties.get("ldap.encloseGroupDN");
        if (encloseGroupStr != null) {
            this.encloseGroupDN = Boolean.valueOf(encloseGroupStr) != false || this.encloseDNs;
        }
        this.initialContextFactory = properties.get("ldap.initialContextFactory");
        if (this.initialContextFactory != null) {
            try {
                Class.forName(this.initialContextFactory);
            }
            catch (ClassNotFoundException cnfe) {
                Log.error("Initial context factory class failed to load: " + this.initialContextFactory + ".  Using default initial context factory class instead.");
                this.initialContextFactory = DEFAULT_LDAP_CONTEXT_FACTORY;
            }
        } else {
            this.initialContextFactory = DEFAULT_LDAP_CONTEXT_FACTORY;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Created new LdapManager() instance, fields:\n");
        buf.append("\t host: ").append(this.hosts).append("\n");
        buf.append("\t port: ").append(this.port).append("\n");
        buf.append("\t usernamefield: ").append(this.usernameField).append("\n");
        buf.append("\t usernameSuffix: ").append(this.usernameSuffix).append("\n");
        buf.append("\t baseDN: ").append(this.baseDN).append("\n");
        buf.append("\t alternateBaseDN: ").append(this.alternateBaseDN).append("\n");
        buf.append("\t nameField: ").append(this.nameField).append("\n");
        buf.append("\t emailField: ").append(this.emailField).append("\n");
        buf.append("\t adminDN: ").append(this.adminDN).append("\n");
        buf.append("\t adminPassword: ").append(this.adminPassword).append("\n");
        buf.append("\t searchFilter: ").append(this.searchFilter).append("\n");
        buf.append("\t subTreeSearch:").append(this.subTreeSearch).append("\n");
        buf.append("\t ldapDebugEnabled: ").append(this.ldapDebugEnabled).append("\n");
        buf.append("\t sslEnabled: ").append(this.sslEnabled).append("\n");
        buf.append("\t startTlsEnabled: ").append(this.startTlsEnabled).append("\n");
        buf.append("\t initialContextFactory: ").append(this.initialContextFactory).append("\n");
        buf.append("\t connectionPoolEnabled: ").append(this.connectionPoolEnabled).append("\n");
        buf.append("\t autoFollowReferrals: ").append(this.followReferrals).append("\n");
        buf.append("\t autoFollowAliasReferrals: ").append(this.followAliasReferrals).append("\n");
        buf.append("\t groupNameField: ").append(this.groupNameField).append("\n");
        buf.append("\t groupMemberField: ").append(this.groupMemberField).append("\n");
        buf.append("\t groupDescriptionField: ").append(this.groupDescriptionField).append("\n");
        buf.append("\t posixMode: ").append(this.posixMode).append("\n");
        buf.append("\t groupSearchFilter: ").append(this.groupSearchFilter).append("\n");
        if (Log.isDebugEnabled()) {
            Log.debug("LdapManager: " + buf.toString());
        }
        if (this.ldapDebugEnabled) {
            System.err.println(buf.toString());
        }
    }

    public LdapContext getContext() throws NamingException {
        try {
            return this.getContext(this.baseDN);
        }
        catch (NamingException e) {
            if (this.alternateBaseDN != null) {
                return this.getContext(this.alternateBaseDN);
            }
            throw e;
        }
    }

    public LdapContext getContext(String baseDN) throws NamingException {
        boolean debug = Log.isDebugEnabled();
        if (debug) {
            Log.debug("LdapManager: Creating a DirContext in LdapManager.getContext()...");
            if (!this.sslEnabled && !this.startTlsEnabled) {
                Log.debug("LdapManager: Warning: Using unencrypted connection to LDAP service!");
            }
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", this.initialContextFactory);
        env.put("java.naming.provider.url", this.getProviderURL(baseDN));
        if (this.sslEnabled) {
            env.put("java.naming.ldap.factory.socket", "org.jivesoftware.util.SimpleSSLSocketFactory");
            env.put("java.naming.security.protocol", "ssl");
        }
        if (this.adminDN != null) {
            if (!this.startTlsEnabled || this.sslEnabled) {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", this.adminDN);
                if (this.adminPassword != null) {
                    env.put("java.naming.security.credentials", this.adminPassword);
                }
            }
        } else {
            env.put("java.naming.security.authentication", "none");
        }
        if (this.ldapDebugEnabled) {
            env.put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        if (this.connectionPoolEnabled) {
            if (!this.startTlsEnabled) {
                env.put("com.sun.jndi.ldap.connect.pool", "true");
                System.setProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            } else {
                if (debug) {
                    Log.debug("LdapManager: connection pooling was requested but has been disabled because of StartTLS.");
                }
                env.put("com.sun.jndi.ldap.connect.pool", "false");
            }
        } else {
            env.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.connTimeout > 0) {
            env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.connTimeout));
        } else {
            env.put("com.sun.jndi.ldap.connect.timeout", "10000");
        }
        if (this.readTimeout > 0) {
            env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.readTimeout));
        }
        if (this.followReferrals) {
            env.put("java.naming.referral", "follow");
        }
        if (!this.followAliasReferrals) {
            env.put("java.naming.ldap.derefAliases", "never");
        }
        if (debug) {
            Log.debug("LdapManager: Created hashtable with context values, attempting to create context...");
        }
        JiveInitialLdapContext context = new JiveInitialLdapContext(env, null);
        if (this.startTlsEnabled && !this.sslEnabled) {
            if (debug) {
                Log.debug("LdapManager: ... StartTlsRequest");
            }
            if (this.followReferrals) {
                Log.warn("\tConnections to referrals are unencrypted! If you do not want this, please turn off ldap.autoFollowReferrals");
            }
            StartTlsResponse tls = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
            try {
                SSLSession session = tls.negotiate(new SimpleSSLSocketFactory());
                context.setTlsResponse(tls);
                context.setSslSession(session);
                if (debug) {
                    Log.debug("LdapManager: ... peer host: " + session.getPeerHost() + ", CipherSuite: " + session.getCipherSuite());
                }
                if (this.adminDN != null) {
                    context.addToEnvironment("java.naming.security.authentication", "simple");
                    context.addToEnvironment("java.naming.security.principal", this.adminDN);
                    if (this.adminPassword != null) {
                        context.addToEnvironment("java.naming.security.credentials", this.adminPassword);
                    }
                }
            }
            catch (IOException ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (debug) {
            Log.debug("LdapManager: ... context created successfully, returning.");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAuthentication(String userDN, String password) {
        block54: {
            boolean debug = Log.isDebugEnabled();
            if (debug) {
                Log.debug("LdapManager: In LdapManager.checkAuthentication(userDN, password), userDN is: " + userDN + "...");
                if (!this.sslEnabled && !this.startTlsEnabled) {
                    Log.debug("LdapManager: Warning: Using unencrypted connection to LDAP service!");
                }
            }
            InitialContext ctx = null;
            try {
                Hashtable<String, Object> env = new Hashtable<String, Object>();
                env.put("java.naming.factory.initial", this.initialContextFactory);
                env.put("java.naming.provider.url", this.getProviderURL(this.baseDN));
                if (this.sslEnabled) {
                    env.put("java.naming.ldap.factory.socket", "org.jivesoftware.util.SimpleSSLSocketFactory");
                    env.put("java.naming.security.protocol", "ssl");
                }
                if (!this.startTlsEnabled || this.sslEnabled) {
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.security.principal", userDN + "," + this.baseDN);
                    env.put("java.naming.security.credentials", password);
                } else if (this.followReferrals) {
                    Log.warn("\tConnections to referrals are unencrypted! If you do not want this, please turn off ldap.autoFollowReferrals");
                }
                if (this.connTimeout > 0) {
                    env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.connTimeout));
                } else {
                    env.put("com.sun.jndi.ldap.connect.timeout", "10000");
                }
                if (this.readTimeout > 0) {
                    env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.readTimeout));
                }
                if (this.ldapDebugEnabled) {
                    env.put("com.sun.jndi.ldap.trace.ber", System.err);
                }
                if (this.followReferrals) {
                    env.put("java.naming.referral", "follow");
                }
                if (!this.followAliasReferrals) {
                    env.put("java.naming.ldap.derefAliases", "never");
                }
                if (debug) {
                    Log.debug("LdapManager: Created context values, attempting to create context...");
                }
                ctx = new JiveInitialLdapContext(env, null);
                if (this.startTlsEnabled && !this.sslEnabled) {
                    if (debug) {
                        Log.debug("LdapManager: ... StartTlsRequest");
                    }
                    StartTlsResponse tls = (StartTlsResponse)((InitialLdapContext)ctx).extendedOperation(new StartTlsRequest());
                    try {
                        SSLSession session = tls.negotiate(new SimpleSSLSocketFactory());
                        ((JiveInitialLdapContext)ctx).setTlsResponse(tls);
                        ((JiveInitialLdapContext)ctx).setSslSession(session);
                        if (debug) {
                            Log.debug("LdapManager: ... peer host: " + session.getPeerHost() + ", CipherSuite: " + session.getCipherSuite());
                        }
                        ctx.addToEnvironment("java.naming.security.authentication", "simple");
                        ctx.addToEnvironment("java.naming.security.principal", userDN + "," + this.baseDN);
                        ctx.addToEnvironment("java.naming.security.credentials", password);
                    }
                    catch (IOException ex) {
                        Log.error(ex.getMessage(), (Throwable)ex);
                    }
                    this.lookupExistence((InitialDirContext)ctx, userDN + "," + this.baseDN, new String[]{this.usernameField});
                }
                if (debug) {
                    Log.debug("LdapManager: ... context created successfully, returning.");
                }
            }
            catch (NamingException ne) {
                if (this.alternateBaseDN != null) {
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        Hashtable<String, Object> env = new Hashtable<String, Object>();
                        env.put("java.naming.factory.initial", this.initialContextFactory);
                        env.put("java.naming.provider.url", this.getProviderURL(this.alternateBaseDN));
                        if (this.sslEnabled) {
                            env.put("java.naming.ldap.factory.socket", "org.jivesoftware.util.SimpleSSLSocketFactory");
                            env.put("java.naming.security.protocol", "ssl");
                        }
                        if (!this.startTlsEnabled || this.sslEnabled) {
                            env.put("java.naming.security.authentication", "simple");
                            env.put("java.naming.security.principal", userDN + "," + this.alternateBaseDN);
                            env.put("java.naming.security.credentials", password);
                        }
                        env.put("com.sun.jndi.ldap.connect.timeout", "10000");
                        if (this.ldapDebugEnabled) {
                            env.put("com.sun.jndi.ldap.trace.ber", System.err);
                        }
                        if (this.followReferrals) {
                            env.put("java.naming.referral", "follow");
                        }
                        if (!this.followAliasReferrals) {
                            env.put("java.naming.ldap.derefAliases", "never");
                        }
                        if (debug) {
                            Log.debug("LdapManager: Created context values, attempting to create context...");
                        }
                        ctx = new JiveInitialLdapContext(env, null);
                        if (!this.startTlsEnabled || this.sslEnabled) break block54;
                        if (debug) {
                            Log.debug("LdapManager: ... StartTlsRequest");
                        }
                        StartTlsResponse tls = (StartTlsResponse)((InitialLdapContext)ctx).extendedOperation(new StartTlsRequest());
                        try {
                            SSLSession session = tls.negotiate(new SimpleSSLSocketFactory());
                            ((JiveInitialLdapContext)ctx).setTlsResponse(tls);
                            ((JiveInitialLdapContext)ctx).setSslSession(session);
                            if (debug) {
                                Log.debug("LdapManager: ... peer host: " + session.getPeerHost() + ", CipherSuite: " + session.getCipherSuite());
                            }
                            ctx.addToEnvironment("java.naming.security.authentication", "simple");
                            ctx.addToEnvironment("java.naming.security.principal", userDN + "," + this.alternateBaseDN);
                            ctx.addToEnvironment("java.naming.security.credentials", password);
                        }
                        catch (IOException ex) {
                            Log.error(ex.getMessage(), (Throwable)ex);
                        }
                        this.lookupExistence((InitialDirContext)ctx, userDN + "," + this.alternateBaseDN, new String[]{this.usernameField});
                        break block54;
                    }
                    catch (NamingException e) {
                        if (debug) {
                            Log.debug("LdapManager: Caught a naming exception when creating InitialContext", (Throwable)ne);
                        }
                        boolean tls = false;
                        return tls;
                    }
                }
                if (debug) {
                    Log.debug("LdapManager: Caught a naming exception when creating InitialContext", (Throwable)ne);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    private Boolean lookupExistence(InitialDirContext ctx, String dn, String[] returnattrs) throws NamingException {
        boolean debug = Log.isDebugEnabled();
        if (debug) {
            Log.debug("LdapManager: In lookupExistence(ctx, dn, returnattrs), searchdn is: " + dn);
        }
        ctx.addToEnvironment("java.naming.provider.url", this.getProviderURL(dn));
        String filter = "(&(objectClass=*))";
        SearchControls srcnt = new SearchControls();
        srcnt.setSearchScope(0);
        srcnt.setReturningAttributes(returnattrs);
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = ctx.search("", filter, srcnt);
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        catch (NamingException ex) {
            throw ex;
        }
        if (answer == null || !answer.hasMoreElements()) {
            Log.debug("LdapManager: .... lookupExistence: DN not found.");
            return false;
        }
        Log.debug("LdapManager: .... lookupExistence: DN found.");
        return true;
    }

    public String findUserDN(String username) throws Exception {
        DNCacheEntry dnCacheEntry;
        if (this.userDNCache != null && (dnCacheEntry = (DNCacheEntry)this.userDNCache.get(username)) != null) {
            return dnCacheEntry.getUserDN();
        }
        try {
            String userDN = this.findUserDN(username, this.baseDN);
            if (this.userDNCache != null) {
                this.userDNCache.put(username, new DNCacheEntry(userDN, this.baseDN));
            }
            return userDN;
        }
        catch (Exception e) {
            if (this.alternateBaseDN != null) {
                String userDN = this.findUserDN(username, this.alternateBaseDN);
                if (this.userDNCache != null) {
                    this.userDNCache.put(username, new DNCacheEntry(userDN, this.alternateBaseDN));
                }
                return userDN;
            }
            throw e;
        }
    }

    public String findUserDN(String username, String baseDN) throws Exception {
        boolean debug = Log.isDebugEnabled();
        username = username + this.usernameSuffix;
        if (debug) {
            Log.debug("LdapManager: Trying to find a user's DN based on their username. " + this.usernameField + ": " + username + ", Base DN: " + baseDN + "...");
        }
        LdapContext ctx = null;
        try {
            ctx = this.getContext(baseDN);
            if (debug) {
                Log.debug("LdapManager: Starting LDAP search...");
            }
            SearchControls constraints = new SearchControls();
            if (this.subTreeSearch) {
                constraints.setSearchScope(2);
            } else {
                constraints.setSearchScope(1);
            }
            constraints.setReturningAttributes(new String[]{this.usernameField});
            NamingEnumeration<SearchResult> answer = ctx.search("", this.getSearchFilter(), (Object[])new String[]{LdapManager.sanitizeSearchFilter(username)}, constraints);
            if (debug) {
                Log.debug("LdapManager: ... search finished");
            }
            if (answer == null || !answer.hasMoreElements()) {
                if (debug) {
                    Log.debug("LdapManager: User DN based on username '" + username + "' not found.");
                }
                throw new UserNotFoundException("Username " + username + " not found");
            }
            String userDN = answer.next().getName();
            if (answer.hasMoreElements()) {
                if (debug) {
                    Log.debug("LdapManager: Search for userDN based on username '" + username + "' found multiple responses, throwing exception.");
                }
                throw new UserNotFoundException("LDAP username lookup for " + username + " matched multiple entries.");
            }
            answer.close();
            if (userDN.startsWith("ldap://")) {
                userDN = userDN.replace("," + baseDN, "");
                userDN = userDN.substring(userDN.lastIndexOf("/") + 1);
                userDN = URLDecoder.decode(userDN, "UTF-8");
            }
            if (this.encloseUserDN) {
                userDN = LdapManager.getEnclosedDN(userDN);
            }
            String string = userDN;
            return string;
        }
        catch (UserNotFoundException e) {
            Log.trace("LdapManager: UserNotFoundException thrown", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug("LdapManager: Exception thrown when searching for userDN based on username '" + username + "'", (Throwable)e);
            throw e;
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
    }

    public String findGroupDN(String groupname) throws Exception {
        try {
            return this.findGroupDN(groupname, this.baseDN);
        }
        catch (Exception e) {
            if (this.alternateBaseDN != null) {
                return this.findGroupDN(groupname, this.alternateBaseDN);
            }
            throw e;
        }
    }

    public String findGroupDN(String groupname, String baseDN) throws Exception {
        boolean debug = Log.isDebugEnabled();
        if (debug) {
            Log.debug("LdapManager: Trying to find a groups's DN based on it's groupname. " + this.groupNameField + ": " + groupname + ", Base DN: " + baseDN + "...");
        }
        LdapContext ctx = null;
        try {
            ctx = this.getContext(baseDN);
            if (debug) {
                Log.debug("LdapManager: Starting LDAP search...");
            }
            SearchControls constraints = new SearchControls();
            if (this.subTreeSearch) {
                constraints.setSearchScope(2);
            } else {
                constraints.setSearchScope(1);
            }
            constraints.setReturningAttributes(new String[]{this.groupNameField});
            String filter = MessageFormat.format(this.getGroupSearchFilter(), LdapManager.sanitizeSearchFilter(groupname));
            NamingEnumeration<SearchResult> answer = ctx.search("", filter, constraints);
            if (debug) {
                Log.debug("LdapManager: ... search finished");
            }
            if (answer == null || !answer.hasMoreElements()) {
                if (debug) {
                    Log.debug("LdapManager: Group DN based on groupname '" + groupname + "' not found.");
                }
                throw new GroupNotFoundException("Groupname " + groupname + " not found");
            }
            String groupDN = answer.next().getName();
            if (answer.hasMoreElements()) {
                if (debug) {
                    Log.debug("LdapManager: Search for groupDN based on groupname '" + groupname + "' found multiple responses, throwing exception.");
                }
                throw new GroupNotFoundException("LDAP groupname lookup for " + groupname + " matched multiple entries.");
            }
            answer.close();
            if (groupDN.startsWith("ldap://")) {
                groupDN = groupDN.replace("," + baseDN, "");
                groupDN = groupDN.substring(groupDN.lastIndexOf("/") + 1);
                groupDN = URLDecoder.decode(groupDN, "UTF-8");
            }
            if (this.encloseGroupDN) {
                groupDN = LdapManager.getEnclosedDN(groupDN);
            }
            String string = groupDN;
            return string;
        }
        catch (GroupNotFoundException e) {
            Log.trace("LdapManager: GroupNotFoundException thrown", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug("LdapManager: Exception thrown when searching for groupDN based on groupname '" + groupname + "'", (Throwable)e);
            throw e;
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getProviderURL(String baseDN) {
        StringBuffer ldapURL = new StringBuffer();
        try {
            baseDN = URLEncoder.encode(baseDN, "UTF-8");
            baseDN = baseDN.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (String host : this.hosts) {
            ldapURL.append("ldap://");
            ldapURL.append(host);
            ldapURL.append(':');
            ldapURL.append(this.port);
            ldapURL.append('/');
            ldapURL.append(baseDN);
            ldapURL.append(' ');
        }
        return ldapURL.toString();
    }

    public Collection<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Collection<String> hosts) {
        this.hosts = hosts;
        StringBuilder hostProperty = new StringBuilder();
        for (String host : hosts) {
            hostProperty.append(host).append(',');
        }
        if (!hosts.isEmpty()) {
            hostProperty.setLength(hostProperty.length() - 1);
        }
        this.properties.put("ldap.host", hostProperty.toString());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.properties.put("ldap.port", Integer.toString(port));
    }

    public boolean isDebugEnabled() {
        return this.ldapDebugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.ldapDebugEnabled = debugEnabled;
        this.properties.put("ldap.ldapDebugEnabled", Boolean.toString(debugEnabled));
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        this.properties.put("ldap.sslEnabled", Boolean.toString(sslEnabled));
    }

    public boolean isStartTlsEnabled() {
        return this.startTlsEnabled;
    }

    public void setStartTlsEnabled(boolean startTlsEnabled) {
        this.startTlsEnabled = startTlsEnabled;
        this.properties.put("ldap.startTlsEnabled", Boolean.toString(startTlsEnabled));
    }

    public String getUsernameField() {
        return this.usernameField;
    }

    public String getUsernameSuffix() {
        return this.usernameSuffix;
    }

    public void setUsernameField(String usernameField) {
        this.usernameField = usernameField;
        if (usernameField == null) {
            this.properties.remove("ldap.usernameField");
            this.usernameField = "uid";
        } else {
            this.properties.put("ldap.usernameField", usernameField);
        }
    }

    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
        if (usernameSuffix == null) {
            this.properties.remove("ldap.usernameSuffix");
            this.usernameSuffix = "";
        } else {
            this.properties.put("ldap.usernameSuffix", usernameSuffix);
        }
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
        if (nameField == null) {
            this.properties.remove("ldap.nameField");
        } else {
            this.properties.put("ldap.nameField", nameField);
        }
    }

    public String getEmailField() {
        return this.emailField;
    }

    public void setEmailField(String emailField) {
        this.emailField = emailField;
        if (emailField == null) {
            this.properties.remove("ldap.emailField");
        } else {
            this.properties.put("ldap.emailField", emailField);
        }
    }

    public String getBaseDN() {
        if (this.encloseDNs) {
            return LdapManager.getEnclosedDN(this.baseDN);
        }
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
        this.properties.put("ldap.baseDN", baseDN);
    }

    public String getAlternateBaseDN() {
        return LdapManager.getEnclosedDN(this.alternateBaseDN);
    }

    public void setAlternateBaseDN(String alternateBaseDN) {
        this.alternateBaseDN = alternateBaseDN;
        if (alternateBaseDN == null) {
            this.properties.remove("ldap.alternateBaseDN");
        } else {
            this.properties.put("ldap.alternateBaseDN", alternateBaseDN);
        }
    }

    public String getUsersBaseDN(String username) {
        DNCacheEntry dnCacheEntry;
        if (this.userDNCache != null && (dnCacheEntry = (DNCacheEntry)this.userDNCache.get(username)) != null) {
            return dnCacheEntry.getBaseDN();
        }
        try {
            String userDN = this.findUserDN(username, this.baseDN);
            if (this.userDNCache != null) {
                this.userDNCache.put(username, new DNCacheEntry(userDN, this.baseDN));
            }
            return this.baseDN;
        }
        catch (Exception e) {
            try {
                if (this.alternateBaseDN != null) {
                    String userDN = this.findUserDN(username, this.alternateBaseDN);
                    if (this.userDNCache != null) {
                        this.userDNCache.put(username, new DNCacheEntry(userDN, this.alternateBaseDN));
                    }
                    return this.alternateBaseDN;
                }
            }
            catch (Exception ex) {
                Log.debug(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public String getGroupsBaseDN(String groupname) {
        try {
            this.findGroupDN(groupname, this.baseDN);
            return this.baseDN;
        }
        catch (Exception e) {
            try {
                if (this.alternateBaseDN != null) {
                    this.findGroupDN(groupname, this.alternateBaseDN);
                    return this.alternateBaseDN;
                }
            }
            catch (Exception ex) {
                Log.debug(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public String getAdminDN() {
        if (this.encloseDNs) {
            return LdapManager.getEnclosedDN(this.adminDN);
        }
        return this.adminDN;
    }

    public void setAdminDN(String adminDN) {
        this.adminDN = adminDN;
        this.properties.put("ldap.adminDN", adminDN);
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        this.properties.put("ldap.adminPassword", adminPassword);
    }

    public void setConnectionPoolEnabled(boolean connectionPoolEnabled) {
        this.connectionPoolEnabled = connectionPoolEnabled;
        this.properties.put("ldap.connectionPoolEnabled", Boolean.toString(connectionPoolEnabled));
    }

    public boolean isConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    public String getSearchFilter() {
        StringBuilder filter = new StringBuilder();
        if (this.searchFilter == null) {
            filter.append('(').append(this.usernameField).append("={0})");
        } else {
            filter.append("(&(").append(this.usernameField).append("={0})");
            filter.append(this.searchFilter).append(')');
        }
        return filter.toString();
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
        this.properties.put("ldap.searchFilter", searchFilter);
    }

    public boolean isSubTreeSearch() {
        return this.subTreeSearch;
    }

    public void setSubTreeSearch(boolean subTreeSearch) {
        this.subTreeSearch = subTreeSearch;
        this.properties.put("ldap.subTreeSearch", String.valueOf(subTreeSearch));
    }

    public boolean isFollowReferralsEnabled() {
        return this.followReferrals;
    }

    public void setFollowReferralsEnabled(boolean followReferrals) {
        this.followReferrals = followReferrals;
        this.properties.put("ldap.autoFollowReferrals", String.valueOf(followReferrals));
    }

    public boolean isFollowAliasReferralsEnabled() {
        return this.followAliasReferrals;
    }

    public void setFollowAliasReferralsEnabled(boolean followAliasReferrals) {
        this.followAliasReferrals = followAliasReferrals;
        this.properties.put("ldap.autoFollowAliasReferrals", String.valueOf(followAliasReferrals));
    }

    public String getGroupNameField() {
        return this.groupNameField;
    }

    public void setGroupNameField(String groupNameField) {
        this.groupNameField = groupNameField;
        this.properties.put("ldap.groupNameField", groupNameField);
    }

    public String getGroupMemberField() {
        return this.groupMemberField;
    }

    public void setGroupMemberField(String groupMemberField) {
        this.groupMemberField = groupMemberField;
        this.properties.put("ldap.groupMemberField", groupMemberField);
    }

    public String getGroupDescriptionField() {
        return this.groupDescriptionField;
    }

    public void setGroupDescriptionField(String groupDescriptionField) {
        this.groupDescriptionField = groupDescriptionField;
        this.properties.put("ldap.groupDescriptionField", groupDescriptionField);
    }

    public boolean isPosixMode() {
        return this.posixMode;
    }

    public void setPosixMode(boolean posixMode) {
        this.posixMode = posixMode;
        this.properties.put("ldap.posixMode", String.valueOf(posixMode));
    }

    public String getGroupSearchFilter() {
        StringBuilder groupFilter = new StringBuilder();
        if (this.groupSearchFilter == null) {
            groupFilter.append('(').append(this.groupNameField).append("={0})");
        } else {
            groupFilter.append("(&(").append(this.groupNameField).append("={0})");
            groupFilter.append(this.groupSearchFilter).append(')');
        }
        return groupFilter.toString();
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
        this.properties.put("ldap.groupSearchFilter", groupSearchFilter);
    }

    public boolean isEnclosingDNs() {
        String encloseStr = this.properties.get("ldap.encloseDNs");
        this.encloseDNs = encloseStr != null ? Boolean.valueOf(encloseStr) : true;
        return this.encloseDNs;
    }

    public void setIsEnclosingDNs(boolean enable) {
        this.encloseDNs = enable;
        this.properties.put("ldap.encloseDNs", Boolean.toString(enable));
    }

    public List<String> retrieveList(String attribute, String searchFilter, int startIndex, int numResults, String suffixToTrim) {
        return this.retrieveList(attribute, searchFilter, startIndex, numResults, suffixToTrim, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> retrieveList(String attribute, String searchFilter, int startIndex, int numResults, String suffixToTrim, boolean escapeJIDs) {
        List<String> results = new ArrayList<String>();
        int pageSize = -1;
        String pageSizeStr = this.properties.get("ldap.pagedResultsSize");
        if (pageSizeStr != null) {
            try {
                pageSize = Integer.parseInt(pageSizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Boolean clientSideSort = false;
        String clientSideSortStr = this.properties.get("ldap.clientSideSorting");
        if (clientSideSortStr != null) {
            clientSideSort = Boolean.valueOf(clientSideSortStr);
        }
        LdapContext ctx = null;
        LdapContext ctx2 = null;
        try {
            Control[] requestControls;
            Object tmpRequestControls;
            PagedResultsResponseControl prrc;
            Control[] controls;
            String result;
            NamingEnumeration<SearchResult> answer;
            byte[] cookie;
            ctx = this.getContext(this.baseDN);
            ArrayList<BasicControl> baseTmpRequestControls = new ArrayList<BasicControl>();
            if (!clientSideSort.booleanValue()) {
                baseTmpRequestControls.add(new SortControl(new String[]{attribute}, false));
            }
            if (pageSize > 0) {
                baseTmpRequestControls.add(new PagedResultsControl(pageSize, false));
            }
            Control[] baseRequestControls = baseTmpRequestControls.toArray(new Control[baseTmpRequestControls.size()]);
            ctx.setRequestControls(baseRequestControls);
            SearchControls searchControls = new SearchControls();
            if (this.isSubTreeSearch()) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setReturningAttributes(new String[]{attribute});
            int skip = -1;
            int lastRes = -1;
            if (!clientSideSort.booleanValue()) {
                if (startIndex != -1) {
                    skip = startIndex;
                }
                if (numResults != -1) {
                    lastRes = startIndex + numResults;
                }
            }
            int count = 0;
            do {
                cookie = null;
                answer = ctx.search("", searchFilter, searchControls);
                while (answer.hasMoreElements()) {
                    if (skip > 0 && ++count <= skip) {
                        answer.next();
                        continue;
                    }
                    if (lastRes != -1 && count > lastRes) {
                        answer.next();
                        break;
                    }
                    result = (String)answer.next().getAttributes().get(attribute).get();
                    if (suffixToTrim != null && suffixToTrim.length() > 0 && result.endsWith(suffixToTrim)) {
                        result = result.substring(0, result.length() - suffixToTrim.length());
                    }
                    results.add(escapeJIDs ? JID.escapeNode((String)result) : result);
                }
                if ((controls = ctx.getResponseControls()) != null) {
                    Control[] controlArray = controls;
                    int n = controlArray.length;
                    for (int i = 0; i < n; ++i) {
                        Control control = controlArray[i];
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                answer.close();
                tmpRequestControls = new ArrayList();
                if (!clientSideSort.booleanValue()) {
                    tmpRequestControls.add(new SortControl(new String[]{attribute}, false));
                }
                if (pageSize > 0) {
                    tmpRequestControls.add(new PagedResultsControl(pageSize, cookie, true));
                }
                requestControls = tmpRequestControls.toArray(new Control[tmpRequestControls.size()]);
                ctx.setRequestControls(requestControls);
            } while (cookie != null && (lastRes == -1 || count <= lastRes));
            if (this.alternateBaseDN != null && (lastRes == -1 || count <= lastRes)) {
                ctx2 = this.getContext(this.alternateBaseDN);
                ctx2.setRequestControls(baseRequestControls);
                do {
                    cookie = null;
                    answer = ctx2.search("", searchFilter, searchControls);
                    while (answer.hasMoreElements()) {
                        if (skip > 0 && ++count <= skip) {
                            answer.next();
                            continue;
                        }
                        if (lastRes != -1 && count > lastRes) {
                            answer.next();
                            break;
                        }
                        result = (String)answer.next().getAttributes().get(attribute).get();
                        if (suffixToTrim != null && suffixToTrim.length() > 0 && result.endsWith(suffixToTrim)) {
                            result = result.substring(0, result.length() - suffixToTrim.length());
                        }
                        results.add(escapeJIDs ? JID.escapeNode((String)result) : result);
                    }
                    if ((controls = ctx2.getResponseControls()) != null) {
                        for (Control control : controls) {
                            if (!(control instanceof PagedResultsResponseControl)) continue;
                            prrc = (PagedResultsResponseControl)control;
                            cookie = prrc.getCookie();
                        }
                    }
                    answer.close();
                    tmpRequestControls = new ArrayList();
                    if (!clientSideSort.booleanValue()) {
                        tmpRequestControls.add(new SortControl(new String[]{attribute}, false));
                    }
                    if (pageSize > 0) {
                        tmpRequestControls.add(new PagedResultsControl(pageSize, cookie, true));
                    }
                    requestControls = tmpRequestControls.toArray(new Control[tmpRequestControls.size()]);
                    ctx2.setRequestControls(requestControls);
                } while (cookie != null && (lastRes == -1 || count <= lastRes));
            }
            if (clientSideSort.booleanValue()) {
                Collections.sort(results);
                if (startIndex != -1 || numResults != -1) {
                    if (startIndex == -1) {
                        startIndex = 0;
                    }
                    if (numResults == -1) {
                        numResults = results.size();
                    }
                    int endIndex = Math.min(startIndex + numResults, results.size() - 1);
                    results = results.subList(startIndex, endIndex);
                }
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.setRequestControls(null);
                    ctx.close();
                }
                if (ctx2 != null) {
                    ctx2.setRequestControls(null);
                    ctx2.close();
                }
            }
            catch (Exception exception) {}
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer retrieveListCount(String attribute, String searchFilter) {
        int pageSize = -1;
        String pageSizeStr = this.properties.get("ldap.pagedResultsSize");
        if (pageSizeStr != null) {
            try {
                pageSize = Integer.parseInt(pageSizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LdapContext ctx = null;
        LdapContext ctx2 = null;
        Integer count = 0;
        try {
            Control[] requestControls;
            Object tmpRequestControls;
            PagedResultsResponseControl prrc;
            Object controls;
            NamingEnumeration<SearchResult> answer;
            byte[] cookie;
            ctx = this.getContext(this.baseDN);
            ArrayList<PagedResultsControl> baseTmpRequestControls = new ArrayList<PagedResultsControl>();
            if (pageSize > 0) {
                baseTmpRequestControls.add(new PagedResultsControl(pageSize, false));
            }
            Control[] baseRequestControls = baseTmpRequestControls.toArray(new Control[baseTmpRequestControls.size()]);
            ctx.setRequestControls(baseRequestControls);
            SearchControls searchControls = new SearchControls();
            if (this.isSubTreeSearch()) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setReturningAttributes(new String[]{attribute});
            do {
                Object object;
                cookie = null;
                answer = ctx.search("", searchFilter, searchControls);
                while (answer.hasMoreElements()) {
                    answer.next();
                    Integer n = count;
                    count = count + 1;
                    object = count;
                }
                controls = ctx.getResponseControls();
                if (controls != null) {
                    object = controls;
                    int n = ((Control[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Control control = object[i];
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                answer.close();
                tmpRequestControls = new ArrayList();
                if (pageSize > 0) {
                    tmpRequestControls.add(new PagedResultsControl(pageSize, cookie, true));
                }
                requestControls = tmpRequestControls.toArray(new Control[tmpRequestControls.size()]);
                ctx.setRequestControls(requestControls);
            } while (cookie != null);
            if (this.alternateBaseDN != null) {
                ctx2 = this.getContext(this.alternateBaseDN);
                ctx2.setRequestControls(baseRequestControls);
                do {
                    cookie = null;
                    answer = ctx2.search("", searchFilter, searchControls);
                    while (answer.hasMoreElements()) {
                        answer.next();
                        controls = count;
                        count = count + 1;
                        tmpRequestControls = count;
                    }
                    controls = ctx2.getResponseControls();
                    if (controls != null) {
                        for (Control control : controls) {
                            if (!(control instanceof PagedResultsResponseControl)) continue;
                            prrc = (PagedResultsResponseControl)control;
                            cookie = prrc.getCookie();
                        }
                    }
                    answer.close();
                    tmpRequestControls = new ArrayList();
                    if (pageSize > 0) {
                        tmpRequestControls.add(new PagedResultsControl(pageSize, cookie, true));
                    }
                    requestControls = tmpRequestControls.toArray(new Control[tmpRequestControls.size()]);
                    ctx2.setRequestControls(requestControls);
                } while (cookie != null);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.setRequestControls(null);
                    ctx.close();
                }
                if (ctx2 != null) {
                    ctx2.setRequestControls(null);
                    ctx2.close();
                }
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public static String sanitizeSearchFilter(String value) {
        return LdapManager.sanitizeSearchFilter(value, false);
    }

    public static String sanitizeSearchFilter(String value, boolean acceptWildcard) {
        StringBuilder result = new StringBuilder();
        block12: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '!': {
                    result.append("\\21");
                    continue block12;
                }
                case '&': {
                    result.append("\\26");
                    continue block12;
                }
                case '(': {
                    result.append("\\28");
                    continue block12;
                }
                case ')': {
                    result.append("\\29");
                    continue block12;
                }
                case '*': {
                    result.append(acceptWildcard ? "*" : "\\2a");
                    continue block12;
                }
                case ':': {
                    result.append("\\3a");
                    continue block12;
                }
                case '\\': {
                    result.append("\\5c");
                    continue block12;
                }
                case '|': {
                    result.append("\\7c");
                    continue block12;
                }
                case '~': {
                    result.append("\\7e");
                    continue block12;
                }
                case '\u0000': {
                    result.append("\\00");
                    continue block12;
                }
                default: {
                    if (c <= '\u007f') {
                        result.append(String.valueOf(c));
                        continue block12;
                    }
                    if (c < '\u0080') continue block12;
                    if (JiveGlobals.getBooleanProperty("ldap.encodeMultibyteCharacters", false)) {
                        byte[] utf8bytes;
                        for (byte b : utf8bytes = String.valueOf(c).getBytes(StandardCharsets.UTF_8)) {
                            result.append(String.format("\\%02x", b));
                        }
                        continue block12;
                    }
                    result.append(String.valueOf(c));
                }
            }
        }
        return result.toString();
    }

    public static String getEnclosedDN(String dnValue) {
        if (dnValue == null || dnValue.equals("")) {
            return dnValue;
        }
        if (dnPattern == null) {
            dnPattern = Pattern.compile("([^\\\\]=)([^\"]*?[^\\\\])(,|$)");
        }
        Matcher matcher = dnPattern.matcher(dnValue);
        dnValue = matcher.replaceAll("$1\"$2\"$3");
        dnValue = dnValue.replace("\\,", ",");
        return dnValue;
    }

    static {
        Map<String, String> properties = new Map<String, String>(){

            @Override
            public String get(Object key) {
                return JiveGlobals.getProperty((String)key);
            }

            @Override
            public String put(String key, String value) {
                JiveGlobals.setProperty(key, value);
                return null;
            }

            @Override
            public String remove(Object key) {
                JiveGlobals.deleteProperty((String)key);
                return null;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean containsKey(Object key) {
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                return false;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> t) {
            }

            @Override
            public void clear() {
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public Collection<String> values() {
                return null;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return null;
            }
        };
        instance = new LdapManager(properties);
    }

    private static class DNCacheEntry {
        private final String userDN;
        private final String baseDN;

        public DNCacheEntry(String userDN, String baseDN) {
            this.userDN = userDN;
            this.baseDN = baseDN;
        }

        public String getUserDN() {
            return this.userDN;
        }

        public String getBaseDN() {
            return this.baseDN;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DNCacheEntry that = (DNCacheEntry)o;
            if (this.userDN != null ? !this.userDN.equals(that.userDN) : that.userDN != null) {
                return false;
            }
            return this.baseDN != null ? this.baseDN.equals(that.baseDN) : that.baseDN == null;
        }

        public int hashCode() {
            int result = this.userDN != null ? this.userDN.hashCode() : 0;
            result = 31 * result + (this.baseDN != null ? this.baseDN.hashCode() : 0);
            return result;
        }
    }
}

