/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import javax.naming.CommunicationException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapAuthProvider
implements AuthProvider {
    private static final Logger Log = LoggerFactory.getLogger(LdapAuthProvider.class);
    private LdapManager manager;
    private Cache<String, String> authCache = null;

    public LdapAuthProvider() {
        JiveGlobals.migrateProperty("ldap.authCache.enabled");
        this.manager = LdapManager.getInstance();
        if (JiveGlobals.getBooleanProperty("ldap.authCache.enabled", false)) {
            String cacheName = "LDAP Authentication";
            this.authCache = CacheFactory.createCache(cacheName);
        }
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException {
        if (username == null || password == null || "".equals(password.trim())) {
            throw new UnauthorizedException();
        }
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UnauthorizedException();
            }
        }
        username = JID.unescapeNode((String)username);
        if (this.authCache != null && this.authCache.containsKey(username)) {
            String hash = (String)this.authCache.get(username);
            if (StringUtils.hash(password).equals(hash)) {
                return;
            }
        }
        try {
            String userDN = this.manager.findUserDN(username);
            if (!this.manager.checkAuthentication(userDN, password)) {
                throw new UnauthorizedException("Username and password don't match");
            }
        }
        catch (CommunicationException e) {
            Log.error("Error connecting to LDAP server", (Throwable)e);
            throw new UnauthorizedException(e);
        }
        catch (Exception e) {
            throw new UnauthorizedException(e);
        }
        if (this.authCache != null) {
            this.authCache.put(username, StringUtils.hash(password));
        }
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        return false;
    }

    @Override
    public boolean isScramSupported() {
        return false;
    }

    @Override
    public String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }
}

