/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.CertificateStoreConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreWatcher {
    private static final Logger Log = LoggerFactory.getLogger(CertificateStoreWatcher.class);
    private final Map<CertificateStore, Path> watchedStores = new HashMap<CertificateStore, Path>();
    private final Map<Path, WatchKey> watchedPaths = new HashMap<Path, WatchKey>();
    private WatchService storeWatcher;
    private ExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    public CertificateStoreWatcher() {
        try {
            this.storeWatcher = FileSystems.getDefault().newWatchService();
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!CertificateStoreWatcher.this.executorService.isShutdown()) {
                        WatchKey key;
                        try {
                            key = CertificateStoreWatcher.this.storeWatcher.poll(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        if (key == null) continue;
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                            Map map = CertificateStoreWatcher.this.watchedStores;
                            synchronized (map) {
                                WatchEvent<?> ev = event;
                                Path changedFile = ((Path)key.watchable()).resolve((Path)ev.context());
                                for (CertificateStore store : CertificateStoreWatcher.this.watchedStores.keySet()) {
                                    Path storeFile = store.getConfiguration().getFile().toPath().normalize();
                                    if (!storeFile.equals(changedFile)) continue;
                                    try (FileInputStream is = new FileInputStream(changedFile.toFile());){
                                        KeyStore tmpStore = KeyStore.getInstance(store.getConfiguration().getType());
                                        tmpStore.load(is, store.getConfiguration().getPassword());
                                    }
                                    catch (EOFException e) {
                                        Log.debug("The keystore is still being modified. Ignore for now. A new event should be thrown later.", (Throwable)e);
                                        break;
                                    }
                                    catch (Exception e) {
                                        Log.debug("Can't read the modified keystore with this config. Continue iterating over configs.", (Throwable)e);
                                        continue;
                                    }
                                    Log.info("A file system change was detected. A(nother) certificate store that is backed by file '{}' will be reloaded.", (Object)storeFile);
                                    try {
                                        store.reload();
                                    }
                                    catch (CertificateStoreConfigException e) {
                                        Log.warn("An unexpected exception occurred while trying to reload a certificate store that is backed by file '{}'!", (Object)storeFile, (Object)e);
                                    }
                                }
                            }
                        }
                        key.reset();
                    }
                }
            });
        }
        catch (UnsupportedOperationException e) {
            this.storeWatcher = null;
            Log.info("This file system does not support watching file system objects for changes and events. Changes to Openfire certificate stores made outside of Openfire might not be detected. A restart of Openfire might be required for these to be applied.");
        }
        catch (IOException e) {
            this.storeWatcher = null;
            Log.warn("An exception occured while trying to create a service that monitors the Openfire certificate stores for changes. Changes to Openfire certificate stores made outside of Openfire might not be detected. A restart of Openfire might be required for these to be applied.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        Map<CertificateStore, Path> map = this.watchedStores;
        synchronized (map) {
            if (this.storeWatcher != null) {
                try {
                    this.storeWatcher.close();
                }
                catch (IOException e) {
                    Log.warn("Unable to close the watcherservice that is watching for file system changes to certificate stores.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(CertificateStore store) {
        if (store == null) {
            throw new IllegalArgumentException("Argument 'store' cannot be null.");
        }
        if (this.storeWatcher == null) {
            return;
        }
        Path dir = store.getConfiguration().getFile().toPath().normalize().getParent();
        Map<CertificateStore, Path> map = this.watchedStores;
        synchronized (map) {
            this.watchedStores.put(store, dir);
            if (!this.watchedPaths.containsKey(dir)) {
                try {
                    WatchKey watchKey = dir.register(this.storeWatcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                    this.watchedPaths.put(dir, watchKey);
                }
                catch (Throwable t) {
                    Log.warn("Unable to add a watcher for a path that contains files that provides the backend storage for certificate stores. Changes to those files are unlikely to be picked up automatically. Path: {}", (Object)dir, (Object)t);
                    this.watchedStores.remove(store);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unwatch(CertificateStore store) {
        if (store == null) {
            throw new IllegalArgumentException("Argument 'store' cannot be null.");
        }
        Map<CertificateStore, Path> map = this.watchedStores;
        synchronized (map) {
            this.watchedStores.remove(store);
            Path dir = store.getConfiguration().getFile().toPath().normalize().getParent();
            if (this.watchedStores.containsValue(dir)) {
                return;
            }
            WatchKey key = this.watchedPaths.remove(dir);
            if (key != null) {
                key.cancel();
            }
        }
    }
}

