/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.StreamError;

public class IQRegisterHandler
extends IQHandler
implements ServerFeaturesProvider {
    private static final Logger Log = LoggerFactory.getLogger(IQRegisterHandler.class);
    private static boolean registrationEnabled;
    private static boolean canChangePassword;
    private static Element probeResult;
    private UserManager userManager;
    private RosterManager rosterManager;
    private IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:register");

    public IQRegisterHandler() {
        super("XMPP Registration Handler");
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.userManager = server.getUserManager();
        this.rosterManager = server.getRosterManager();
        if (probeResult == null) {
            probeResult = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:register"));
            probeResult.addElement("username");
            probeResult.addElement("password");
            probeResult.addElement("email");
            probeResult.addElement("name");
            DataForm registrationForm = new DataForm(DataForm.Type.form);
            registrationForm.setTitle("XMPP Client Registration");
            registrationForm.addInstruction("Please provide the following information");
            FormField fieldForm = registrationForm.addField();
            fieldForm.setVariable("FORM_TYPE");
            fieldForm.setType(FormField.Type.hidden);
            fieldForm.addValue((Object)"jabber:iq:register");
            FormField fieldUser = registrationForm.addField();
            fieldUser.setVariable("username");
            fieldUser.setType(FormField.Type.text_single);
            fieldUser.setLabel("Username");
            fieldUser.setRequired(true);
            FormField fieldName = registrationForm.addField();
            fieldName.setVariable("name");
            fieldName.setType(FormField.Type.text_single);
            fieldName.setLabel("Full name");
            if (UserManager.getUserProvider().isNameRequired()) {
                fieldName.setRequired(true);
            }
            FormField fieldMail = registrationForm.addField();
            fieldMail.setVariable("email");
            fieldMail.setType(FormField.Type.text_single);
            fieldMail.setLabel("Email");
            if (UserManager.getUserProvider().isEmailRequired()) {
                fieldMail.setRequired(true);
            }
            FormField fieldPwd = registrationForm.addField();
            fieldPwd.setVariable("password");
            fieldPwd.setType(FormField.Type.text_private);
            fieldPwd.setLabel("Password");
            fieldPwd.setRequired(true);
            probeResult.add(registrationForm.getElement());
        }
        JiveGlobals.migrateProperty("register.inband");
        JiveGlobals.migrateProperty("register.password");
        registrationEnabled = JiveGlobals.getBooleanProperty("register.inband", true);
        canChangePassword = JiveGlobals.getBooleanProperty("register.password", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IQ handleIQ(IQ packet) throws PacketException, UnauthorizedException {
        IQ reply;
        ClientSession session;
        block42: {
            block44: {
                session = this.sessionManager.getSession(packet.getFrom());
                reply = null;
                if (session == null) {
                    Log.error("Error during registration. Session not found in " + this.sessionManager.getPreAuthenticatedKeys() + " for key " + packet.getFrom());
                    reply = IQ.createResultIQ((IQ)packet);
                    reply.setChildElement(packet.getChildElement().createCopy());
                    reply.setError(PacketError.Condition.internal_server_error);
                    return reply;
                }
                if (!IQ.Type.get.equals((Object)packet.getType())) break block44;
                if (!registrationEnabled) {
                    reply = IQ.createResultIQ((IQ)packet);
                    reply.setChildElement(packet.getChildElement().createCopy());
                    reply.setError(PacketError.Condition.forbidden);
                    break block42;
                } else {
                    reply = IQ.createResultIQ((IQ)packet);
                    if (session.getStatus() == 3) {
                        try {
                            User user = this.userManager.getUser(session.getUsername());
                            Element currentRegistration = probeResult.createCopy();
                            currentRegistration.addElement("registered");
                            currentRegistration.element("username").setText(user.getUsername());
                            currentRegistration.element("password").setText("");
                            currentRegistration.element("email").setText(user.getEmail() == null ? "" : user.getEmail());
                            currentRegistration.element("name").setText(user.getName());
                            Element form = currentRegistration.element(QName.get((String)"x", (String)"jabber:x:data"));
                            Iterator fields = form.elementIterator("field");
                            while (fields.hasNext()) {
                                Element field = (Element)fields.next();
                                if ("username".equals(field.attributeValue("var"))) {
                                    field.addElement("value").addText(user.getUsername());
                                    continue;
                                }
                                if ("name".equals(field.attributeValue("var"))) {
                                    field.addElement("value").addText(user.getName());
                                    continue;
                                }
                                if (!"email".equals(field.attributeValue("var"))) continue;
                                field.addElement("value").addText(user.getEmail() == null ? "" : user.getEmail());
                            }
                            reply.setChildElement(currentRegistration);
                        }
                        catch (UserNotFoundException e) {
                            reply.setChildElement(probeResult.createCopy());
                        }
                        break block42;
                    } else {
                        reply.setTo((JID)null);
                        reply.setChildElement(probeResult.createCopy());
                    }
                }
                break block42;
            }
            if (!IQ.Type.set.equals((Object)packet.getType())) break block42;
            try {
                User newUser;
                String name;
                block43: {
                    String username;
                    String email;
                    String password;
                    block45: {
                        Element iqElement = packet.getChildElement();
                        if (iqElement.element("remove") != null) {
                            if (!registrationEnabled) {
                                reply = IQ.createResultIQ((IQ)packet);
                                reply.setChildElement(packet.getChildElement().createCopy());
                                reply.setError(PacketError.Condition.forbidden);
                                break block42;
                            } else {
                                if (session.getStatus() != 3) {
                                    throw new UnauthorizedException();
                                }
                                User user = this.userManager.getUser(session.getUsername());
                                this.userManager.deleteUser(user);
                                this.rosterManager.deleteRoster(session.getAddress());
                                GroupManager.getInstance().deleteUser(user);
                                reply = IQ.createResultIQ((IQ)packet);
                                session.process((Packet)reply);
                                Thread.sleep(10L);
                                StreamError error = new StreamError(StreamError.Condition.not_authorized);
                                Iterator<ClientSession> fields = this.sessionManager.getSessions(user.getUsername()).iterator();
                                while (fields.hasNext()) {
                                    ClientSession sess = fields.next();
                                    sess.deliverRawText(error.toXML());
                                    sess.close();
                                }
                                return null;
                            }
                        }
                        password = null;
                        email = null;
                        name = null;
                        Element formElement = iqElement.element("x");
                        if (formElement != null) {
                            DataForm registrationForm = new DataForm(formElement);
                            List values = registrationForm.getField("username").getValues();
                            username = !values.isEmpty() ? (String)values.get(0) : " ";
                            FormField field = registrationForm.getField("password");
                            if (field != null) {
                                values = field.getValues();
                                String string = password = !values.isEmpty() ? (String)values.get(0) : " ";
                            }
                            if ((field = registrationForm.getField("email")) != null) {
                                values = field.getValues();
                                String string = email = !values.isEmpty() ? (String)values.get(0) : " ";
                            }
                            if ((field = registrationForm.getField("name")) != null) {
                                values = field.getValues();
                                name = !values.isEmpty() ? (String)values.get(0) : " ";
                            }
                        } else {
                            username = iqElement.elementText("username");
                            password = iqElement.elementText("password");
                            email = iqElement.elementText("email");
                            name = iqElement.elementText("name");
                        }
                        if (email != null && email.matches("\\s*")) {
                            email = null;
                        }
                        if (name != null && name.matches("\\s*")) {
                            name = null;
                        }
                        if (username != null) {
                            Stringprep.nodeprep((String)username);
                        }
                        if (session.getStatus() != 3) break block45;
                        boolean onlyPassword = false;
                        if (iqElement.elements().size() == 2 && iqElement.element("username") != null && iqElement.element("password") != null) {
                            onlyPassword = true;
                        }
                        if (password != null && !canChangePassword) {
                            reply = IQ.createResultIQ((IQ)packet);
                            reply.setChildElement(packet.getChildElement().createCopy());
                            reply.setError(PacketError.Condition.forbidden);
                            return reply;
                        }
                        if (!onlyPassword && !registrationEnabled) {
                            reply = IQ.createResultIQ((IQ)packet);
                            reply.setChildElement(packet.getChildElement().createCopy());
                            reply.setError(PacketError.Condition.forbidden);
                            return reply;
                        }
                        User user = this.userManager.getUser(session.getUsername());
                        if (user.getUsername().equalsIgnoreCase(username)) {
                            if (password != null && password.trim().length() > 0) {
                                user.setPassword(password);
                            }
                            if (!onlyPassword) {
                                user.setEmail(email);
                            }
                            newUser = user;
                            break block43;
                        } else if (password != null && password.trim().length() > 0) {
                            newUser = this.userManager.createUser(username, password, null, email);
                            break block43;
                        } else {
                            reply = IQ.createResultIQ((IQ)packet);
                            reply.setChildElement(packet.getChildElement().createCopy());
                            reply.setError(PacketError.Condition.not_acceptable);
                            return reply;
                        }
                    }
                    if (!registrationEnabled) {
                        reply = IQ.createResultIQ((IQ)packet);
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.forbidden);
                        return reply;
                    }
                    if (password == null || password.trim().length() == 0) {
                        reply = IQ.createResultIQ((IQ)packet);
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.not_acceptable);
                        return reply;
                    }
                    newUser = this.userManager.createUser(username, password, name, email);
                }
                if (newUser != null && name != null && !name.equals(newUser.getName())) {
                    newUser.setName(name);
                }
                reply = IQ.createResultIQ((IQ)packet);
            }
            catch (UserAlreadyExistsException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.conflict);
            }
            catch (UserNotFoundException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.bad_request);
            }
            catch (StringprepException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.jid_malformed);
            }
            catch (IllegalArgumentException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.not_acceptable);
                Log.warn(e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.not_allowed);
            }
            catch (Exception e) {
                reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.internal_server_error);
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (reply == null) return null;
        session.process((Packet)reply);
        return null;
    }

    public boolean isInbandRegEnabled() {
        return registrationEnabled && !UserManager.getUserProvider().isReadOnly();
    }

    public void setInbandRegEnabled(boolean allowed) {
        if (allowed && UserManager.getUserProvider().isReadOnly()) {
            Log.warn("Enabling in-band registration has no effect, as the user provider for this system is read-only.");
        }
        JiveGlobals.setProperty("register.inband", (registrationEnabled = allowed) ? "true" : "false");
    }

    public boolean canChangePassword() {
        return canChangePassword && !UserManager.getUserProvider().isReadOnly();
    }

    public void setCanChangePassword(boolean allowed) {
        if (allowed && UserManager.getUserProvider().isReadOnly()) {
            Log.warn("Allowing password changes has no effect, as the user provider for this system is read-only.");
        }
        JiveGlobals.setProperty("register.password", (canChangePassword = allowed) ? "true" : "false");
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("jabber:iq:register").iterator();
    }
}

