/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import org.jivesoftware.openfire.ChannelHandler;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public abstract class IQHandler
extends BasicModule
implements ChannelHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQHandler.class);
    protected PacketDeliverer deliverer;
    protected SessionManager sessionManager;

    public IQHandler(String moduleName) {
        super(moduleName);
    }

    public void process(Packet packet) throws PacketException {
        IQ iq = (IQ)packet;
        try {
            IQ reply = this.handleIQ(iq);
            if (reply != null) {
                this.deliverer.deliver((Packet)reply);
            }
        }
        catch (UnauthorizedException e) {
            if (iq != null) {
                try {
                    IQ response = IQ.createResultIQ((IQ)iq);
                    response.setChildElement(iq.getChildElement().createCopy());
                    response.setError(PacketError.Condition.not_authorized);
                    this.sessionManager.getSession(iq.getFrom()).process((Packet)response);
                }
                catch (Exception de) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)de);
                    this.sessionManager.getSession(iq.getFrom()).close();
                }
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            try {
                IQ response = IQ.createResultIQ((IQ)iq);
                response.setChildElement(iq.getChildElement().createCopy());
                response.setError(PacketError.Condition.internal_server_error);
                this.sessionManager.getSession(iq.getFrom()).process((Packet)response);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract IQ handleIQ(IQ var1) throws UnauthorizedException;

    public abstract IQHandlerInfo getInfo();

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.deliverer = server.getPacketDeliverer();
        this.sessionManager = server.getSessionManager();
    }
}

