/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;

public class DirectedPresence
implements Externalizable {
    private byte[] nodeID;
    private JID handler;
    private Set<String> receivers = new HashSet<String>();

    public DirectedPresence() {
    }

    public DirectedPresence(JID handlerJID) {
        this.handler = handlerJID;
        this.nodeID = XMPPServer.getInstance().getNodeID().toByteArray();
    }

    public byte[] getNodeID() {
        return this.nodeID;
    }

    public JID getHandler() {
        return this.handler;
    }

    public Set<String> getReceivers() {
        return this.receivers;
    }

    public void addReceiver(String receiver) {
        this.receivers.add(receiver);
    }

    public void removeReceiver(String receiver) {
        this.receivers.remove(receiver);
    }

    public boolean isEmpty() {
        return this.receivers.isEmpty();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeByteArray(out, this.nodeID);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.handler);
        ExternalizableUtil.getInstance().writeStrings(out, this.receivers);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeID = ExternalizableUtil.getInstance().readByteArray(in);
        this.handler = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        ExternalizableUtil.getInstance().readStrings(in, this.receivers);
    }
}

