/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.forms.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.forms.FormField;

@Deprecated
public class XFormFieldImpl
implements FormField {
    private String description;
    private boolean required = false;
    private String label;
    private String variable;
    private String type;
    private List<Option> options = new ArrayList<Option>();
    private List<String> values = new ArrayList<String>();

    public XFormFieldImpl() {
    }

    public XFormFieldImpl(String variable) {
        this.variable = variable;
    }

    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setNamespace(String namespace) {
    }

    public String getName() {
        return "x";
    }

    public void setName(String name) {
    }

    public Element asXMLElement() {
        Element field = DocumentHelper.createElement((QName)QName.get((String)"field", (String)"jabber:x:data"));
        if (this.getLabel() != null) {
            field.addAttribute("label", this.getLabel());
        }
        if (this.getVariable() != null) {
            field.addAttribute("var", this.getVariable());
        }
        if (this.getType() != null) {
            field.addAttribute("type", this.getType());
        }
        if (this.getDescription() != null) {
            field.addElement("desc").addText(this.getDescription());
        }
        if (this.isRequired()) {
            field.addElement("required");
        }
        if (this.values.size() > 0) {
            Iterator<String> valuesItr = this.getValues();
            while (valuesItr.hasNext()) {
                field.addElement("value").addText(valuesItr.next());
            }
        }
        if (this.options.size() > 0) {
            Iterator<Option> optionsItr = this.getOptions();
            while (optionsItr.hasNext()) {
                field.add(optionsItr.next().asXMLElement());
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(String value) {
        if (value == null) {
            value = "";
        }
        List<String> list = this.values;
        synchronized (list) {
            this.values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearValues() {
        List<String> list = this.values;
        synchronized (list) {
            this.values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOption(String label, String value) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(new Option(label, value));
        }
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getValues() {
        List<String> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.values)).iterator();
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options)).iterator();
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void parse(Element formElement) {
        this.variable = formElement.attributeValue("var");
        this.setLabel(formElement.attributeValue("label"));
        this.setType(formElement.attributeValue("type"));
        Element descElement = formElement.element("desc");
        if (descElement != null) {
            this.setDescription(descElement.getTextTrim());
        }
        if (formElement.element("required") != null) {
            this.setRequired(true);
        }
        Iterator valueElements = formElement.elementIterator("value");
        while (valueElements.hasNext()) {
            this.addValue(((Element)valueElements.next()).getTextTrim());
        }
        Iterator optionElements = formElement.elementIterator("option");
        while (optionElements.hasNext()) {
            Element optionElement = (Element)optionElements.next();
            this.addOption(optionElement.attributeValue("label"), optionElement.elementTextTrim("value"));
        }
    }

    public String toString() {
        return "XFormFieldImpl " + Integer.toHexString(this.hashCode()) + " " + this.getVariable() + ">" + this.values + " o: " + (this.options.isEmpty() ? "no options" : this.options.toString());
    }

    private static class Option {
        private String label;
        private String value;

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public Element asXMLElement() {
            Element option = DocumentHelper.createElement((QName)QName.get((String)"option", (String)"jabber:x:data"));
            if (this.getLabel() != null) {
                option.addAttribute("label", this.getLabel());
            }
            if (this.getValue() != null) {
                option.addElement("value").addText(this.getValue());
            }
            return option;
        }
    }
}

