/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.filetransfer.proxy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.filetransfer.FileTransferManager;
import org.jivesoftware.openfire.filetransfer.FileTransferRejectedException;
import org.jivesoftware.openfire.filetransfer.proxy.DefaultProxyTransfer;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyOutputStream;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyTransfer;
import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.openfire.stats.StatisticsManager;
import org.jivesoftware.openfire.stats.i18nStatistic;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ProxyConnectionManager {
    private static final Logger Log = LoggerFactory.getLogger(ProxyConnectionManager.class);
    private static final String proxyTransferRate = "proxyTransferRate";
    private Cache<String, ProxyTransfer> connectionMap;
    private final Object connectionLock = new Object();
    private ExecutorService executor = Executors.newCachedThreadPool();
    private Future<?> socketProcess;
    private ServerSocket serverSocket;
    private int proxyPort;
    private FileTransferManager transferManager;
    private String className;

    public ProxyConnectionManager(FileTransferManager manager) {
        String cacheName = "File Transfer";
        this.connectionMap = CacheFactory.createCache(cacheName);
        this.className = JiveGlobals.getProperty("provider.transfer.proxy", "org.jivesoftware.openfire.filetransfer.proxy.DefaultProxyTransfer");
        this.transferManager = manager;
        StatisticsManager.getInstance().addStatistic(proxyTransferRate, new ProxyTracker());
    }

    synchronized void processConnections(final InetAddress bindInterface, final int port) {
        if (this.socketProcess != null && this.proxyPort == port) {
            return;
        }
        this.reset();
        this.socketProcess = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ProxyConnectionManager.this.serverSocket = new ServerSocket(port, -1, bindInterface);
                }
                catch (IOException e) {
                    Log.error("Error creating server socket", (Throwable)e);
                    return;
                }
                while (ProxyConnectionManager.this.serverSocket.isBound()) {
                    Socket socket;
                    try {
                        socket = ProxyConnectionManager.this.serverSocket.accept();
                    }
                    catch (IOException e) {
                        if (ProxyConnectionManager.this.serverSocket.isClosed()) break;
                        Log.error("Error accepting proxy connection", (Throwable)e);
                        continue;
                    }
                    ProxyConnectionManager.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ProxyConnectionManager.this.processConnection(socket);
                            }
                            catch (IOException ie) {
                                Log.error("Error processing file transfer proxy connection", (Throwable)ie);
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            }
        });
        this.proxyPort = port;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(Socket connection) throws IOException {
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        DataInputStream in = new DataInputStream(connection.getInputStream());
        int b = ((InputStream)in).read();
        if (b != 5) {
            throw new IOException("Only SOCKS5 supported");
        }
        b = ((InputStream)in).read();
        int[] auth = new int[b];
        for (int i = 0; i < b; ++i) {
            auth[i] = ((InputStream)in).read();
        }
        int authMethod = -1;
        for (int anAuth : auth) {
            int n = authMethod = anAuth == 0 ? 0 : -1;
            if (authMethod == 0) break;
        }
        if (authMethod != 0) {
            throw new IOException("Authentication method not supported");
        }
        byte[] cmd = new byte[]{5, 0};
        ((OutputStream)out).write(cmd);
        String responseDigest = ProxyConnectionManager.processIncomingSocks5Message(in);
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                ProxyTransfer transfer = (ProxyTransfer)this.connectionMap.get(responseDigest);
                if (transfer == null) {
                    transfer = this.createProxyTransfer(responseDigest, connection);
                    this.transferManager.registerProxyTransfer(responseDigest, transfer);
                    this.connectionMap.put(responseDigest, transfer);
                } else {
                    transfer.setInputStream(connection.getInputStream());
                }
            }
            cmd = ProxyConnectionManager.createOutgoingSocks5Message(0, responseDigest);
            ((OutputStream)out).write(cmd);
        }
        catch (UnauthorizedException eu) {
            cmd = ProxyConnectionManager.createOutgoingSocks5Message(2, responseDigest);
            ((OutputStream)out).write(cmd);
            throw new IOException("Illegal proxy transfer");
        }
    }

    private ProxyTransfer createProxyTransfer(String transferDigest, Socket targetSocket) throws IOException {
        ProxyTransfer provider;
        try {
            Class c = ClassUtils.forName(this.className);
            provider = (ProxyTransfer)c.newInstance();
        }
        catch (Exception e) {
            Log.error("Error loading proxy transfer provider: " + this.className, (Throwable)e);
            provider = new DefaultProxyTransfer();
        }
        provider.setTransferDigest(transferDigest);
        provider.setOutputStream(targetSocket.getOutputStream());
        return provider;
    }

    private static String processIncomingSocks5Message(InputStream in) throws IOException {
        byte[] cmd = new byte[5];
        int read = in.read(cmd, 0, 5);
        if (read != 5) {
            throw new IOException("Error reading Socks5 version and command");
        }
        byte[] addr = new byte[cmd[4]];
        read = in.read(addr, 0, addr.length);
        if (read != addr.length) {
            throw new IOException("Error reading provided address");
        }
        String digest = new String(addr);
        in.read();
        in.read();
        return digest;
    }

    private static byte[] createOutgoingSocks5Message(int cmd, String digest) {
        byte[] addr = digest.getBytes();
        byte[] data = new byte[7 + addr.length];
        data[0] = 5;
        data[1] = (byte)cmd;
        data[2] = 0;
        data[3] = 3;
        data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data, 5, addr.length);
        data[data.length - 2] = 0;
        data[data.length - 1] = 0;
        return data;
    }

    synchronized void shutdown() {
        this.disable();
        this.executor.shutdown();
        StatisticsManager.getInstance().removeStatistic(proxyTransferRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(JID initiator, JID target, String sid) {
        ProxyTransfer temp;
        final String digest = ProxyConnectionManager.createDigest(sid, initiator, target);
        Object object = this.connectionLock;
        synchronized (object) {
            temp = (ProxyTransfer)this.connectionMap.get(digest);
        }
        final ProxyTransfer transfer = temp;
        if (transfer == null || !transfer.isActivatable()) {
            throw new IllegalArgumentException("Transfer doesn't exist or is missing parameters");
        }
        transfer.setInitiator(initiator.toString());
        transfer.setTarget(target.toString());
        transfer.setSessionID(sid);
        transfer.setTransferFuture(this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ProxyConnectionManager.this.transferManager.fireFileTransferStart(transfer.getSessionID(), true);
                }
                catch (FileTransferRejectedException e) {
                    ProxyConnectionManager.this.notifyFailure(transfer, e);
                    return;
                }
                try {
                    transfer.doTransfer();
                    ProxyConnectionManager.this.transferManager.fireFileTransferCompleted(transfer.getSessionID(), true);
                }
                catch (IOException e) {
                    Log.error("Error during file transfer", (Throwable)e);
                    ProxyConnectionManager.this.transferManager.fireFileTransferCompleted(transfer.getSessionID(), false);
                }
                finally {
                    ProxyConnectionManager.this.connectionMap.remove(digest);
                }
            }
        }));
    }

    private void notifyFailure(ProxyTransfer transfer, FileTransferRejectedException e) {
    }

    public static String createDigest(String sessionID, JID initiator, JID target) {
        return StringUtils.hash(sessionID + initiator.getNode() + "@" + initiator.getDomain() + "/" + initiator.getResource() + target.getNode() + "@" + target.getDomain() + "/" + target.getResource(), "SHA-1");
    }

    public boolean isRunning() {
        return this.socketProcess != null && !this.socketProcess.isDone();
    }

    public void disable() {
        this.reset();
    }

    private void reset() {
        if (this.socketProcess != null) {
            this.socketProcess.cancel(true);
            this.socketProcess = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Log.warn("Error closing proxy listening socket", (Throwable)e);
            }
        }
    }

    private static class ProxyTracker
    extends i18nStatistic {
        public ProxyTracker() {
            super("filetransferproxy.transfered", Statistic.Type.rate);
        }

        @Override
        public double sample() {
            return (double)ProxyOutputStream.amountTransferred.getAndSet(0L) / 1000.0;
        }

        @Override
        public boolean isPartialSample() {
            return true;
        }
    }
}

