/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.entitycaps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.entitycaps.EntityCapabilities;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class EntityCapabilitiesManager
implements IQResultListener,
UserEventListener {
    private static final EntityCapabilitiesManager instance = new EntityCapabilitiesManager();
    private Cache<String, EntityCapabilities> entityCapabilitiesMap = CacheFactory.createLocalCache("Entity Capabilities");
    private Cache<JID, String> entityCapabilitiesUserMap = CacheFactory.createLocalCache("Entity Capabilities Users");
    private Map<String, EntityCapabilities> verAttributes = new HashMap<String, EntityCapabilities>();

    private EntityCapabilitiesManager() {
    }

    public static EntityCapabilitiesManager getInstance() {
        return instance;
    }

    public void process(Presence packet) {
        if (Presence.Type.unavailable == packet.getType()) {
            return;
        }
        Element capsElement = packet.getChildElement("c", "http://jabber.org/protocol/caps");
        if (capsElement == null) {
            return;
        }
        String hashAttribute = capsElement.attributeValue("hash");
        if (hashAttribute == null || hashAttribute.trim().length() == 0) {
            return;
        }
        String newVerAttribute = capsElement.attributeValue("ver");
        if (newVerAttribute == null || newVerAttribute.trim().length() == 0) {
            return;
        }
        if (this.isInCapsCache(newVerAttribute)) {
            this.entityCapabilitiesUserMap.put(packet.getFrom(), newVerAttribute);
        } else {
            IQ iq = new IQ(IQ.Type.get);
            iq.setTo(packet.getFrom());
            String serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
            iq.setFrom(serverName);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
            String packetId = iq.getID();
            EntityCapabilities caps = new EntityCapabilities();
            caps.setHashAttribute(hashAttribute);
            caps.setVerAttribute(newVerAttribute);
            this.verAttributes.put(packetId, caps);
            IQRouter iqRouter = XMPPServer.getInstance().getIQRouter();
            iqRouter.addIQResultListener(packetId, this);
            iqRouter.route(iq);
        }
    }

    private boolean isInCapsCache(String verAttribute) {
        return this.entityCapabilitiesMap.containsKey(verAttribute);
    }

    private boolean isValid(IQ packet) {
        if (packet.getType() != IQ.Type.result) {
            return false;
        }
        EntityCapabilities original = this.verAttributes.get(packet.getID());
        if (original == null) {
            return false;
        }
        String newVerHash = EntityCapabilitiesManager.generateVerHash(packet, original.getHashAttribute());
        return newVerHash.equals(original.getVerAttribute());
    }

    public static String generateVerHash(IQ packet, String algorithm) {
        StringBuilder s = new StringBuilder();
        List<String> discoIdentities = EntityCapabilitiesManager.getIdentitiesFrom(packet);
        Collections.sort(discoIdentities);
        for (String string : discoIdentities) {
            s.append(string);
            s.append('<');
        }
        List<String> discoFeatures = EntityCapabilitiesManager.getFeaturesFrom(packet);
        Collections.sort(discoFeatures);
        for (String string : discoFeatures) {
            s.append(string);
            s.append('<');
        }
        List<String> list = EntityCapabilitiesManager.getExtendedDataForms(packet);
        Collections.sort(list);
        for (String extendedDataForm : list) {
            s.append(extendedDataForm);
        }
        String string = StringUtils.hash(s.toString(), "SHA-1");
        return StringUtils.encodeBase64(StringUtils.decodeHex(string));
    }

    public void answerTimeout(String packetId) {
        this.verAttributes.remove(packetId);
    }

    public void receivedAnswer(IQ packet) {
        String packetId = packet.getID();
        if (this.isValid(packet)) {
            EntityCapabilities caps = this.verAttributes.get(packetId);
            List<String> identities = EntityCapabilitiesManager.getIdentitiesFrom(packet);
            for (String identity : identities) {
                caps.addIdentity(identity);
            }
            List<String> features = EntityCapabilitiesManager.getFeaturesFrom(packet);
            for (String feature : features) {
                caps.addFeature(feature);
            }
            this.entityCapabilitiesMap.put(caps.getVerAttribute(), caps);
            this.entityCapabilitiesUserMap.put(packet.getFrom(), caps.getVerAttribute());
        }
        this.verAttributes.remove(packetId);
    }

    public EntityCapabilities getEntityCapabilities(JID jid) {
        String verAttribute = (String)this.entityCapabilitiesUserMap.get(jid);
        return (EntityCapabilities)this.entityCapabilitiesMap.get(verAttribute);
    }

    private static List<String> getIdentitiesFrom(IQ packet) {
        ArrayList<String> discoIdentities = new ArrayList<String>();
        Element query = packet.getChildElement();
        Iterator identitiesIterator = query.elementIterator("identity");
        if (identitiesIterator != null) {
            while (identitiesIterator.hasNext()) {
                Element identityElement = (Element)identitiesIterator.next();
                StringBuilder discoIdentity = new StringBuilder();
                String cat = identityElement.attributeValue("category");
                String type = identityElement.attributeValue("type");
                String lang = identityElement.attributeValue("xml:lang");
                String name = identityElement.attributeValue("name");
                if (cat != null) {
                    discoIdentity.append(cat);
                }
                discoIdentity.append('/');
                if (type != null) {
                    discoIdentity.append(type);
                }
                discoIdentity.append('/');
                if (lang != null) {
                    discoIdentity.append(lang);
                }
                discoIdentity.append('/');
                if (name != null) {
                    discoIdentity.append(name);
                }
                discoIdentities.add(discoIdentity.toString());
            }
        }
        return discoIdentities;
    }

    private static List<String> getFeaturesFrom(IQ packet) {
        ArrayList<String> discoFeatures = new ArrayList<String>();
        Element query = packet.getChildElement();
        Iterator featuresIterator = query.elementIterator("feature");
        if (featuresIterator != null) {
            while (featuresIterator.hasNext()) {
                Element featureElement = (Element)featuresIterator.next();
                String discoFeature = featureElement.attributeValue("var");
                discoFeatures.add(discoFeature);
            }
        }
        return discoFeatures;
    }

    private static List<String> getExtendedDataForms(IQ packet) {
        ArrayList<String> results = new ArrayList<String>();
        Element query = packet.getChildElement();
        Iterator extensionIterator = query.elementIterator(QName.get((String)"x", (String)"jabber:x:data"));
        if (extensionIterator != null) {
            while (extensionIterator.hasNext()) {
                Element extensionElement = (Element)extensionIterator.next();
                StringBuilder formType = new StringBuilder();
                Iterator fieldIterator = extensionElement.elementIterator("field");
                ArrayList<String> vars = new ArrayList<String>();
                while (fieldIterator != null && fieldIterator.hasNext()) {
                    Element fieldElement = (Element)fieldIterator.next();
                    if (fieldElement.attributeValue("var").equals("FORM_TYPE")) {
                        formType.append(fieldElement.element("value").getText());
                        formType.append('<');
                        continue;
                    }
                    StringBuilder var = new StringBuilder();
                    var.append(fieldElement.attributeValue("var"));
                    var.append('<');
                    Iterator valIter = fieldElement.elementIterator("value");
                    ArrayList<String> values = new ArrayList<String>();
                    while (valIter != null && valIter.hasNext()) {
                        Element value = (Element)valIter.next();
                        values.add(value.getText());
                    }
                    Collections.sort(values);
                    for (String v : values) {
                        var.append(v);
                        var.append('<');
                    }
                    vars.add(var.toString());
                }
                Collections.sort(vars);
                for (String v : vars) {
                    formType.append(v);
                }
                results.add(formType.toString());
            }
        }
        return results;
    }

    @Override
    public void userDeleting(User user, Map<String, Object> params) {
        JID jid = XMPPServer.getInstance().createJID(user.getUsername(), null, true);
        String verHashOfUser = (String)this.entityCapabilitiesUserMap.remove(jid);
        for (String verHash : this.entityCapabilitiesUserMap.values()) {
            if (!verHash.equals(verHashOfUser)) continue;
            return;
        }
        this.entityCapabilitiesMap.remove(verHashOfUser);
    }

    @Override
    public void userCreated(User user, Map<String, Object> params) {
    }

    @Override
    public void userModified(User user, Map<String, Object> params) {
    }
}

