/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.crowd;

import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.crowd.CrowdUserProvider;
import org.jivesoftware.openfire.crowd.jaxb.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.vcard.DefaultVCardProvider;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdVCardProvider
extends DefaultVCardProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdVCardProvider.class);
    private static final String VCARD_TEMPLATE = "<vCard xmlns=\"vcard-temp\"><FN>@displayname@</FN><N><FAMILY>@lastname@</FAMILY><GIVEN>@firstname@</GIVEN></N><NICKNAME>@nickname@</NICKNAME><EMAIL><USERID>@email@</USERID></EMAIL></vCard>";
    private static final ConcurrentHashMap<String, Object> MUTEX = new ConcurrentHashMap();

    /*
     * Loose catch block
     */
    @Override
    public Element loadVCard(String username) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadvcard:" + username);
        }
        if (MUTEX.containsKey(username)) {
            return null;
        }
        try {
            MUTEX.put(username, username);
            Element vcard = super.loadVCard(username);
            if (vcard == null) {
                CrowdUserProvider userProvider = (CrowdUserProvider)UserManager.getUserProvider();
                try {
                    User user = userProvider.getCrowdUser(username);
                    String str = VCARD_TEMPLATE.replace("@displayname@", user.displayName).replace("@lastname@", user.lastName).replace("@firstname@", user.firstName).replace("@email@", user.email).replace("@nickname@", username);
                    SAXReader xmlReader = new SAXReader();
                    xmlReader.setEncoding("UTF-8");
                    vcard = xmlReader.read((Reader)new StringReader(str)).getRootElement();
                }
                catch (UserNotFoundException unfe) {
                    LOG.error("Unable to find user:" + String.valueOf(username) + " for loading its vcard", (Throwable)unfe);
                    Element element = null;
                    MUTEX.remove(username);
                    return element;
                }
                catch (DocumentException de) {
                    LOG.error("vcard parsing error", (Throwable)de);
                    Element element = null;
                    MUTEX.remove(username);
                    return element;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(vcard != null ? vcard.asXML() : "vcard is null");
                }
                if (vcard != null) {
                    try {
                        this.createVCard(username, vcard);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.error("Unable to create and store a new vcard for user:" + username + "; one already exists", (Throwable)aee);
                    }
                }
            }
            Element element = vcard;
            return element;
            {
                catch (RuntimeException re) {
                    LOG.error("Failure occured when loading a vcard for user:" + username, (Throwable)re);
                    throw re;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            MUTEX.remove(username);
        }
    }

    @Override
    public Element createVCard(String username, Element vCardElement) throws AlreadyExistsException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createvcard:" + vCardElement.asXML());
        }
        return super.createVCard(username, vCardElement);
    }

    @Override
    public Element updateVCard(String username, Element vCard) throws NotFoundException {
        Element nickNameNode = vCard.element("NICKNAME");
        Element displayNameNode = vCard.element("FN");
        Element nameNode = vCard.element("N");
        Element lastNameNode = nameNode.element("FAMILY");
        Element firstnameNode = nameNode.element("GIVEN");
        Element emailNode = vCard.element("EMAIL").element("USERID");
        CrowdUserProvider userProvider = (CrowdUserProvider)UserManager.getUserProvider();
        try {
            User user = userProvider.getCrowdUser(username);
            nickNameNode.setText(username);
            displayNameNode.setText(user.displayName);
            lastNameNode.setText(user.lastName);
            firstnameNode.setText(user.firstName);
            emailNode.setText(user.email);
        }
        catch (UserNotFoundException unfe) {
            LOG.error("Unable to find user:" + String.valueOf(username) + " for updating its vcard", (Throwable)unfe);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("updatevcard:" + vCard.asXML());
        }
        return super.updateVCard(username, vCard);
    }
}

