/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.crowd;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.crowd.CrowdManager;
import org.jivesoftware.openfire.crowd.jaxb.Group;
import org.jivesoftware.openfire.group.AbstractGroupProvider;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class CrowdGroupProvider
extends AbstractGroupProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdGroupProvider.class);
    private static final int CACHE_TTL = 3600;
    private static final String JIVE_CROWD_GROUPS_CACHE_TTL_SECS = "crowd.groups.cache.ttl.seconds";
    private static final String GROUP_CACHE_NAME = "crowdGroup";
    private static final String GROUP_MEMBERSHIP_CACHE_NAME = "crowdGroupMembership";
    private static final String USER_MEMBERSHIP_CACHE_NAME = "crowdUserMembership";
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ScheduledExecutorService crowdGroupSync = Executors.newSingleThreadScheduledExecutor();
    private static final CrowdManager manager = CrowdManager.getInstance();
    private static List<String> groups = new ArrayList<String>();
    private final XMPPServer server = XMPPServer.getInstance();

    public CrowdGroupProvider() {
        String propertyValue = JiveGlobals.getProperty(JIVE_CROWD_GROUPS_CACHE_TTL_SECS);
        int ttl = propertyValue == null || propertyValue.trim().length() == 0 ? 3600 : Integer.parseInt(propertyValue);
        Object groupMembershipCache = CacheFactory.createLocalCache(GROUP_MEMBERSHIP_CACHE_NAME);
        groupMembershipCache.setMaxCacheSize(-1);
        groupMembershipCache.setMaxLifetime(ttl * 1000);
        Object userMembershipCache = CacheFactory.createLocalCache(USER_MEMBERSHIP_CACHE_NAME);
        userMembershipCache.setMaxCacheSize(-1);
        userMembershipCache.setMaxLifetime(ttl * 1000);
        Object groupCache = CacheFactory.createLocalCache(GROUP_CACHE_NAME);
        groupCache.setMaxCacheSize(-1);
        groupCache.setMaxLifetime(ttl * 1000);
    }

    @Override
    public org.jivesoftware.openfire.group.Group getGroup(String name) throws GroupNotFoundException {
        try {
            Object groupCache = CacheFactory.createLocalCache(GROUP_CACHE_NAME);
            Group group = (Group)groupCache.get(name);
            if (group == null) {
                group = manager.getGroup(name);
                groupCache.put((String)name, (Group)group);
            }
            Collection<JID> members = this.getGroupMembers(name);
            List<JID> admins = Collections.emptyList();
            return new org.jivesoftware.openfire.group.Group(name, group.description, members, admins);
        }
        catch (RemoteException re) {
            LOG.error("Failure to load group:" + String.valueOf(name), (Throwable)re);
            throw new GroupNotFoundException(re);
        }
    }

    private Collection<JID> getGroupMembers(String groupName) {
        Object groupMembershipCache = CacheFactory.createLocalCache(GROUP_MEMBERSHIP_CACHE_NAME);
        Collection members = (Collection)groupMembershipCache.get(groupName);
        if (members != null) {
            return members;
        }
        try {
            List<String> users = manager.getGroupMembers(groupName);
            ArrayList<JID> results = new ArrayList<JID>();
            for (String username : users) {
                results.add(this.server.createJID(username, null));
            }
            groupMembershipCache.put((String)groupName, results);
            return results;
        }
        catch (RemoteException re) {
            LOG.error("Failure to get the members of crowd group:" + String.valueOf(groupName), (Throwable)re);
            groupMembershipCache.put((String)groupName, new ArrayList());
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<String> getGroupNames(JID user) {
        Object userMembershipCache = CacheFactory.createCache(USER_MEMBERSHIP_CACHE_NAME);
        List<String> groups = (List<String>)userMembershipCache.get(user);
        if (groups != null) {
            return groups;
        }
        try {
            groups = manager.getUserGroups(user.getNode());
            userMembershipCache.put((JID)user, groups);
            return groups;
        }
        catch (RemoteException re) {
            LOG.error("Failure to load the groups of user:" + String.valueOf(user), (Throwable)re);
            userMembershipCache.put((JID)user, new ArrayList());
            return Collections.emptyList();
        }
    }

    @Override
    public int getGroupCount() {
        lock.readLock().lock();
        try {
            int n = groups.size();
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public Collection<String> getGroupNames() {
        lock.readLock().lock();
        try {
            List<String> list = groups;
            return list;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroupNames(int startIndex, int numResults) {
        lock.readLock().lock();
        try {
            ArrayList<String> results = new ArrayList<String>(numResults);
            int i = 0;
            for (int j = startIndex; i < numResults && j < groups.size(); ++i, ++j) {
                results.add(groups.get(j));
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> search(String query) {
        lock.readLock().lock();
        try {
            ArrayList<String> results = new ArrayList<String>();
            if (query != null && query.trim().length() > 0) {
                if (query.endsWith("*")) {
                    query = query.substring(0, query.length() - 1);
                }
                if (query.startsWith("*")) {
                    query = query.substring(1);
                }
                query = query.toLowerCase();
                for (String groupName : groups) {
                    if (!groupName.toLowerCase().contains(query)) continue;
                    results.add(groupName);
                }
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> search(String query, int startIndex, int numResults) {
        lock.readLock().lock();
        try {
            ArrayList foundGroups = (ArrayList)this.search(query);
            ArrayList<String> results = new ArrayList<String>();
            int i = 0;
            for (int j = startIndex; i < numResults && j < foundGroups.size(); ++i, ++j) {
                results.add((String)foundGroups.get(j));
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSearchSupported() {
        return true;
    }

    @Override
    public Collection<String> search(String key, String value) {
        LOG.info("Search groups on attibutes not implemented yet");
        return Collections.emptyList();
    }

    static {
        String propertyValue = JiveGlobals.getProperty(JIVE_CROWD_GROUPS_CACHE_TTL_SECS);
        int ttl = propertyValue == null || propertyValue.trim().length() == 0 ? 3600 : Integer.parseInt(propertyValue);
        crowdGroupSync.scheduleAtFixedRate(new GroupSynch(), 0L, ttl, TimeUnit.SECONDS);
        JiveGlobals.setProperty(JIVE_CROWD_GROUPS_CACHE_TTL_SECS, String.valueOf(ttl));
    }

    static class GroupSynch
    implements Runnable {
        GroupSynch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("running synch with crowd...");
            CrowdManager manager = null;
            try {
                manager = CrowdManager.getInstance();
            }
            catch (Exception e) {
                LOG.error("Failure to load the Crowd manager", (Throwable)e);
                return;
            }
            List<String> allGroups = null;
            try {
                allGroups = manager.getAllGroupNames();
            }
            catch (RemoteException re) {
                LOG.error("Failure to fetch all crowd groups name", (Throwable)re);
                return;
            }
            if (allGroups != null && allGroups.size() > 0) {
                lock.writeLock().lock();
                try {
                    groups = allGroups;
                }
                finally {
                    lock.writeLock().unlock();
                }
            }
            LOG.info("crowd synch done, returned " + allGroups.size() + " groups");
        }
    }
}

