/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.crowd;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminProvider;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class CrowdAdminProvider
implements AdminProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdAdminProvider.class);
    private static final String JIVE_AUTHORIZED_GROUPS = "admin.authorizedGroups";

    @Override
    public List<JID> getAdmins() {
        ArrayList<JID> results = new ArrayList<JID>();
        GroupProvider provider = GroupManager.getInstance().getProvider();
        String groups = JiveGlobals.getProperty(JIVE_AUTHORIZED_GROUPS);
        groups = groups == null || groups.trim().length() == 0 ? "" : groups;
        JiveGlobals.setProperty(JIVE_AUTHORIZED_GROUPS, groups);
        StringTokenizer tokenizer = new StringTokenizer(groups, ",");
        while (tokenizer.hasMoreTokens()) {
            String groupName = tokenizer.nextToken().trim().toLowerCase();
            if (groupName == null || groupName.length() <= 0) continue;
            try {
                LOG.info("Adding admin users from group: " + groupName);
                Group group = provider.getGroup(groupName);
                if (group == null) continue;
                results.addAll(group.getMembers());
            }
            catch (GroupNotFoundException gnfe) {
                LOG.error("Error when trying to load the members of group:" + String.valueOf(groupName), (Throwable)gnfe);
            }
        }
        if (results.isEmpty()) {
            results.add(new JID("admin", XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("admin users: " + ((Object)results).toString());
        }
        return results;
    }

    @Override
    public void setAdmins(List<JID> admins) {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

