/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.admin.AdminConsole;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.util.JavaSpecVersion;
import org.jivesoftware.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginMetadataHelper {
    private static final Logger Log = LoggerFactory.getLogger(PluginMetadataHelper.class);

    public static String getParentPlugin(Plugin plugin) {
        return PluginMetadataHelper.getParentPlugin(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getParentPlugin(Path pluginDir) {
        String name = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/parentPlugin");
        if (name != null && !name.isEmpty()) {
            return name.toLowerCase();
        }
        return null;
    }

    public static String getCanonicalName(Plugin plugin) {
        return XMPPServer.getInstance().getPluginManager().getCanonicalName(plugin);
    }

    public static String getCanonicalName(Path pluginPath) {
        String pathFileName = pluginPath.getFileName().toString().toLowerCase();
        if (pluginPath.toFile().isDirectory()) {
            return pathFileName;
        }
        return pathFileName.substring(0, pathFileName.lastIndexOf(46));
    }

    public static String getName(Plugin plugin) {
        return PluginMetadataHelper.getName(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getName(Path pluginDir) {
        String name = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/name");
        String pluginName = PluginMetadataHelper.getCanonicalName(pluginDir);
        if (name != null) {
            return AdminConsole.getAdminText(name, pluginName);
        }
        return pluginName;
    }

    public static String getDescription(Plugin plugin) {
        return PluginMetadataHelper.getDescription(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getDescription(Path pluginDir) {
        String name = PluginMetadataHelper.getCanonicalName(pluginDir);
        String description = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/description");
        return AdminConsole.getAdminText(description, name);
    }

    public static String getAuthor(Plugin plugin) {
        return PluginMetadataHelper.getAuthor(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getAuthor(Path pluginDir) {
        return PluginMetadataHelper.getElementValue(pluginDir, "/plugin/author");
    }

    public static Version getVersion(Plugin plugin) {
        return PluginMetadataHelper.getVersion(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static Version getVersion(Path pluginDir) {
        String value = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/version");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return new Version(value);
    }

    public static Version getMinServerVersion(Plugin plugin) {
        return PluginMetadataHelper.getMinServerVersion(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static Version getMinServerVersion(Path pluginDir) {
        String value = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/minServerVersion");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return new Version(value);
    }

    public static Version getPriorToServerVersion(Plugin plugin) {
        return PluginMetadataHelper.getPriorToServerVersion(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static Version getPriorToServerVersion(Path pluginDir) {
        String value = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/priorToServerVersion");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return new Version(value);
    }

    public static JavaSpecVersion getMinJavaVersion(Plugin plugin) {
        return PluginMetadataHelper.getMinJavaVersion(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static JavaSpecVersion getMinJavaVersion(Path pluginDir) {
        String value = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/minJavaVersion");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return new JavaSpecVersion(value);
    }

    public static String getDatabaseKey(Plugin plugin) {
        return PluginMetadataHelper.getDatabaseKey(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getDatabaseKey(Path pluginDir) {
        return PluginMetadataHelper.getElementValue(pluginDir, "/plugin/databaseKey");
    }

    public static int getDatabaseVersion(Plugin plugin) {
        return PluginMetadataHelper.getDatabaseVersion(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static int getDatabaseVersion(Path pluginDir) {
        String versionString = PluginMetadataHelper.getElementValue(pluginDir, "/plugin/databaseVersion");
        if (versionString != null) {
            try {
                return Integer.parseInt(versionString.trim());
            }
            catch (NumberFormatException nfe) {
                Log.error("Unable to parse the database version for plugin '{}'.", (Object)PluginMetadataHelper.getCanonicalName(pluginDir), (Object)nfe);
            }
        }
        return -1;
    }

    public static String getLicense(Plugin plugin) {
        return PluginMetadataHelper.getLicense(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static String getLicense(Path pluginDir) {
        return PluginMetadataHelper.getElementValue(pluginDir, "/plugin/licenseType");
    }

    public static URL getIcon(Plugin plugin) {
        return PluginMetadataHelper.getIcon(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static URL getIcon(Path pluginDir) {
        Path icon = pluginDir.resolve("logo_small.png");
        if (!icon.toFile().exists()) {
            icon = pluginDir.resolve("logo_small.gif");
        }
        if (!icon.toFile().exists()) {
            return null;
        }
        try {
            return icon.toUri().toURL();
        }
        catch (MalformedURLException e) {
            Log.warn("Unable to parse URL for icon of plugin '{}'.", (Object)PluginMetadataHelper.getCanonicalName(pluginDir), (Object)e);
            return null;
        }
    }

    public static URL getReadme(Plugin plugin) {
        return PluginMetadataHelper.getReadme(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static URL getReadme(Path pluginDir) {
        Path file = pluginDir.resolve("readme.html");
        if (!file.toFile().exists()) {
            return null;
        }
        try {
            return file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            Log.warn("Unable to parse URL for readme of plugin '{}'.", (Object)PluginMetadataHelper.getCanonicalName(pluginDir), (Object)e);
            return null;
        }
    }

    public static URL getChangelog(Plugin plugin) {
        return PluginMetadataHelper.getChangelog(XMPPServer.getInstance().getPluginManager().getPluginPath(plugin));
    }

    public static URL getChangelog(Path pluginDir) {
        Path file = pluginDir.resolve("changelog.html");
        if (!file.toFile().exists()) {
            return null;
        }
        try {
            return file.toUri().toURL();
        }
        catch (MalformedURLException e) {
            Log.warn("Unable to parse URL for changelog of plugin '{}'.", (Object)PluginMetadataHelper.getCanonicalName(pluginDir), (Object)e);
            return null;
        }
    }

    static String getElementValue(Path pluginDir, String xpath) {
        if (pluginDir == null) {
            return null;
        }
        try {
            Path pluginConfig = pluginDir.resolve("plugin.xml");
            if (Files.exists(pluginConfig, new LinkOption[0])) {
                SAXReader saxReader = new SAXReader();
                saxReader.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        throw new IOException("External entity denied: " + publicId + " // " + systemId);
                    }
                });
                saxReader.setEncoding("UTF-8");
                Document pluginXML = saxReader.read(pluginConfig.toFile());
                Element element = (Element)pluginXML.selectSingleNode(xpath);
                if (element != null) {
                    return element.getTextTrim();
                }
            }
        }
        catch (Exception e) {
            Log.error("Unable to get element value '{}' from plugin.xml of plugin in '{}':", new Object[]{xpath, pluginDir, e});
        }
        return null;
    }
}

