/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.container.CacheInfo;
import org.jivesoftware.openfire.container.IsPluginInstalledTask;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCacheRegistry {
    private static final Logger Log = LoggerFactory.getLogger(PluginCacheRegistry.class);
    private static final PluginCacheRegistry instance = new PluginCacheRegistry();
    private Map<String, CacheInfo> extraCacheMappings = new HashMap<String, CacheInfo>();
    private Map<String, List<CacheInfo>> pluginCaches = new HashMap<String, List<CacheInfo>>();

    public static PluginCacheRegistry getInstance() {
        return instance;
    }

    private PluginCacheRegistry() {
    }

    public void registerCache(String pluginName, CacheInfo info) {
        this.extraCacheMappings.put(info.getCacheName(), info);
        List<CacheInfo> caches = this.pluginCaches.get(pluginName);
        if (caches == null) {
            caches = new ArrayList<CacheInfo>();
            this.pluginCaches.put(pluginName, caches);
        }
        caches.add(info);
        CacheFactory.setCacheTypeProperty(info.getCacheName(), info.getType().getName());
        CacheFactory.setMaxSizeProperty(info.getCacheName(), this.getMaxSizeFromProperty(info));
        CacheFactory.setMaxLifetimeProperty(info.getCacheName(), PluginCacheRegistry.getMaxLifetimeFromProperty(info));
        CacheFactory.setMinCacheSize(info.getCacheName(), this.getMinSizeFromProperty(info));
    }

    public void unregisterCaches(String pluginName) {
        List<CacheInfo> caches = this.pluginCaches.remove(pluginName);
        if (caches != null) {
            for (CacheInfo info : caches) {
                this.extraCacheMappings.remove(info.getCacheName());
                Collection<Object> answers = CacheFactory.doSynchronousClusterTask(new IsPluginInstalledTask(pluginName), false);
                for (Object installed : answers) {
                    if (!((Boolean)installed).booleanValue()) continue;
                    return;
                }
                try {
                    CacheFactory.destroyCache(info.getCacheName());
                }
                catch (Exception e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public CacheInfo getCacheInfo(String name) {
        return this.extraCacheMappings.get(name);
    }

    private long getMaxSizeFromProperty(CacheInfo cacheInfo) {
        String sizeProp = cacheInfo.getParams().get("back-size-high");
        if (sizeProp != null) {
            if ("0".equals(sizeProp)) {
                return -1L;
            }
            try {
                return Integer.parseInt(sizeProp);
            }
            catch (NumberFormatException nfe) {
                Log.warn("Unable to parse back-size-high for cache: " + cacheInfo.getCacheName());
            }
        }
        return 262144L;
    }

    private static long getMaxLifetimeFromProperty(CacheInfo cacheInfo) {
        String lifetimeProp = cacheInfo.getParams().get("back-expiry");
        if (lifetimeProp != null) {
            if ("0".equals(lifetimeProp)) {
                return -1L;
            }
            long factor = 1L;
            if (lifetimeProp.endsWith("m")) {
                factor = 60000L;
            } else if (lifetimeProp.endsWith("h")) {
                factor = 3600000L;
            } else if (lifetimeProp.endsWith("d")) {
                factor = 86400000L;
            }
            try {
                return Long.parseLong(lifetimeProp.substring(0, lifetimeProp.length() - 1)) * factor;
            }
            catch (NumberFormatException nfe) {
                Log.warn("Unable to parse back-expiry for cache: " + cacheInfo.getCacheName());
            }
        }
        return 21600000L;
    }

    private long getMinSizeFromProperty(CacheInfo cacheInfo) {
        String sizeProp = cacheInfo.getParams().get("back-size-low");
        if (sizeProp != null) {
            if ("0".equals(sizeProp)) {
                return -1L;
            }
            try {
                return Integer.parseInt(sizeProp);
            }
            catch (NumberFormatException nfe) {
                Log.warn("Unable to parse back-size-low for cache: " + cacheInfo.getCacheName());
            }
        }
        return 262144L;
    }
}

