/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class GroupCreated
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/event#group-created";
    }

    @Override
    public String getDefaultLabel() {
        return "Group created";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        String groupname;
        Element note = command.addElement("note");
        Map<String, List<String>> data = sessionData.getData();
        try {
            groupname = this.get(data, "groupName", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Group name required parameter.");
            return;
        }
        try {
            Group group = GroupManager.getInstance().getGroup(groupname, true);
            Map params = Collections.emptyMap();
            GroupEventDispatcher.dispatchEvent(group, GroupEventDispatcher.EventType.group_created, params);
        }
        catch (GroupNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("Group not found.");
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Dispatching a group created event.");
        form.addInstruction("Fill out this form to dispatch a group created event.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("The group name of the group that was created");
        field.setVariable("groupName");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

