/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.user;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class ChangeUserPassword
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#change-user-password";
    }

    @Override
    public String getDefaultLabel() {
        return "Change User Password";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData data, Element command) {
        User user;
        Element note = command.addElement("note");
        if (UserManager.getUserProvider().isReadOnly()) {
            note.addAttribute("type", "error");
            note.setText("Users are read only. Changing password is not allowed.");
            return;
        }
        JID account = new JID(data.getData().get("accountjid").get(0));
        String newPassword = data.getData().get("password").get(0);
        if (!XMPPServer.getInstance().isLocal(account)) {
            note.addAttribute("type", "error");
            note.setText("Cannot change password of remote user.");
            return;
        }
        try {
            user = UserManager.getInstance().getUser(account.getNode());
        }
        catch (UserNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("User does not exists.");
            return;
        }
        user.setPassword(newPassword);
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Changing a User Password");
        form.addInstruction("Fill out this form to change a user\u2019s password.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.jid_single);
        field.setLabel("The Jabber ID for this account");
        field.setVariable("accountjid");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.text_private);
        field.setLabel("The password for this account");
        field.setVariable("password");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) && !UserManager.getUserProvider().isReadOnly();
    }
}

