/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.AdHocCommandManager;
import org.jivesoftware.openfire.commands.admin.GetAdminConsoleInfo;
import org.jivesoftware.openfire.commands.admin.GetListActiveUsers;
import org.jivesoftware.openfire.commands.admin.GetNumberActiveUsers;
import org.jivesoftware.openfire.commands.admin.GetNumberOnlineUsers;
import org.jivesoftware.openfire.commands.admin.GetNumberUserSessions;
import org.jivesoftware.openfire.commands.admin.GetServerStats;
import org.jivesoftware.openfire.commands.admin.GetUsersPresence;
import org.jivesoftware.openfire.commands.admin.HttpBindStatus;
import org.jivesoftware.openfire.commands.admin.PacketsNotification;
import org.jivesoftware.openfire.commands.admin.group.AddGroup;
import org.jivesoftware.openfire.commands.admin.group.AddGroupUsers;
import org.jivesoftware.openfire.commands.admin.group.DeleteGroup;
import org.jivesoftware.openfire.commands.admin.group.DeleteGroupUsers;
import org.jivesoftware.openfire.commands.admin.group.GetListGroupUsers;
import org.jivesoftware.openfire.commands.admin.group.GetListGroups;
import org.jivesoftware.openfire.commands.admin.group.UpdateGroup;
import org.jivesoftware.openfire.commands.admin.user.AddUser;
import org.jivesoftware.openfire.commands.admin.user.AuthenticateUser;
import org.jivesoftware.openfire.commands.admin.user.ChangeUserPassword;
import org.jivesoftware.openfire.commands.admin.user.DeleteUser;
import org.jivesoftware.openfire.commands.admin.user.UserProperties;
import org.jivesoftware.openfire.commands.event.GroupAdminAdded;
import org.jivesoftware.openfire.commands.event.GroupAdminRemoved;
import org.jivesoftware.openfire.commands.event.GroupCreated;
import org.jivesoftware.openfire.commands.event.GroupDeleting;
import org.jivesoftware.openfire.commands.event.GroupMemberAdded;
import org.jivesoftware.openfire.commands.event.GroupMemberRemoved;
import org.jivesoftware.openfire.commands.event.GroupModified;
import org.jivesoftware.openfire.commands.event.UserCreated;
import org.jivesoftware.openfire.commands.event.UserDeleting;
import org.jivesoftware.openfire.commands.event.UserModified;
import org.jivesoftware.openfire.commands.event.VCardCreated;
import org.jivesoftware.openfire.commands.event.VCardDeleting;
import org.jivesoftware.openfire.commands.event.VCardModified;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.IQDiscoInfoHandler;
import org.jivesoftware.openfire.disco.IQDiscoItemsHandler;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.xmpp.forms.DataForm;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class AdHocCommandHandler
extends IQHandler
implements ServerFeaturesProvider,
DiscoInfoProvider,
DiscoItemsProvider {
    private static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private String serverName;
    private IQHandlerInfo info = new IQHandlerInfo("command", "http://jabber.org/protocol/commands");
    private IQDiscoInfoHandler infoHandler;
    private IQDiscoItemsHandler itemsHandler;
    private AdHocCommandManager manager = new AdHocCommandManager();

    public AdHocCommandHandler() {
        super("Ad-Hoc Commands Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        return this.manager.process(packet);
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(NAMESPACE).iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", "automation");
        identity.addAttribute("type", NAMESPACE.equals(node) ? "command-list" : "command-node");
        return Collections.singleton(identity).iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        return Arrays.asList(NAMESPACE, "jabber:x:data").iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        return null;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        if (NAMESPACE.equals(node)) {
            return true;
        }
        AdHocCommand command = this.manager.getCommand(node);
        return command != null && command.hasPermission(senderJID);
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        List<Object> answer = new ArrayList();
        if (!NAMESPACE.equals(node)) {
            answer = Collections.emptyList();
        } else {
            for (AdHocCommand command : this.manager.getCommands()) {
                if (!command.hasPermission(senderJID)) continue;
                DiscoItem item = new DiscoItem(new JID(this.serverName), command.getLabel(), command.getCode(), null);
                answer.add(item);
            }
        }
        return answer.iterator();
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.infoHandler = server.getIQDiscoInfoHandler();
        this.itemsHandler = server.getIQDiscoItemsHandler();
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.infoHandler.setServerNodeInfoProvider(NAMESPACE, this);
        this.itemsHandler.setServerNodeInfoProvider(NAMESPACE, this);
        this.addDefaultCommands();
    }

    @Override
    public void stop() {
        super.stop();
        this.infoHandler.removeServerNodeInfoProvider(NAMESPACE);
        this.itemsHandler.removeServerNodeInfoProvider(NAMESPACE);
        for (AdHocCommand command : this.manager.getCommands()) {
            this.stopCommand(command);
        }
    }

    public void addCommand(AdHocCommand command) {
        this.manager.addCommand(command);
        this.startCommand(command);
    }

    public void removeCommand(AdHocCommand command) {
        if (this.manager.removeCommand(command)) {
            this.stopCommand(command);
        }
    }

    private void addDefaultCommands() {
        this.addCommand(new GetNumberActiveUsers());
        this.addCommand(new GetNumberOnlineUsers());
        this.addCommand(new GetNumberUserSessions());
        this.addCommand(new GetListActiveUsers());
        this.addCommand(new GetUsersPresence());
        this.addCommand(new GetListGroups());
        this.addCommand(new GetListGroupUsers());
        this.addCommand(new AddGroupUsers());
        this.addCommand(new DeleteGroupUsers());
        this.addCommand(new AddGroup());
        this.addCommand(new UpdateGroup());
        this.addCommand(new DeleteGroup());
        this.addCommand(new AddUser());
        this.addCommand(new DeleteUser());
        this.addCommand(new AuthenticateUser());
        this.addCommand(new ChangeUserPassword());
        this.addCommand(new UserProperties());
        this.addCommand(new PacketsNotification());
        this.addCommand(new GetServerStats());
        this.addCommand(new HttpBindStatus());
        this.addCommand(new UserCreated());
        this.addCommand(new UserModified());
        this.addCommand(new UserDeleting());
        this.addCommand(new GroupCreated());
        this.addCommand(new GroupDeleting());
        this.addCommand(new GroupModified());
        this.addCommand(new GroupMemberAdded());
        this.addCommand(new GroupMemberRemoved());
        this.addCommand(new GroupAdminAdded());
        this.addCommand(new GroupAdminRemoved());
        this.addCommand(new VCardCreated());
        this.addCommand(new VCardDeleting());
        this.addCommand(new VCardModified());
        this.addCommand(new GetAdminConsoleInfo());
    }

    private void startCommand(AdHocCommand command) {
        this.infoHandler.setServerNodeInfoProvider(command.getCode(), this);
        this.itemsHandler.setServerNodeInfoProvider(command.getCode(), this);
    }

    private void stopCommand(AdHocCommand command) {
        this.infoHandler.removeServerNodeInfoProvider(command.getCode());
        this.itemsHandler.removeServerNodeInfoProvider(command.getCode());
    }
}

