/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.AuthProviderMapper;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;

public class MappedAuthProvider
implements AuthProvider {
    public static final String PROPERTY_MAPPER_CLASSNAME = "mappedAuthProvider.mapper.className";
    protected final AuthProviderMapper mapper;

    public MappedAuthProvider() {
        JiveGlobals.migrateProperty(PROPERTY_MAPPER_CLASSNAME);
        String mapperClass = JiveGlobals.getProperty(PROPERTY_MAPPER_CLASSNAME);
        if (mapperClass == null) {
            throw new IllegalStateException("A mapper must be specified via openfire.xml or the system properties.");
        }
        try {
            Class c = ClassUtils.forName(mapperClass);
            this.mapper = (AuthProviderMapper)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create new instance of AuthProviderMapper class: " + mapperClass, e);
        }
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException, ConnectionException, InternalUnauthenticatedException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UnauthorizedException();
        }
        provider.authenticate(username, password);
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        return provider.getPassword(username);
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        provider.setPassword(username, password);
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        for (AuthProvider provider : this.mapper.getAuthProviders()) {
            if (!provider.supportsPasswordRetrieval()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScramSupported() {
        for (AuthProvider provider : this.mapper.getAuthProviders()) {
            if (!provider.isScramSupported()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSalt(String username) throws UserNotFoundException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        return provider.getSalt(username);
    }

    @Override
    public int getIterations(String username) throws UserNotFoundException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        return provider.getIterations(username);
    }

    @Override
    public String getServerKey(String username) throws UserNotFoundException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        return provider.getServerKey(username);
    }

    @Override
    public String getStoredKey(String username) throws UserNotFoundException {
        AuthProvider provider = this.mapper.getAuthProvider(username);
        if (provider == null) {
            throw new UserNotFoundException();
        }
        return provider.getStoredKey(username);
    }
}

