/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCAuthProvider
implements AuthProvider,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(JDBCAuthProvider.class);
    private static final int DEFAULT_BCRYPT_COST = 10;
    private String connectionString;
    private String passwordSQL;
    private String setPasswordSQL;
    private List<PasswordType> passwordTypes;
    private boolean allowUpdate;
    private boolean useConnectionProvider;
    private int bcryptCost;

    public JDBCAuthProvider() {
        JiveGlobals.migrateProperty("jdbcProvider.driver");
        JiveGlobals.migrateProperty("jdbcProvider.connectionString");
        JiveGlobals.migrateProperty("jdbcAuthProvider.passwordSQL");
        JiveGlobals.migrateProperty("jdbcAuthProvider.passwordType");
        JiveGlobals.migrateProperty("jdbcAuthProvider.setPasswordSQL");
        JiveGlobals.migrateProperty("jdbcAuthProvider.allowUpdate");
        JiveGlobals.migrateProperty("jdbcAuthProvider.bcrypt.cost");
        JiveGlobals.migrateProperty("jdbcAuthProvider.useConnectionProvider");
        JiveGlobals.migrateProperty("jdbcAuthProvider.acceptPreHashedPassword");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty("jdbcAuthProvider.useConnectionProvider");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty("jdbcProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error("Unable to load JDBC driver: " + jdbcDriver, (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty("jdbcProvider.connectionString");
        }
        this.passwordSQL = JiveGlobals.getProperty("jdbcAuthProvider.passwordSQL");
        this.setPasswordSQL = JiveGlobals.getProperty("jdbcAuthProvider.setPasswordSQL");
        this.allowUpdate = JiveGlobals.getBooleanProperty("jdbcAuthProvider.allowUpdate", false);
        this.setPasswordTypes(JiveGlobals.getProperty("jdbcAuthProvider.passwordType", "plain"));
        this.bcryptCost = JiveGlobals.getIntProperty("jdbcAuthProvider.bcrypt.cost", -1);
        PropertyEventDispatcher.addListener(this);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private void setPasswordTypes(String passwordTypeProperty) {
        Collection<String> passwordTypeStringList = StringUtils.stringToCollection(passwordTypeProperty);
        ArrayList<PasswordType> passwordTypeList = new ArrayList<PasswordType>(passwordTypeStringList.size());
        Iterator<String> it = passwordTypeStringList.iterator();
        while (it.hasNext()) {
            try {
                PasswordType type = PasswordType.valueOf(it.next().toLowerCase());
                passwordTypeList.add(type);
                if (type != PasswordType.bcrypt) continue;
                if (!it.hasNext()) break;
                Log.warn("The jdbcAuthProvider.passwordType setting in invalid.  Bcrypt must be the final hashType if a series is given.  Ignoring all hash types beyond bcrypt: {}", (Object)passwordTypeProperty);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (passwordTypeList.isEmpty()) {
            Log.warn("The jdbcAuthProvider.passwordType setting is not set or contains invalid values.  Setting the type to 'plain'");
            passwordTypeList.add(PasswordType.plain);
        }
        this.passwordTypes = passwordTypeList;
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException {
        String userPassword;
        if (username == null || password == null) {
            throw new UnauthorizedException();
        }
        if ((username = username.trim().toLowerCase()).contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UnauthorizedException();
            }
        }
        try {
            userPassword = this.getPasswordValue(username);
        }
        catch (UserNotFoundException unfe) {
            throw new UnauthorizedException();
        }
        if (!this.comparePasswords(password, userPassword)) {
            throw new UnauthorizedException();
        }
        this.createUser(username);
    }

    protected boolean comparePasswords(String plainText, String hashed) {
        int lastIndex = this.passwordTypes.size() - 1;
        if (this.passwordTypes.get(lastIndex) == PasswordType.bcrypt) {
            for (int i = 0; i < lastIndex; ++i) {
                plainText = this.hashPassword(plainText, this.passwordTypes.get(i));
            }
            return OpenBSDBCrypt.checkPassword((String)hashed, (char[])plainText.toCharArray());
        }
        return this.hashPassword(plainText).equals(hashed);
    }

    private String hashPassword(String password) {
        for (PasswordType type : this.passwordTypes) {
            password = this.hashPassword(password, type);
        }
        return password;
    }

    protected String hashPassword(String password, PasswordType type) {
        switch (type) {
            case md5: {
                return StringUtils.hash(password, "MD5");
            }
            case sha1: {
                return StringUtils.hash(password, "SHA-1");
            }
            case sha256: {
                return StringUtils.hash(password, "SHA-256");
            }
            case sha512: {
                return StringUtils.hash(password, "SHA-512");
            }
            case bcrypt: {
                byte[] salt = new byte[16];
                new SecureRandom().nextBytes(salt);
                int cost = this.bcryptCost < 4 || this.bcryptCost > 31 ? 10 : this.bcryptCost;
                return OpenBSDBCrypt.generate((char[])password.toCharArray(), (byte[])salt, (int)cost);
            }
            case nt: {
                byte[] utf16leBytes = null;
                try {
                    MessageDigest md = MessageDigest.getInstance("MD4");
                    utf16leBytes = password.getBytes("UTF-16LE");
                    byte[] digestBytes = md.digest(utf16leBytes);
                    return new String(new String(Hex.encode((byte[])digestBytes)));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return password;
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        if (!this.supportsPasswordRetrieval()) {
            throw new UnsupportedOperationException();
        }
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UserNotFoundException();
            }
        }
        return this.getPasswordValue(username);
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException {
        if (!this.allowUpdate || this.setPasswordSQL == null) {
            throw new UnsupportedOperationException();
        }
        this.setPasswordValue(username, password);
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        return this.passwordSQL != null && this.passwordTypes.size() == 1 && this.passwordTypes.get(0) == PasswordType.plain;
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }

    private String getPasswordValue(String username) throws UserNotFoundException {
        String password = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UserNotFoundException();
            }
        }
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.passwordSQL);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new UserNotFoundException();
            }
            password = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                Log.error("Exception in JDBCAuthProvider", (Throwable)e);
                throw new UserNotFoundException();
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return password;
    }

    private void setPasswordValue(String username, String password) throws UserNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UserNotFoundException();
            }
        }
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.setPasswordSQL);
            pstmt.setString(2, username);
            password = this.hashPassword(password);
            pstmt.setString(1, password);
            pstmt.executeQuery();
        }
        catch (SQLException e) {
            try {
                Log.error("Exception in JDBCAuthProvider", (Throwable)e);
                throw new UserNotFoundException();
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    protected void createUser(String username) {
        UserManager userManager = UserManager.getInstance();
        try {
            userManager.getUser(username);
        }
        catch (UserNotFoundException unfe) {
            try {
                Log.debug("JDBCAuthProvider: Automatically creating new user account for " + username);
                UserManager.getUserProvider().createUser(username, StringUtils.randomString(8), null, null);
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isScramSupported() {
        return false;
    }

    @Override
    public String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void propertySet(String property, Map<String, Object> params) {
        String value = (String)params.get("value");
        switch (property) {
            case "jdbcAuthProvider.passwordSQL": {
                this.passwordSQL = value;
                Log.debug("jdbcAuthProvider.passwordSQL configured to: {}", (Object)this.passwordSQL);
                break;
            }
            case "jdbcAuthProvider.setPasswordSQL": {
                this.setPasswordSQL = value;
                Log.debug("jdbcAuthProvider.setPasswordSQL configured to: {}", (Object)this.setPasswordSQL);
                break;
            }
            case "jdbcAuthProvider.allowUpdate": {
                this.allowUpdate = Boolean.parseBoolean(value);
                Log.debug("jdbcAuthProvider.allowUpdate configured to: {}", (Object)this.allowUpdate);
                break;
            }
            case "jdbcAuthProvider.passwordType": {
                this.setPasswordTypes(value);
                Log.debug("jdbcAuthProvider.passwordType configured to: {}", (Object)Arrays.toString(this.passwordTypes.toArray()));
                break;
            }
            case "jdbcAuthProvider.bcrypt.cost": {
                try {
                    this.bcryptCost = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.bcryptCost = -1;
                }
                Log.debug("jdbcAuthProvider.bcrypt.cost configured to: {}", (Object)this.bcryptCost);
            }
        }
    }

    @Override
    public void propertyDeleted(String property, Map<String, Object> params) {
        this.propertySet(property, Collections.emptyMap());
    }

    @Override
    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    @Override
    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    public static enum PasswordType {
        plain,
        md5,
        sha1,
        sha256,
        sha512,
        bcrypt,
        nt;

    }
}

