/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.auth.AuthorizationMapping;
import org.jivesoftware.openfire.auth.AuthorizationPolicy;
import org.jivesoftware.openfire.auth.DefaultAuthorizationMapping;
import org.jivesoftware.openfire.auth.DefaultAuthorizationPolicy;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationManager {
    private static final Logger Log;
    private static ArrayList<AuthorizationPolicy> authorizationPolicies;
    private static ArrayList<AuthorizationMapping> authorizationMapping;

    private AuthorizationManager() {
    }

    public static Collection<AuthorizationPolicy> getAuthorizationPolicies() {
        return authorizationPolicies;
    }

    public static boolean authorize(String username, String principal) {
        for (AuthorizationPolicy ap : authorizationPolicies) {
            if (Log.isDebugEnabled()) {
                Log.debug("AuthorizationManager: Trying " + ap.name() + ".authorize(" + username + " , " + principal + ")");
            }
            if (!ap.authorize(username, principal)) continue;
            try {
                UserManager.getUserProvider().loadUser(username);
            }
            catch (UserNotFoundException nfe) {
                if (Log.isDebugEnabled()) {
                    Log.debug("AuthorizationManager: User " + username + " not found " + nfe.toString());
                }
                if (JiveGlobals.getBooleanProperty("xmpp.auth.autoadd", false)) {
                    if (UserManager.getUserProvider().isReadOnly()) {
                        return false;
                    }
                    if (UserManager.getUserProvider().isNameRequired() || UserManager.getUserProvider().isEmailRequired()) {
                        return false;
                    }
                    try {
                        UserManager.getInstance().createUser(username, StringUtils.randomString(8), null, null);
                        if (Log.isDebugEnabled()) {
                            Log.info("AuthorizationManager: User " + username + " created.");
                        }
                        return true;
                    }
                    catch (UserAlreadyExistsException uaee) {
                        if (Log.isDebugEnabled()) {
                            Log.error("AuthorizationManager: User " + username + " already exists while attempting to add user.");
                        }
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String map(String principal) {
        for (AuthorizationMapping am : authorizationMapping) {
            String username;
            if (Log.isDebugEnabled()) {
                Log.debug("AuthorizationManager: Trying " + am.name() + ".map(" + principal + ")");
            }
            if ((username = am.map(principal)).equals(principal)) continue;
            return username;
        }
        return principal;
    }

    static {
        Class c_provider;
        String s_provider;
        StringTokenizer st;
        Log = LoggerFactory.getLogger(AuthorizationManager.class);
        authorizationPolicies = new ArrayList();
        authorizationMapping = new ArrayList();
        JiveGlobals.migrateProperty("provider.authorization.classList");
        JiveGlobals.migrateProperty("provider.authorizationMapping.classList");
        JiveGlobals.migrateProperty("sasl.approvedRealms");
        JiveGlobals.migrateProperty("sasl.realm");
        String classList = JiveGlobals.getProperty("provider.authorization.classList");
        if (classList != null) {
            st = new StringTokenizer(classList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                s_provider = st.nextToken();
                try {
                    c_provider = ClassUtils.forName(s_provider);
                    AuthorizationPolicy provider = (AuthorizationPolicy)c_provider.newInstance();
                    Log.debug("AuthorizationManager: Loaded " + s_provider);
                    authorizationPolicies.add(provider);
                }
                catch (Exception e) {
                    Log.error("AuthorizationManager: Error loading AuthorizationProvider: " + s_provider + "\n" + e);
                }
            }
        }
        if (authorizationPolicies.isEmpty()) {
            Log.debug("AuthorizationManager: No AuthorizationProvider's found. Loading DefaultAuthorizationPolicy");
            authorizationPolicies.add(new DefaultAuthorizationPolicy());
        }
        if ((classList = JiveGlobals.getProperty("provider.authorizationMapping.classList")) != null) {
            st = new StringTokenizer(classList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                s_provider = st.nextToken();
                try {
                    c_provider = ClassUtils.forName(s_provider);
                    Object o_provider = c_provider.newInstance();
                    if (o_provider instanceof AuthorizationMapping) {
                        AuthorizationMapping provider = (AuthorizationMapping)o_provider;
                        Log.debug("AuthorizationManager: Loaded " + s_provider);
                        authorizationMapping.add(provider);
                        continue;
                    }
                    Log.debug("AuthorizationManager: Unknown class type.");
                }
                catch (Exception e) {
                    Log.error("AuthorizationManager: Error loading AuthorizationMapping: " + s_provider + "\n" + e);
                }
            }
        }
        if (authorizationMapping.isEmpty()) {
            Log.debug("AuthorizationManager: No AuthorizationMapping's found. Loading DefaultAuthorizationMapping");
            authorizationMapping.add(new DefaultAuthorizationMapping());
        }
    }
}

