/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.AuthProviderMapper;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.xmpp.packet.JID;

public class AuthorizationBasedAuthProviderMapper
implements AuthProviderMapper {
    public static final String PROPERTY_ADMINPROVIDER_CLASSNAME = "authorizationBasedAuthMapper.adminProvider.className";
    public static final String PROPERTY_USERPROVIDER_CLASSNAME = "authorizationBasedAuthMapper.userProvider.className";
    protected final AuthProvider adminProvider;
    protected final AuthProvider userProvider;

    public AuthorizationBasedAuthProviderMapper() {
        JiveGlobals.migrateProperty(PROPERTY_ADMINPROVIDER_CLASSNAME);
        JiveGlobals.migrateProperty(PROPERTY_USERPROVIDER_CLASSNAME);
        this.adminProvider = AuthorizationBasedAuthProviderMapper.instantiateProvider(PROPERTY_ADMINPROVIDER_CLASSNAME);
        this.userProvider = AuthorizationBasedAuthProviderMapper.instantiateProvider(PROPERTY_USERPROVIDER_CLASSNAME);
    }

    protected static AuthProvider instantiateProvider(String propertyName) {
        String className = JiveGlobals.getProperty(propertyName);
        if (className == null) {
            throw new IllegalStateException("A class name must be specified via openfire.xml or the system properties.");
        }
        try {
            Class c = ClassUtils.forName(className);
            return (AuthProvider)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create new instance of AuthProvider: " + className, e);
        }
    }

    @Override
    public AuthProvider getAuthProvider(String username) {
        JID jid = XMPPServer.getInstance().createJID(username, null);
        boolean isAdmin = AdminManager.getAdminProvider().getAdmins().contains(jid);
        if (isAdmin) {
            return this.adminProvider;
        }
        return this.userProvider;
    }

    @Override
    public Set<AuthProvider> getAuthProviders() {
        LinkedHashSet<AuthProvider> result = new LinkedHashSet<AuthProvider>();
        result.add(this.adminProvider);
        result.add(this.userProvider);
        return result;
    }
}

