/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.audit.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.audit.AuditManager;
import org.jivesoftware.openfire.audit.Auditor;
import org.jivesoftware.openfire.audit.spi.AuditorImpl;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class AuditManagerImpl
extends BasicModule
implements AuditManager,
PropertyEventListener {
    private boolean enabled;
    private boolean auditMessage;
    private boolean auditPresence;
    private boolean auditIQ;
    private boolean auditXPath;
    private List<String> xpath = new LinkedList<String>();
    private AuditorImpl auditor = null;
    private int maxTotalSize;
    private int maxFileSize;
    private int maxDays;
    private int logTimeout;
    private String logDir;
    private Collection<String> ignoreList = new ArrayList<String>();
    private static final int MAX_TOTAL_SIZE = 1000;
    private static final int MAX_FILE_SIZE = 10;
    private static final int MAX_DAYS = -1;
    private static final int DEFAULT_LOG_TIMEOUT = 120000;
    private AuditorInterceptor interceptor;

    public AuditManagerImpl() {
        super("Audit Manager");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        JiveGlobals.setProperty("xmpp.audit.active", enabled ? "true" : "false");
        this.processEnabled(enabled);
    }

    @Override
    public Auditor getAuditor() {
        if (this.auditor == null) {
            throw new IllegalStateException("Must initialize audit manager first");
        }
        return this.auditor;
    }

    @Override
    public int getMaxTotalSize() {
        return this.maxTotalSize;
    }

    @Override
    public void setMaxTotalSize(int size) {
        this.maxTotalSize = size;
        this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
        JiveGlobals.setProperty("xmpp.audit.totalsize", Integer.toString(size));
    }

    @Override
    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public void setMaxFileSize(int size) {
        this.maxFileSize = size;
        this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
        JiveGlobals.setProperty("xmpp.audit.filesize", Integer.toString(size));
    }

    @Override
    public int getMaxDays() {
        return this.maxDays;
    }

    @Override
    public void setMaxDays(int count) {
        this.maxDays = this.validateMaxDays(count);
        this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
        JiveGlobals.setProperty("xmpp.audit.days", Integer.toString(count));
    }

    @Override
    public int getLogTimeout() {
        return this.logTimeout;
    }

    @Override
    public void setLogTimeout(int logTimeout) {
        this.logTimeout = logTimeout;
        this.auditor.setLogTimeout(logTimeout);
        JiveGlobals.setProperty("xmpp.audit.logtimeout", Integer.toString(logTimeout));
    }

    @Override
    public String getLogDir() {
        return this.logDir;
    }

    @Override
    public void setLogDir(String logDir) {
        this.logDir = logDir;
        this.auditor.setLogDir(logDir);
        JiveGlobals.setProperty("xmpp.audit.logdir", logDir);
    }

    @Override
    public boolean isAuditMessage() {
        return this.auditMessage;
    }

    @Override
    public void setAuditMessage(boolean auditMessage) {
        this.auditMessage = auditMessage;
        JiveGlobals.setProperty("xmpp.audit.message", auditMessage ? "true" : "false");
    }

    @Override
    public boolean isAuditPresence() {
        return this.auditPresence;
    }

    @Override
    public void setAuditPresence(boolean auditPresence) {
        this.auditPresence = auditPresence;
        JiveGlobals.setProperty("xmpp.audit.presence", auditPresence ? "true" : "false");
    }

    @Override
    public boolean isAuditIQ() {
        return this.auditIQ;
    }

    @Override
    public void setAuditIQ(boolean auditIQ) {
        this.auditIQ = auditIQ;
        JiveGlobals.setProperty("xmpp.audit.iq", Boolean.toString(auditIQ));
    }

    @Override
    public boolean isAuditXPath() {
        return this.auditXPath;
    }

    @Override
    public void setAuditXPath(boolean auditXPath) {
        this.auditXPath = auditXPath;
        JiveGlobals.setProperty("xmpp.audit.xpath", Boolean.toString(auditXPath));
    }

    @Override
    public void addXPath(String xpathExpression) {
        this.xpath.add(xpathExpression);
        this.saveXPath();
    }

    @Override
    public void removeXPath(String xpathExpression) {
        this.xpath.remove(xpathExpression);
        this.saveXPath();
    }

    private void saveXPath() {
    }

    @Override
    public Iterator getXPathFilters() {
        return this.xpath.iterator();
    }

    @Override
    public void setIgnoreList(Collection<String> usernames) {
        if (this.ignoreList.equals(usernames)) {
            return;
        }
        this.ignoreList = usernames;
        StringBuilder ignoreString = new StringBuilder();
        for (String username : this.ignoreList) {
            if (ignoreString.length() == 0) {
                ignoreString.append(username);
                continue;
            }
            ignoreString.append(',').append(username);
        }
        JiveGlobals.setProperty("xmpp.audit.ignore", ignoreString.toString());
    }

    @Override
    public Collection<String> getIgnoreList() {
        return Collections.unmodifiableCollection(this.ignoreList);
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.enabled = JiveGlobals.getBooleanProperty("xmpp.audit.active");
        this.auditMessage = JiveGlobals.getBooleanProperty("xmpp.audit.message");
        this.auditPresence = JiveGlobals.getBooleanProperty("xmpp.audit.presence");
        this.auditIQ = JiveGlobals.getBooleanProperty("xmpp.audit.iq");
        this.auditXPath = JiveGlobals.getBooleanProperty("xmpp.audit.xpath");
        this.maxTotalSize = JiveGlobals.getIntProperty("xmpp.audit.totalsize", 1000);
        this.maxFileSize = JiveGlobals.getIntProperty("xmpp.audit.filesize", 10);
        this.maxDays = JiveGlobals.getIntProperty("xmpp.audit.days", -1);
        this.logTimeout = JiveGlobals.getIntProperty("xmpp.audit.logtimeout", 120000);
        this.logDir = JiveGlobals.getProperty("xmpp.audit.logdir", JiveGlobals.getHomeDirectory() + File.separator + "logs");
        this.processIgnoreString(JiveGlobals.getProperty("xmpp.audit.ignore", ""));
        this.auditor = new AuditorImpl(this);
        this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
        this.auditor.setLogDir(this.logDir);
        this.auditor.setLogTimeout(this.logTimeout);
        this.interceptor = new AuditorInterceptor();
        this.processEnabled(this.enabled);
        PropertyEventDispatcher.addListener(this);
    }

    private void processIgnoreString(String ignoreString) {
        this.ignoreList.clear();
        StringTokenizer tokenizer = new StringTokenizer(ignoreString, ",");
        while (tokenizer.hasMoreTokens()) {
            String username = tokenizer.nextToken().trim();
            this.ignoreList.add(username);
        }
    }

    private void processEnabled(boolean enabled) {
        if (enabled) {
            InterceptorManager.getInstance().addInterceptor(this.interceptor);
        } else {
            InterceptorManager.getInstance().removeInterceptor(this.interceptor);
        }
    }

    private int validateMaxDays(int count) {
        if (count < -1) {
            count = -1;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    @Override
    public void stop() {
        if (this.auditor != null) {
            this.auditor.stop();
        }
    }

    @Override
    public void propertySet(String property, Map<String, Object> params) {
        Object val = params.get("value");
        if (!(val instanceof String)) {
            return;
        }
        String value = (String)val;
        switch (property) {
            case "xmpp.audit.active": {
                this.enabled = Boolean.parseBoolean(value);
                this.processEnabled(this.enabled);
                break;
            }
            case "xmpp.audit.message": {
                this.auditMessage = Boolean.parseBoolean(value);
                break;
            }
            case "xmpp.audit.presence": {
                this.auditPresence = Boolean.parseBoolean(value);
                break;
            }
            case "xmpp.audit.iq": {
                this.auditIQ = Boolean.parseBoolean(value);
                break;
            }
            case "xmpp.audit.xpath": {
                this.auditXPath = Boolean.parseBoolean(value);
                break;
            }
            case "xmpp.audit.totalsize": {
                this.maxTotalSize = this.parseIntegerOrDefault(value, 1000);
                this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
                break;
            }
            case "xmpp.audit.filesize": {
                this.maxFileSize = this.parseIntegerOrDefault(value, 10);
                this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
                break;
            }
            case "xmpp.audit.days": {
                this.maxDays = this.validateMaxDays(this.parseIntegerOrDefault(value, -1));
                this.auditor.setMaxValues(this.maxTotalSize, this.maxFileSize, this.maxDays);
                break;
            }
            case "xmpp.audit.logtimeout": {
                this.logTimeout = this.parseIntegerOrDefault(value, 120000);
                this.auditor.setLogTimeout(this.logTimeout);
                break;
            }
            case "xmpp.audit.logdir": {
                File d = null;
                if (value != null && !"".equals(value.trim())) {
                    d = new File(value);
                }
                this.logDir = d == null || !d.exists() || !d.canRead() || !d.canWrite() || !d.isDirectory() ? JiveGlobals.getHomeDirectory() + File.separator + "logs" : value;
                this.auditor.setLogDir(this.logDir);
                break;
            }
            case "xmpp.audit.ignore": {
                this.processIgnoreString(value);
            }
        }
    }

    private int parseIntegerOrDefault(String intValue, int defaultValue) {
        try {
            return Integer.parseInt(intValue);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public void propertyDeleted(String property, Map<String, Object> params) {
        this.propertySet(property, Collections.emptyMap());
    }

    @Override
    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    @Override
    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    private class AuditorInterceptor
    implements PacketInterceptor {
        private AuditorInterceptor() {
        }

        @Override
        public void interceptPacket(Packet packet, Session session, boolean read, boolean processed) {
            if (!processed) {
                JID from = packet.getFrom();
                JID to = packet.getTo();
                if (!(from != null && AuditManagerImpl.this.ignoreList.contains(from.getNode()) || to != null && AuditManagerImpl.this.ignoreList.contains(to.getNode()))) {
                    AuditManagerImpl.this.auditor.audit(packet, session);
                }
            }
        }
    }
}

