/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.audit;

import java.util.Date;
import org.jivesoftware.openfire.audit.AuditEvent;
import org.jivesoftware.openfire.session.Session;

public class SessionEvent
extends AuditEvent {
    public static final int SESSION_CODE = 1;
    public static final int SESSION_CONNECT = 1;
    public static final int SESSION_STREAM = 2;
    public static final int SESSION_AUTH_FAILURE = 3;
    public static final int SESSION_AUTH_SUCCESS = 4;
    public static final int SESSION_DISCONNECT = 10;

    private SessionEvent(Session eventSession, int eventReason, String data) {
        super(eventSession, new Date(), 1, eventReason, data);
    }

    public static SessionEvent createConnectEvent(Session session) {
        return new SessionEvent(session, 1, null);
    }

    public static SessionEvent createStreamEvent(Session session) {
        return new SessionEvent(session, 2, null);
    }

    public static SessionEvent createAuthFailureEvent(Session session, String user, String resource) {
        return new SessionEvent(session, 3, "User: " + user + " Resource: " + resource);
    }

    public static SessionEvent createAuthSuccessEvent(Session session) {
        return new SessionEvent(session, 4, null);
    }

    public static SessionEvent createDisconnectEvent(Session session) {
        return new SessionEvent(session, 10, null);
    }
}

