/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.ConnectionManager;
import org.jivesoftware.openfire.FlashCrossDomainHandler;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.MessageRouter;
import org.jivesoftware.openfire.MulticastRouter;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.OfflineMessageStrategy;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.PresenceRouter;
import org.jivesoftware.openfire.PrivateStorage;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServerInfo;
import org.jivesoftware.openfire.XMPPServerListener;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.admin.DefaultAdminProvider;
import org.jivesoftware.openfire.audit.AuditManager;
import org.jivesoftware.openfire.audit.spi.AuditManagerImpl;
import org.jivesoftware.openfire.auth.DefaultAuthProvider;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.commands.AdHocCommandHandler;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.container.AdminConsolePlugin;
import org.jivesoftware.openfire.container.Module;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.disco.IQDiscoInfoHandler;
import org.jivesoftware.openfire.disco.IQDiscoItemsHandler;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.disco.ServerIdentitiesProvider;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.disco.UserIdentitiesProvider;
import org.jivesoftware.openfire.disco.UserItemsProvider;
import org.jivesoftware.openfire.filetransfer.DefaultFileTransferManager;
import org.jivesoftware.openfire.filetransfer.FileTransferManager;
import org.jivesoftware.openfire.filetransfer.proxy.FileTransferProxy;
import org.jivesoftware.openfire.group.DefaultGroupProvider;
import org.jivesoftware.openfire.handler.IQBindHandler;
import org.jivesoftware.openfire.handler.IQEntityTimeHandler;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.handler.IQLastActivityHandler;
import org.jivesoftware.openfire.handler.IQMessageCarbonsHandler;
import org.jivesoftware.openfire.handler.IQOfflineMessagesHandler;
import org.jivesoftware.openfire.handler.IQPingHandler;
import org.jivesoftware.openfire.handler.IQPrivacyHandler;
import org.jivesoftware.openfire.handler.IQPrivateHandler;
import org.jivesoftware.openfire.handler.IQRegisterHandler;
import org.jivesoftware.openfire.handler.IQRosterHandler;
import org.jivesoftware.openfire.handler.IQSessionEstablishmentHandler;
import org.jivesoftware.openfire.handler.IQSharedGroupHandler;
import org.jivesoftware.openfire.handler.IQVersionHandler;
import org.jivesoftware.openfire.handler.IQvCardHandler;
import org.jivesoftware.openfire.handler.PresenceSubscribeHandler;
import org.jivesoftware.openfire.handler.PresenceUpdateHandler;
import org.jivesoftware.openfire.keystore.CertificateStoreManager;
import org.jivesoftware.openfire.keystore.IdentityStore;
import org.jivesoftware.openfire.lockout.DefaultLockOutProvider;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.mediaproxy.MediaProxyService;
import org.jivesoftware.openfire.muc.MultiUserChatManager;
import org.jivesoftware.openfire.net.MulticastDNSService;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.pep.IQPEPHandler;
import org.jivesoftware.openfire.pep.IQPEPOwnerHandler;
import org.jivesoftware.openfire.pubsub.PubSubModule;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.security.DefaultSecurityAuditProvider;
import org.jivesoftware.openfire.session.RemoteSessionLocator;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.openfire.spi.PacketDelivererImpl;
import org.jivesoftware.openfire.spi.PacketRouterImpl;
import org.jivesoftware.openfire.spi.PacketTransporterImpl;
import org.jivesoftware.openfire.spi.PresenceManagerImpl;
import org.jivesoftware.openfire.spi.RoutingTableImpl;
import org.jivesoftware.openfire.spi.XMPPServerInfoImpl;
import org.jivesoftware.openfire.transport.TransportHandler;
import org.jivesoftware.openfire.update.UpdateManager;
import org.jivesoftware.openfire.user.DefaultUserProvider;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.vcard.DefaultVCardProvider;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.jivesoftware.util.InitializationException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.Log;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class XMPPServer {
    private static final Logger logger = LoggerFactory.getLogger(XMPPServer.class);
    private static XMPPServer instance;
    private boolean initialized = false;
    private boolean started = false;
    private NodeID nodeID;
    private static final NodeID DEFAULT_NODE_ID;
    public static final String EXIT = "exit";
    private Map<Class, Module> modules = new LinkedHashMap<Class, Module>();
    private List<XMPPServerListener> listeners = new CopyOnWriteArrayList<XMPPServerListener>();
    private File openfireHome;
    private ClassLoader loader;
    private PluginManager pluginManager;
    private InternalComponentManager componentManager;
    private RemoteSessionLocator remoteSessionLocator;
    private boolean setupMode = true;
    private static final String STARTER_CLASSNAME = "org.jivesoftware.openfire.starter.ServerStarter";
    private static final String WRAPPER_CLASSNAME = "org.tanukisoftware.wrapper.WrapperManager";
    private boolean shuttingDown;
    private XMPPServerInfoImpl xmppServerInfo;

    public static XMPPServer getInstance() {
        return instance;
    }

    public XMPPServer() {
        if (instance != null) {
            throw new IllegalStateException("A server is already running");
        }
        instance = this;
        this.start();
    }

    public XMPPServerInfo getServerInfo() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized yet");
        }
        return this.xmppServerInfo;
    }

    public boolean isLocal(JID jid) {
        return jid != null && jid.getDomain().equals(this.xmppServerInfo.getXMPPDomain());
    }

    public boolean isRemote(JID jid) {
        return jid != null && !jid.getDomain().equals(this.xmppServerInfo.getXMPPDomain()) && !this.componentManager.hasComponent(jid);
    }

    public NodeID getNodeID() {
        return this.nodeID == null ? DEFAULT_NODE_ID : this.nodeID;
    }

    public void setNodeID(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    public boolean matchesComponent(JID jid) {
        return jid != null && !jid.getDomain().equals(this.xmppServerInfo.getXMPPDomain()) && this.componentManager.hasComponent(jid);
    }

    public JID createJID(String username, String resource) {
        return new JID(username, this.xmppServerInfo.getXMPPDomain(), resource);
    }

    public JID createJID(String username, String resource, boolean skipStringprep) {
        return new JID(username, this.xmppServerInfo.getXMPPDomain(), resource, skipStringprep);
    }

    public Collection<JID> getAdmins() {
        return AdminManager.getInstance().getAdminAccounts();
    }

    public void addServerListener(XMPPServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeServerListener(XMPPServerListener listener) {
        this.listeners.remove(listener);
    }

    private void initialize() throws FileNotFoundException {
        this.locateOpenfire();
        if ("true".equals(JiveGlobals.getXMLProperty("setup"))) {
            this.setupMode = false;
        }
        if (this.isStandAlone()) {
            logger.info("Registering shutdown hook (standalone mode)");
            Runtime.getRuntime().addShutdownHook(new ShutdownHookThread());
            TaskEngine.getInstance().schedule((TimerTask)new Terminator(), 1000L, 1000L);
        }
        this.loader = Thread.currentThread().getContextClassLoader();
        try {
            CacheFactory.initialize();
        }
        catch (InitializationException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        JiveGlobals.migrateProperty("xmpp.domain");
        JiveGlobals.migrateProperty("xmpp.fqdn");
        JiveGlobals.migrateProperty("log.debug.enabled");
        Log.setDebugEnabled(JiveGlobals.getBooleanProperty("log.debug.enabled", false));
        this.xmppServerInfo = new XMPPServerInfoImpl(new Date());
        this.initialized = true;
        if (this.setupMode && "true".equals(JiveGlobals.getXMLProperty("autosetup.run"))) {
            this.runAutoSetup();
            JiveGlobals.deleteXMLProperty("autosetup");
            JiveGlobals.deleteProperty("autosetup");
        }
    }

    void runAutoSetup() {
        if ("standard".equals(JiveGlobals.getXMLProperty("autosetup.database.mode"))) {
            double connectionTimeout;
            int maxConnections;
            int minConnections;
            JiveGlobals.setXMLProperty("database.defaultProvider.driver", JiveGlobals.getXMLProperty("autosetup.database.defaultProvider.driver"));
            JiveGlobals.setXMLProperty("database.defaultProvider.serverURL", JiveGlobals.getXMLProperty("autosetup.database.defaultProvider.serverURL"));
            JiveGlobals.setXMLProperty("database.defaultProvider.username", JiveGlobals.getXMLProperty("autosetup.database.defaultProvider.username"));
            JiveGlobals.setXMLProperty("database.defaultProvider.password", JiveGlobals.getXMLProperty("autosetup.database.defaultProvider.password"));
            try {
                minConnections = Integer.parseInt(JiveGlobals.getXMLProperty("database.defaultProvider.minConnections"));
            }
            catch (Exception e) {
                minConnections = 5;
            }
            try {
                maxConnections = Integer.parseInt(JiveGlobals.getXMLProperty("database.defaultProvider.maxConnections"));
            }
            catch (Exception e) {
                maxConnections = 25;
            }
            try {
                connectionTimeout = Double.parseDouble(JiveGlobals.getXMLProperty("database.defaultProvider.connectionTimeout"));
            }
            catch (Exception e) {
                connectionTimeout = 1.0;
            }
            JiveGlobals.setXMLProperty("database.defaultProvider.minConnections", Integer.toString(minConnections));
            JiveGlobals.setXMLProperty("database.defaultProvider.maxConnections", Integer.toString(maxConnections));
            JiveGlobals.setXMLProperty("database.defaultProvider.connectionTimeout", Double.toString(connectionTimeout));
        }
        JiveGlobals.setXMLProperty("setup", "true");
        String localeCode = JiveGlobals.getXMLProperty("autosetup.locale");
        logger.warn("Setting locale to" + localeCode);
        JiveGlobals.setLocale(LocaleUtils.localeCodeToLocale(localeCode.trim()));
        JiveGlobals.setXMLProperty("xmpp.domain", JiveGlobals.getXMLProperty("autosetup.xmpp.domain"));
        JiveGlobals.setXMLProperty("xmpp.fqdn", JiveGlobals.getXMLProperty("autosetup.xmpp.fqdn"));
        JiveGlobals.migrateProperty("xmpp.domain");
        JiveGlobals.migrateProperty("xmpp.fqdn");
        JiveGlobals.setProperty("xmpp.socket.ssl.active", JiveGlobals.getXMLProperty("autosetup.xmpp.socket.ssl.active", "true"));
        JiveGlobals.setProperty("xmpp.auth.anonymous", JiveGlobals.getXMLProperty("autosetup.xmpp.auth.anonymous", "false"));
        JiveGlobals.setupPropertyEncryptionAlgorithm(JiveGlobals.getXMLProperty("autosetup.encryption.algorithm", "Blowfish"));
        JiveGlobals.setupPropertyEncryptionKey(JiveGlobals.getXMLProperty("autosetup.encryption.key", null));
        if ("default".equals(JiveGlobals.getXMLProperty("autosetup.authprovider.mode", "default"))) {
            JiveGlobals.setXMLProperty("connectionProvider.className", "org.jivesoftware.database.DefaultConnectionProvider");
            JiveGlobals.setProperty("provider.auth.className", JiveGlobals.getXMLProperty("provider.auth.className", DefaultAuthProvider.class.getName()));
            JiveGlobals.setProperty("provider.user.className", JiveGlobals.getXMLProperty("provider.user.className", DefaultUserProvider.class.getName()));
            JiveGlobals.setProperty("provider.group.className", JiveGlobals.getXMLProperty("provider.group.className", DefaultGroupProvider.class.getName()));
            JiveGlobals.setProperty("provider.vcard.className", JiveGlobals.getXMLProperty("provider.vcard.className", DefaultVCardProvider.class.getName()));
            JiveGlobals.setProperty("provider.lockout.className", JiveGlobals.getXMLProperty("provider.lockout.className", DefaultLockOutProvider.class.getName()));
            JiveGlobals.setProperty("provider.securityAudit.className", JiveGlobals.getXMLProperty("provider.securityAudit.className", DefaultSecurityAuditProvider.class.getName()));
            JiveGlobals.setProperty("provider.admin.className", JiveGlobals.getXMLProperty("provider.admin.className", DefaultAdminProvider.class.getName()));
            JiveGlobals.setProperty("user.scramHashedPasswordOnly", "true");
        }
        try {
            User adminUser = UserManager.getInstance().getUser("admin");
            adminUser.setPassword(JiveGlobals.getXMLProperty("autosetup.admin.password"));
            adminUser.setEmail(JiveGlobals.getXMLProperty("autosetup.admin.email"));
            Date now = new Date();
            adminUser.setCreationDate(now);
            adminUser.setModificationDate(now);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("There was an unexpected error encountered when setting the new admin information. Please check your error logs and try to remedy the problem.");
        }
        this.finalSetupSteps();
        this.setupMode = false;
    }

    private void finalSetupSteps() {
        for (String propName : JiveGlobals.getXMLPropertyNames()) {
            if (JiveGlobals.getProperty(propName) != null) continue;
            JiveGlobals.setProperty(propName, JiveGlobals.getXMLProperty(propName));
        }
        JiveGlobals.setProperty("sasl.scram-sha-1.iteration-count", Integer.toString(4096));
        CertificateStoreManager certificateStoreManager = null;
        try {
            certificateStoreManager = new CertificateStoreManager();
            certificateStoreManager.initialize(this);
            certificateStoreManager.start();
            IdentityStore identityStore = certificateStoreManager.getIdentityStore(ConnectionType.SOCKET_C2S);
            identityStore.ensureDomainCertificates("DSA", "RSA");
        }
        catch (Exception e) {
            logger.error("Error generating self-signed certificates", (Throwable)e);
        }
        finally {
            if (certificateStoreManager != null) {
                certificateStoreManager.stop();
                certificateStoreManager.destroy();
            }
        }
        AdminManager.getInstance().getAdminAccounts();
    }

    public void finishSetup() {
        if (!this.setupMode) {
            return;
        }
        this.finalSetupSteps();
        if ("true".equals(JiveGlobals.getXMLProperty("setup"))) {
            Thread finishSetup = new Thread(){

                @Override
                public void run() {
                    try {
                        if (XMPPServer.this.isStandAlone()) {
                            Thread.sleep(1000L);
                            ((AdminConsolePlugin)XMPPServer.this.pluginManager.getPlugin("admin")).restart();
                        }
                        XMPPServer.this.verifyDataSource();
                        XMPPServer.this.loadModules();
                        XMPPServer.this.initModules();
                        XMPPServer.this.startModules();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error(e.getMessage(), (Throwable)e);
                        XMPPServer.this.shutdownServer();
                    }
                }
            };
            finishSetup.setContextClassLoader(this.loader);
            finishSetup.start();
            this.setupMode = false;
        }
    }

    public void start() {
        try {
            this.initialize();
            File pluginDir = new File(this.openfireHome, "plugins");
            this.pluginManager = new PluginManager(pluginDir);
            if (!this.setupMode) {
                this.verifyDataSource();
                this.loadModules();
                this.initModules();
                this.startModules();
            }
            ServerTrafficCounter.initStatistics();
            this.pluginManager.start();
            String startupBanner = LocaleUtils.getLocalizedString("short.title") + " " + this.xmppServerInfo.getVersion().getVersionString() + " [" + JiveGlobals.formatDateTime(new Date()) + "]";
            logger.info(startupBanner);
            System.out.println(startupBanner);
            this.started = true;
            for (XMPPServerListener listener : this.listeners) {
                listener.serverStarted();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println(LocaleUtils.getLocalizedString("startup.error"));
            this.shutdownServer();
        }
    }

    private void loadModules() {
        this.loadModule(RoutingTableImpl.class.getName());
        this.loadModule(AuditManagerImpl.class.getName());
        this.loadModule(RosterManager.class.getName());
        this.loadModule(PrivateStorage.class.getName());
        this.loadModule(PresenceManagerImpl.class.getName());
        this.loadModule(SessionManager.class.getName());
        this.loadModule(PacketRouterImpl.class.getName());
        this.loadModule(IQRouter.class.getName());
        this.loadModule(MessageRouter.class.getName());
        this.loadModule(PresenceRouter.class.getName());
        this.loadModule(MulticastRouter.class.getName());
        this.loadModule(PacketTransporterImpl.class.getName());
        this.loadModule(PacketDelivererImpl.class.getName());
        this.loadModule(TransportHandler.class.getName());
        this.loadModule(OfflineMessageStrategy.class.getName());
        this.loadModule(OfflineMessageStore.class.getName());
        this.loadModule(VCardManager.class.getName());
        this.loadModule(IQBindHandler.class.getName());
        this.loadModule(IQSessionEstablishmentHandler.class.getName());
        this.loadModule(IQPingHandler.class.getName());
        this.loadModule(IQPrivateHandler.class.getName());
        this.loadModule(IQRegisterHandler.class.getName());
        this.loadModule(IQRosterHandler.class.getName());
        this.loadModule(IQEntityTimeHandler.class.getName());
        this.loadModule(IQvCardHandler.class.getName());
        this.loadModule(IQVersionHandler.class.getName());
        this.loadModule(IQLastActivityHandler.class.getName());
        this.loadModule(PresenceSubscribeHandler.class.getName());
        this.loadModule(PresenceUpdateHandler.class.getName());
        this.loadModule(IQOfflineMessagesHandler.class.getName());
        this.loadModule(IQPEPHandler.class.getName());
        this.loadModule(IQPEPOwnerHandler.class.getName());
        this.loadModule(MulticastDNSService.class.getName());
        this.loadModule(IQSharedGroupHandler.class.getName());
        this.loadModule(AdHocCommandHandler.class.getName());
        this.loadModule(IQPrivacyHandler.class.getName());
        this.loadModule(DefaultFileTransferManager.class.getName());
        this.loadModule(FileTransferProxy.class.getName());
        this.loadModule(MediaProxyService.class.getName());
        this.loadModule(PubSubModule.class.getName());
        this.loadModule(IQDiscoInfoHandler.class.getName());
        this.loadModule(IQDiscoItemsHandler.class.getName());
        this.loadModule(UpdateManager.class.getName());
        this.loadModule(FlashCrossDomainHandler.class.getName());
        this.loadModule(InternalComponentManager.class.getName());
        this.loadModule(MultiUserChatManager.class.getName());
        this.loadModule(IQMessageCarbonsHandler.class.getName());
        this.loadModule(CertificateStoreManager.class.getName());
        this.loadModule(ConnectionManagerImpl.class.getName());
        this.componentManager = this.getComponentManager();
    }

    private void loadModule(String module) {
        try {
            Class<?> modClass = this.loader.loadClass(module);
            Module mod = (Module)modClass.newInstance();
            this.modules.put(modClass, mod);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
    }

    private void initModules() {
        for (Module module : this.modules.values()) {
            try {
                module.initialize(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.modules.remove(module.getClass());
                module.stop();
                module.destroy();
                logger.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        }
    }

    private void startModules() {
        for (Module module : this.modules.values()) {
            try {
                logger.debug("Starting module: " + module.getName());
                module.start();
            }
            catch (Exception e) {
                logger.error("An exception occurred while starting module '{}'.", (Object)module.getName(), (Object)e);
            }
        }
    }

    public void restart() {
        if (this.isStandAlone() && this.isRestartable()) {
            try {
                Class<?> wrapperClass = Class.forName(WRAPPER_CLASSNAME);
                Method restartMethod = wrapperClass.getMethod("restart", null);
                restartMethod.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                logger.error("Could not restart container", (Throwable)e);
            }
        }
    }

    public void restartHTTPServer() {
        Thread restartThread = new Thread(){

            @Override
            public void run() {
                if (XMPPServer.this.isStandAlone()) {
                    try {
                        Thread.sleep(1000L);
                        ((AdminConsolePlugin)XMPPServer.this.pluginManager.getPlugin("admin")).shutdown();
                        ((AdminConsolePlugin)XMPPServer.this.pluginManager.getPlugin("admin")).startup();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        restartThread.setContextClassLoader(this.loader);
        restartThread.start();
    }

    public void stop() {
        logger.info("Initiating shutdown ...");
        if (this.isStandAlone()) {
            if (this.isRestartable()) {
                try {
                    Class<?> wrapperClass = Class.forName(WRAPPER_CLASSNAME);
                    Method stopMethod = wrapperClass.getMethod("stop", Integer.TYPE);
                    stopMethod.invoke(null, 0);
                }
                catch (Exception e) {
                    logger.error("Could not stop container", (Throwable)e);
                }
            } else {
                this.shutdownServer();
                ShutdownThread shutdownThread = new ShutdownThread();
                shutdownThread.setDaemon(true);
                shutdownThread.start();
            }
        } else {
            this.shutdownServer();
        }
    }

    public boolean isSetupMode() {
        return this.setupMode;
    }

    public boolean isRestartable() {
        boolean restartable;
        try {
            restartable = Class.forName(WRAPPER_CLASSNAME) != null;
        }
        catch (ClassNotFoundException e) {
            restartable = false;
        }
        return restartable;
    }

    public boolean isStandAlone() {
        boolean standalone;
        try {
            standalone = Class.forName(STARTER_CLASSNAME) != null;
        }
        catch (ClassNotFoundException e) {
            standalone = false;
        }
        return standalone;
    }

    private void verifyDataSource() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT count(*) FROM ofID");
            rs = pstmt.executeQuery();
            rs.next();
        }
        catch (Exception e) {
            try {
                System.err.println("Database setup or configuration error: Please verify your database settings and check the logs/error.log file for detailed error messages.");
                logger.error("Database could not be accessed", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
    }

    private File verifyHome(String homeGuess, String jiveConfigName) throws FileNotFoundException {
        File openfireHome = new File(homeGuess);
        File configFile = new File(openfireHome, jiveConfigName);
        if (!configFile.exists()) {
            throw new FileNotFoundException();
        }
        try {
            return new File(openfireHome.getCanonicalPath());
        }
        catch (Exception ex) {
            throw new FileNotFoundException();
        }
    }

    private void locateOpenfire() throws FileNotFoundException {
        String jiveConfigName;
        block26: {
            jiveConfigName = "conf" + File.separator + "openfire.xml";
            if (this.openfireHome == null) {
                String homeProperty = System.getProperty("openfireHome");
                try {
                    if (homeProperty != null) {
                        this.openfireHome = this.verifyHome(homeProperty, jiveConfigName);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (this.openfireHome == null) {
                try {
                    this.openfireHome = this.verifyHome("..", jiveConfigName).getCanonicalFile();
                }
                catch (IOException homeProperty) {
                    // empty catch block
                }
            }
            if (this.openfireHome == null) {
                try (InputStream in = this.getClass().getResourceAsStream("/openfire_init.xml");){
                    if (in == null) break block26;
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(in);
                    String path = doc.getRootElement().getText();
                    try {
                        if (path != null) {
                            this.openfireHome = this.verifyHome(path, jiveConfigName);
                        }
                    }
                    catch (FileNotFoundException fe) {
                        fe.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error loading openfire_init.xml to find home.");
                    e.printStackTrace();
                }
            }
        }
        if (this.openfireHome == null) {
            System.err.println("Could not locate home");
            throw new FileNotFoundException();
        }
        JiveGlobals.setHomeDirectory(this.openfireHome.toString());
        JiveGlobals.setConfigName(jiveConfigName);
    }

    private void shutdownServer() {
        this.shuttingDown = true;
        ClusterManager.shutdown();
        for (XMPPServerListener listener : this.listeners) {
            try {
                listener.serverStopping();
            }
            catch (Exception ex) {
                logger.error("Exception during listener shutdown", (Throwable)ex);
            }
        }
        if (this.modules.isEmpty()) {
            return;
        }
        logger.info("Shutting down " + this.modules.size() + " modules ...");
        for (Module module : this.modules.values()) {
            try {
                module.stop();
                module.destroy();
            }
            catch (Exception ex) {
                logger.error("Exception during module shutdown", (Throwable)ex);
            }
        }
        logger.info("Shutting down plugins ...");
        if (this.pluginManager != null) {
            try {
                this.pluginManager.shutdown();
            }
            catch (Exception ex) {
                logger.error("Exception during plugin shutdown", (Throwable)ex);
            }
        }
        this.modules.clear();
        try {
            DbConnectionManager.destroyConnectionProvider();
        }
        catch (Exception ex) {
            logger.error("Exception during DB shutdown", (Throwable)ex);
        }
        TaskEngine.getInstance().shutdown();
        logger.info("Openfire stopped");
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public ConnectionManager getConnectionManager() {
        return (ConnectionManager)((Object)this.modules.get(ConnectionManagerImpl.class));
    }

    public RoutingTable getRoutingTable() {
        return (RoutingTable)((Object)this.modules.get(RoutingTableImpl.class));
    }

    public PacketDeliverer getPacketDeliverer() {
        return (PacketDeliverer)((Object)this.modules.get(PacketDelivererImpl.class));
    }

    public RosterManager getRosterManager() {
        return (RosterManager)this.modules.get(RosterManager.class);
    }

    public PresenceManager getPresenceManager() {
        return (PresenceManager)((Object)this.modules.get(PresenceManagerImpl.class));
    }

    public OfflineMessageStore getOfflineMessageStore() {
        return (OfflineMessageStore)this.modules.get(OfflineMessageStore.class);
    }

    public OfflineMessageStrategy getOfflineMessageStrategy() {
        return (OfflineMessageStrategy)this.modules.get(OfflineMessageStrategy.class);
    }

    public PacketRouter getPacketRouter() {
        return (PacketRouter)((Object)this.modules.get(PacketRouterImpl.class));
    }

    public IQRegisterHandler getIQRegisterHandler() {
        return (IQRegisterHandler)this.modules.get(IQRegisterHandler.class);
    }

    public IQPEPHandler getIQPEPHandler() {
        return (IQPEPHandler)this.modules.get(IQPEPHandler.class);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public PubSubModule getPubSubModule() {
        return (PubSubModule)this.modules.get(PubSubModule.class);
    }

    public List<IQHandler> getIQHandlers() {
        ArrayList<IQHandler> answer = new ArrayList<IQHandler>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof IQHandler)) continue;
            answer.add((IQHandler)module);
        }
        return answer;
    }

    public SessionManager getSessionManager() {
        return (SessionManager)this.modules.get(SessionManager.class);
    }

    public TransportHandler getTransportHandler() {
        return (TransportHandler)this.modules.get(TransportHandler.class);
    }

    public PresenceUpdateHandler getPresenceUpdateHandler() {
        return (PresenceUpdateHandler)this.modules.get(PresenceUpdateHandler.class);
    }

    public PresenceSubscribeHandler getPresenceSubscribeHandler() {
        return (PresenceSubscribeHandler)this.modules.get(PresenceSubscribeHandler.class);
    }

    public IQRouter getIQRouter() {
        return (IQRouter)this.modules.get(IQRouter.class);
    }

    public MessageRouter getMessageRouter() {
        return (MessageRouter)this.modules.get(MessageRouter.class);
    }

    public PresenceRouter getPresenceRouter() {
        return (PresenceRouter)this.modules.get(PresenceRouter.class);
    }

    public MulticastRouter getMulticastRouter() {
        return (MulticastRouter)this.modules.get(MulticastRouter.class);
    }

    public UserManager getUserManager() {
        return UserManager.getInstance();
    }

    public LockOutManager getLockOutManager() {
        return LockOutManager.getInstance();
    }

    public UpdateManager getUpdateManager() {
        return (UpdateManager)this.modules.get(UpdateManager.class);
    }

    public AuditManager getAuditManager() {
        return (AuditManager)((Object)this.modules.get(AuditManagerImpl.class));
    }

    public List<ServerFeaturesProvider> getServerFeaturesProviders() {
        ArrayList<ServerFeaturesProvider> answer = new ArrayList<ServerFeaturesProvider>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof ServerFeaturesProvider)) continue;
            answer.add((ServerFeaturesProvider)((Object)module));
        }
        return answer;
    }

    public List<ServerIdentitiesProvider> getServerIdentitiesProviders() {
        ArrayList<ServerIdentitiesProvider> answer = new ArrayList<ServerIdentitiesProvider>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof ServerIdentitiesProvider)) continue;
            answer.add((ServerIdentitiesProvider)((Object)module));
        }
        return answer;
    }

    public List<ServerItemsProvider> getServerItemsProviders() {
        ArrayList<ServerItemsProvider> answer = new ArrayList<ServerItemsProvider>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof ServerItemsProvider)) continue;
            answer.add((ServerItemsProvider)((Object)module));
        }
        return answer;
    }

    public List<UserIdentitiesProvider> getUserIdentitiesProviders() {
        ArrayList<UserIdentitiesProvider> answer = new ArrayList<UserIdentitiesProvider>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof UserIdentitiesProvider)) continue;
            answer.add((UserIdentitiesProvider)((Object)module));
        }
        return answer;
    }

    public List<UserItemsProvider> getUserItemsProviders() {
        ArrayList<UserItemsProvider> answer = new ArrayList<UserItemsProvider>();
        for (Module module : this.modules.values()) {
            if (!(module instanceof UserItemsProvider)) continue;
            answer.add((UserItemsProvider)((Object)module));
        }
        return answer;
    }

    public IQDiscoInfoHandler getIQDiscoInfoHandler() {
        return (IQDiscoInfoHandler)this.modules.get(IQDiscoInfoHandler.class);
    }

    public IQDiscoItemsHandler getIQDiscoItemsHandler() {
        return (IQDiscoItemsHandler)this.modules.get(IQDiscoItemsHandler.class);
    }

    public PrivateStorage getPrivateStorage() {
        return (PrivateStorage)this.modules.get(PrivateStorage.class);
    }

    public MultiUserChatManager getMultiUserChatManager() {
        return (MultiUserChatManager)this.modules.get(MultiUserChatManager.class);
    }

    public AdHocCommandHandler getAdHocCommandHandler() {
        return (AdHocCommandHandler)this.modules.get(AdHocCommandHandler.class);
    }

    public FileTransferProxy getFileTransferProxy() {
        return (FileTransferProxy)this.modules.get(FileTransferProxy.class);
    }

    public FileTransferManager getFileTransferManager() {
        return (FileTransferManager)this.modules.get(DefaultFileTransferManager.class);
    }

    public MediaProxyService getMediaProxyService() {
        return (MediaProxyService)this.modules.get(MediaProxyService.class);
    }

    public FlashCrossDomainHandler getFlashCrossDomainHandler() {
        return (FlashCrossDomainHandler)this.modules.get(FlashCrossDomainHandler.class);
    }

    public VCardManager getVCardManager() {
        return VCardManager.getInstance();
    }

    private InternalComponentManager getComponentManager() {
        return (InternalComponentManager)this.modules.get(InternalComponentManager.class);
    }

    public CertificateStoreManager getCertificateStoreManager() {
        return (CertificateStoreManager)this.modules.get(CertificateStoreManager.class);
    }

    public RemoteSessionLocator getRemoteSessionLocator() {
        return this.remoteSessionLocator;
    }

    public void setRemoteSessionLocator(RemoteSessionLocator remoteSessionLocator) {
        this.remoteSessionLocator = remoteSessionLocator;
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        DEFAULT_NODE_ID = NodeID.getInstance(new byte[0]);
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
                System.exit(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        @Override
        public void run() {
            XMPPServer.this.shutdownServer();
            logger.info("Server halted");
            System.err.println("Server halted");
        }
    }

    private class Terminator
    extends TimerTask {
        private BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));

        private Terminator() {
        }

        @Override
        public void run() {
            try {
                if (this.stdin.ready() && XMPPServer.EXIT.equalsIgnoreCase(this.stdin.readLine())) {
                    System.exit(0);
                }
            }
            catch (IOException ioe) {
                logger.error("Error reading console input", (Throwable)ioe);
            }
        }
    }
}

