/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class MulticastRouter
extends BasicModule
implements ServerFeaturesProvider,
IQResultListener {
    private static final Logger Log = LoggerFactory.getLogger(MulticastRouter.class);
    private static final String NAMESPACE = "http://jabber.org/protocol/address";
    private XMPPServer server;
    private PacketRouter packetRouter;
    private IQRouter iqRouter;
    private Cache<String, String> cache;
    private Map<String, Collection<Packet>> remotePackets = new HashMap<String, Collection<Packet>>();
    private Map<String, Collection<String>> nodes = new ConcurrentHashMap<String, Collection<String>>();
    private Map<String, String> roots = new ConcurrentHashMap<String, String>();

    public MulticastRouter() {
        super("Multicast Packet Router");
        String cacheName = "Multicast Service";
        this.cache = CacheFactory.createCache(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void route(Packet packet) {
        HashSet<String> remoteServers = new HashSet<String>();
        ArrayList<String> targets = new ArrayList<String>();
        Packet localBroadcast = packet.createCopy();
        Element addresses = this.getAddresses(localBroadcast);
        String localDomain = "@" + this.server.getServerInfo().getXMPPDomain();
        Iterator it = addresses.elementIterator("address");
        while (it.hasNext()) {
            Element address = (Element)it.next();
            if (Type.noreply.toString().equals(address.attributeValue("type"))) continue;
            String jid = address.attributeValue("jid");
            if (jid.contains(localDomain) && address.attributeValue("delivered") == null) {
                targets.add(jid);
            } else if (!jid.contains(localDomain)) {
                remoteServers.add(new JID(jid).getDomain());
            }
            address.addAttribute("delivered", "true");
            if (!Type.bcc.toString().equals(address.attributeValue("type"))) continue;
            it.remove();
        }
        for (String jid : targets) {
            localBroadcast.setTo(jid);
            this.packetRouter.route(localBroadcast);
        }
        for (String domain : remoteServers) {
            boolean shouldDiscover = false;
            String string = domain.intern();
            synchronized (string) {
                Collection<Packet> packets = this.remotePackets.get(domain);
                if (packets == null) {
                    packets = new ArrayList<Packet>();
                    this.remotePackets.put(domain, packets);
                    shouldDiscover = true;
                }
                packets.add(packet);
            }
            if (!shouldDiscover) continue;
            this.sendToRemoteEntity(domain);
        }
    }

    private Element getAddresses(Packet packet) {
        if (packet instanceof IQ) {
            return ((IQ)packet).getChildElement().element("addresses");
        }
        return packet.getElement().element("addresses");
    }

    private void sendToRemoteEntity(String domain) {
        String multicastService = (String)this.cache.get(domain);
        if (multicastService != null) {
            this.sendToRemoteServer(domain, multicastService);
        } else {
            IQ iq = new IQ(IQ.Type.get);
            iq.setFrom(this.server.getServerInfo().getXMPPDomain());
            iq.setTo(domain);
            iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
            this.nodes.put(domain, new CopyOnWriteArrayList());
            this.iqRouter.addIQResultListener(iq.getID(), this);
            this.iqRouter.route(iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRemoteServer(String domain, String multicastService) {
        Collection<Packet> packets = null;
        Iterator<Packet> iterator = domain.intern();
        synchronized (iterator) {
            packets = this.remotePackets.remove(domain);
        }
        if (multicastService != null && multicastService.trim().length() > 0) {
            for (Packet packet : packets) {
                Element addresses = this.getAddresses(packet);
                Iterator it = addresses.elementIterator("address");
                while (it.hasNext()) {
                    Element address = (Element)it.next();
                    String jid = address.attributeValue("jid");
                    if (jid.contains("@" + domain)) continue;
                    if (Type.bcc.toString().equals(address.attributeValue("type"))) {
                        it.remove();
                        continue;
                    }
                    address.addAttribute("delivered", "true");
                }
                packet.setTo(multicastService);
                this.packetRouter.route(packet);
            }
        } else {
            for (Packet packet : packets) {
                Element addresses = this.getAddresses(packet);
                ArrayList<String> targets = new ArrayList<String>();
                Iterator it = addresses.elementIterator("address");
                while (it.hasNext()) {
                    Element address = (Element)it.next();
                    String jid = address.attributeValue("jid");
                    if (jid.contains("@" + domain)) {
                        targets.add(jid);
                    }
                    address.addAttribute("delivered", "true");
                    if (!Type.bcc.toString().equals(address.attributeValue("type"))) continue;
                    it.remove();
                }
                for (String jid : targets) {
                    packet.setTo(jid);
                    this.packetRouter.route(packet);
                }
            }
        }
    }

    public void receivedAnswer(IQ packet) {
        block10: {
            String domain;
            block8: {
                block12: {
                    Collection<String> items;
                    boolean isRoot;
                    block11: {
                        block9: {
                            domain = packet.getFrom().toString();
                            isRoot = true;
                            if (!this.nodes.containsKey(domain)) {
                                domain = this.roots.get(domain);
                                isRoot = false;
                            }
                            if (!"http://jabber.org/protocol/disco#info".equals(packet.getChildElement().getNamespaceURI())) break block8;
                            boolean supports = false;
                            Iterator it = packet.getChildElement().elementIterator("feature");
                            while (it.hasNext()) {
                                if (!NAMESPACE.equals(((Element)it.next()).attributeValue("var"))) continue;
                                supports = true;
                                break;
                            }
                            if (!supports) break block9;
                            items = this.nodes.remove(domain);
                            for (String item : items) {
                                this.roots.remove(item);
                            }
                            String multicastService = packet.getFrom().toString();
                            this.cache.put(domain, multicastService);
                            this.sendToRemoteServer(domain, multicastService);
                            break block10;
                        }
                        if (!isRoot || IQ.Type.error == packet.getType()) break block11;
                        IQ iq = new IQ(IQ.Type.get);
                        iq.setFrom(this.server.getServerInfo().getXMPPDomain());
                        iq.setTo(packet.getFrom());
                        iq.setChildElement("query", "http://jabber.org/protocol/disco#items");
                        this.iqRouter.addIQResultListener(iq.getID(), this);
                        this.iqRouter.route(iq);
                        break block10;
                    }
                    if (isRoot) break block12;
                    this.roots.remove(packet.getFrom().toString());
                    items = this.nodes.get(domain);
                    if (items == null) break block10;
                    items.remove(packet.getFrom().toString());
                    if (!items.isEmpty()) break block10;
                    this.nodes.remove(domain);
                    this.cache.put(domain, "");
                    this.sendToRemoteServer(domain, "");
                    break block10;
                }
                this.nodes.remove(domain);
                this.cache.put(domain, "");
                this.sendToRemoteServer(domain, "");
                break block10;
            }
            List items = packet.getChildElement().elements("item");
            if (IQ.Type.error == packet.getType() || items.isEmpty()) {
                this.nodes.remove(domain);
                this.cache.put(domain, "");
                this.sendToRemoteServer(domain, "");
            } else {
                ArrayList<String> jids = new ArrayList<String>();
                for (Element item : items) {
                    String jid = item.attributeValue("jid");
                    jids.add(jid);
                    this.roots.put(jid, domain);
                }
                this.nodes.put(domain, new CopyOnWriteArrayList(jids));
                for (Element item : items) {
                    IQ iq = new IQ(IQ.Type.get);
                    iq.setFrom(this.server.getServerInfo().getXMPPDomain());
                    iq.setTo(item.attributeValue("jid"));
                    Element child = iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
                    if (item.attributeValue("node") != null) {
                        child.addAttribute("node", item.attributeValue("node"));
                    }
                    this.iqRouter.addIQResultListener(iq.getID(), this);
                    this.iqRouter.route(iq);
                }
            }
        }
    }

    public void answerTimeout(String packetId) {
        Log.warn("An answer to a previously sent IQ stanza was never received. Packet id: " + packetId);
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(NAMESPACE).iterator();
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.packetRouter = server.getPacketRouter();
        this.iqRouter = server.getIQRouter();
    }

    private static enum Type {
        bcc,
        cc,
        noreply,
        replyroom,
        replyto,
        to;

    }
}

