/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.bugfix.OF33;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager {
    private static final Logger Log = LoggerFactory.getLogger(SchemaManager.class);
    private static final String CHECK_VERSION_OLD = "SELECT minorVersion FROM jiveVersion";
    private static final String CHECK_VERSION = "SELECT version FROM ofVersion WHERE name=?";
    private static final String CHECK_VERSION_JIVE = "SELECT version FROM jiveVersion WHERE name=?";
    private static final int DATABASE_VERSION = 26;

    public boolean checkOpenfireSchema(Connection con) {
        this.updateToOpenfire(con);
        try {
            return this.checkSchema(con, "openfire", 26, new ResourceLoader(){

                @Override
                public InputStream loadResource(String resourceName) {
                    File file = new File(JiveGlobals.getHomeDirectory() + File.separator + "resources" + File.separator + "database", resourceName);
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("upgrade.database.failure"), (Throwable)e);
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.failure"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPluginSchema(final Plugin plugin) {
        final PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        String schemaKey = pluginManager.getDatabaseKey(plugin);
        int schemaVersion = pluginManager.getDatabaseVersion(plugin);
        if (schemaKey == null || schemaVersion == -1) {
            return true;
        }
        Connection con = null;
        try {
            con = DbConnectionManager.getConnection();
            boolean bl = this.checkSchema(con, schemaKey, schemaVersion, new ResourceLoader(){

                @Override
                public InputStream loadResource(String resourceName) {
                    File file = new File(pluginManager.getPluginDirectory(plugin) + File.separator + "database", resourceName);
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
            });
            return bl;
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("upgrade.database.failure"), (Throwable)e);
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.failure"));
        }
        finally {
            DbConnectionManager.closeConnection(con);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkSchema(Connection con, String schemaKey, int requiredVersion, ResourceLoader resourceLoader) throws Exception {
        ResultSet rs;
        PreparedStatement pstmt;
        int currentVersion;
        block59: {
            currentVersion = -1;
            pstmt = null;
            rs = null;
            try {
                pstmt = con.prepareStatement(CHECK_VERSION);
                pstmt.setString(1, schemaKey);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block59;
                currentVersion = rs.getInt(1);
            }
            catch (SQLException sqle) {
                block60: {
                    try {
                        Log.debug("SchemaManager: Error verifying " + schemaKey + " version, probably ignorable.", (Throwable)sqle);
                        DbConnectionManager.closeStatement(rs, pstmt);
                        if (!schemaKey.equals("openfire")) break block60;
                        try {
                            pstmt = con.prepareStatement(CHECK_VERSION_JIVE);
                            pstmt.setString(1, schemaKey);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                currentVersion = rs.getInt(1);
                            }
                        }
                        catch (SQLException sqlea) {
                            Log.debug("SchemaManager: Error verifying " + schemaKey + " version, probably ignorable.", (Throwable)sqlea);
                            DbConnectionManager.closeStatement(rs, pstmt);
                            try {
                                pstmt = con.prepareStatement(CHECK_VERSION_OLD);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    currentVersion = rs.getInt(1);
                                }
                            }
                            catch (SQLException sqle2) {
                                Log.debug("SchemaManager: Error verifying " + schemaKey + " version, probably ignorable", (Throwable)sqle2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeStatement(rs, pstmt);
                        throw throwable;
                    }
                }
                DbConnectionManager.closeStatement(rs, pstmt);
            }
        }
        DbConnectionManager.closeStatement(rs, pstmt);
        if (currentVersion >= requiredVersion) {
            return true;
        }
        if (currentVersion == -1) {
            Log.info(LocaleUtils.getLocalizedString("upgrade.database.missing_schema", Arrays.asList(schemaKey)));
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.missing_schema", Arrays.asList(schemaKey)));
            String resourceName = schemaKey + "_" + (Object)((Object)DbConnectionManager.getDatabaseType()) + ".sql";
            try (InputStream resource = resourceLoader.loadResource(resourceName);){
                if (resource == null) {
                    boolean bl = false;
                    return bl;
                }
                SchemaManager.executeSQLScript(con, resource, !schemaKey.equals("openfire") && !schemaKey.equals("wildfire"));
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
                return false;
            }
            Log.info(LocaleUtils.getLocalizedString("upgrade.database.success"));
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.success"));
            return true;
        }
        Log.info(LocaleUtils.getLocalizedString("upgrade.database.old_schema", Arrays.asList(currentVersion, schemaKey, requiredVersion)));
        System.out.println(LocaleUtils.getLocalizedString("upgrade.database.old_schema", Arrays.asList(currentVersion, schemaKey, requiredVersion)));
        if (DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.unknown) {
            Log.info(LocaleUtils.getLocalizedString("upgrade.database.unknown_db"));
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.unknown_db"));
            return false;
        }
        if (DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.interbase) {
            Log.info(LocaleUtils.getLocalizedString("upgrade.database.interbase_db"));
            System.out.println(LocaleUtils.getLocalizedString("upgrade.database.interbase_db"));
            return false;
        }
        int i = currentVersion + 1;
        while (true) {
            if (i > requiredVersion) {
                Log.info(LocaleUtils.getLocalizedString("upgrade.database.success"));
                System.out.println(LocaleUtils.getLocalizedString("upgrade.database.success"));
                return true;
            }
            try (InputStream resource = this.getUpgradeResource(resourceLoader, i, schemaKey);){
                try {
                    if (i == 21 && schemaKey.equals("openfire")) {
                        OF33.executeFix(con);
                    }
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                    boolean bl = false;
                    if (resource == null) return bl;
                    if (var10_18 == null) {
                        resource.close();
                        return bl;
                    }
                    try {
                        resource.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var10_18.addSuppressed(throwable);
                        return bl;
                    }
                }
                if (resource != null) {
                    SchemaManager.executeSQLScript(con, resource, !schemaKey.equals("openfire") && !schemaKey.equals("wildfire"));
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
                return false;
            }
            ++i;
        }
    }

    private InputStream getUpgradeResource(ResourceLoader resourceLoader, int upgradeVersion, String schemaKey) {
        InputStream resource = null;
        if ("openfire".equals(schemaKey)) {
            String path = JiveGlobals.getHomeDirectory() + File.separator + "resources" + File.separator + "database" + File.separator + "upgrade" + File.separator + upgradeVersion;
            String filename = schemaKey + "_" + (Object)((Object)DbConnectionManager.getDatabaseType()) + ".sql";
            File file = new File(path, filename);
            try {
                resource = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            String resourceName = "upgrade/" + upgradeVersion + "/" + schemaKey + "_" + (Object)((Object)DbConnectionManager.getDatabaseType()) + ".sql";
            resource = resourceLoader.loadResource(resourceName);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToOpenfire(Connection con) {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement("UPDATE jiveVersion SET name='openfire' WHERE name='wildfire'");
            pstmt.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void executeSQLScript(Connection con, InputStream resource, Boolean autoreplace) throws IOException, SQLException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resource));){
            boolean done = false;
            while (!done) {
                String line;
                StringBuilder command = new StringBuilder();
                do {
                    if ((line = in.readLine()) == null) {
                        done = true;
                        break;
                    }
                    if (!SchemaManager.isSQLCommandPart(line)) continue;
                    command.append(' ').append(line);
                } while (!line.trim().endsWith(";"));
                if (done || command.toString().equals("")) continue;
                if (DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.oracle || DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.db2) {
                    command.deleteCharAt(command.length() - 1);
                }
                Statement stmt = null;
                try {
                    String cmdString = command.toString();
                    if (autoreplace.booleanValue()) {
                        cmdString = cmdString.replaceAll("jiveVersion", "ofVersion");
                    }
                    stmt = con.createStatement();
                    stmt.execute(cmdString);
                }
                catch (SQLException e) {
                    try {
                        Log.error("SchemaManager: Failed to execute SQL:\n" + command.toString());
                        throw e;
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeStatement(stmt);
                        throw throwable;
                        return;
                    }
                }
                DbConnectionManager.closeStatement(stmt);
            }
        }
    }

    private static boolean isSQLCommandPart(String line) {
        if ((line = line.trim()).equals("")) {
            return false;
        }
        return !line.startsWith("//") && !line.startsWith("--") && !line.startsWith("#") && !line.startsWith("REM") && !line.startsWith("/*") && !line.startsWith("*");
    }

    private static abstract class ResourceLoader {
        private ResourceLoader() {
        }

        public abstract InputStream loadResource(String var1);
    }
}

