/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jivesoftware.database.ConnectionProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIDataSourceProvider
implements ConnectionProvider {
    private static final Logger Log = LoggerFactory.getLogger(JNDIDataSourceProvider.class);
    private String dataSourceName = JiveGlobals.getXMLProperty("database.JNDIProvider.name");
    private DataSource dataSource;
    private static final String[] jndiPropertyKeys = new String[]{"java.naming.applet", "java.naming.authoritative", "java.naming.batchsize", "java.naming.dns.url", "java.naming.factory.initial", "java.naming.language", "java.naming.factory.object", "java.naming.provider.url", "java.naming.referral", "java.naming.security.authentication", "java.naming.security.credentials", "java.naming.security.principal", "java.naming.security.protocol", "java.naming.factory.state", "java.naming.factory.url.pkgs"};

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public void start() {
        if (this.dataSourceName == null || this.dataSourceName.equals("")) {
            Log.error("No name specified for DataSource. JNDI lookup will fail", new Throwable());
            return;
        }
        try {
            Properties contextProperties = new Properties();
            for (String key : jndiPropertyKeys) {
                String value = JiveGlobals.getXMLProperty(key);
                if (value == null) continue;
                contextProperties.setProperty(key, value);
            }
            InitialContext context = contextProperties.size() > 0 ? new InitialContext(contextProperties) : new InitialContext();
            this.dataSource = (DataSource)context.lookup(this.dataSourceName);
        }
        catch (Exception e) {
            Log.error("Could not lookup DataSource at '" + this.dataSourceName + "'", (Throwable)e);
        }
    }

    @Override
    public void restart() {
        this.destroy();
        this.start();
    }

    @Override
    public void destroy() {
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("DataSource has not been initialized.");
        }
        return this.dataSource.getConnection();
    }
}

