/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import org.jivesoftware.admin.LdapUserProfile;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapUserTester {
    private static final Logger Log = LoggerFactory.getLogger(LdapUserTester.class);
    public static final String NAME = "Name";
    public static final String EMAIL = "Email";
    public static final String FULL_NAME = "FullName";
    public static final String NICKNAME = "Nickname";
    public static final String BIRTHDAY = "Birthday";
    public static final String PHOTO = "Photo";
    public static final String HOME_STREET = "HomeStreet";
    public static final String HOME_CITY = "HomeCity";
    public static final String HOME_STATE = "HomeState";
    public static final String HOME_ZIP = "HomeZip";
    public static final String HOME_COUNTRY = "HomeCountry";
    public static final String HOME_PHONE = "HomePhone";
    public static final String HOME_MOBILE = "HomeMobile";
    public static final String HOME_FAX = "HomeFax";
    public static final String HOME_PAGER = "HomePager";
    public static final String BUSINESS_STREET = "BusinessStreet";
    public static final String BUSINESS_CITY = "BusinessCity";
    public static final String BUSINESS_STATE = "BusinessState";
    public static final String BUSINESS_ZIP = "BusinessZip";
    public static final String BUSINESS_COUNTRY = "BusinessCountry";
    public static final String BUSINESS_JOB_TITLE = "BusinessJobTitle";
    public static final String BUSINESS_DEPARTMENT = "BusinessDepartment";
    public static final String BUSINESS_PHONE = "BusinessPhone";
    public static final String BUSINESS_MOBILE = "BusinessMobile";
    public static final String BUSINESS_FAX = "BusinessFax";
    public static final String BUSINESS_PAGER = "BusinessPager";
    private LdapManager manager;
    private LdapUserProfile profile;

    public LdapUserTester(LdapManager manager, LdapUserProfile profile) {
        this.manager = manager;
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSample(int maxSample) throws NamingException {
        ArrayList<String> usernames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            Control[] searchControl;
            ctx = this.manager.getContext();
            try {
                searchControl = new Control[]{new SortControl(new String[]{this.manager.getUsernameField()}, false)};
            }
            catch (IOException e) {
                Log.error(e.getMessage(), (Throwable)e);
                List<String> list = Collections.emptyList();
                try {
                    if (ctx != null) {
                        ctx.setRequestControls(null);
                        ctx.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return list;
            }
            ctx.setRequestControls(searchControl);
            SearchControls searchControls = new SearchControls();
            if (this.manager.isSubTreeSearch()) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setReturningAttributes(new String[]{this.manager.getUsernameField()});
            searchControls.setCountLimit(maxSample);
            String filter = MessageFormat.format(this.manager.getSearchFilter(), "*");
            NamingEnumeration<SearchResult> answer = ctx.search("", filter, searchControls);
            while (answer.hasMoreElements()) {
                String username = (String)answer.next().getAttributes().get(this.manager.getUsernameField()).get();
                usernames.add(JID.escapeNode((String)username));
            }
            answer.close();
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.setRequestControls(null);
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAttributes(String username) {
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        username = JID.unescapeNode((String)username);
        Context ctx = null;
        try {
            String userDN = this.manager.findUserDN(username);
            Map<String, PropertyMapping> ldapMappings = this.getLdapAttributes();
            HashSet<String> fields = new HashSet<String>();
            for (PropertyMapping mapping : ldapMappings.values()) {
                fields.addAll(mapping.getFields());
            }
            fields.add(this.manager.getUsernameField());
            ctx = this.manager.getContext(this.manager.getUsersBaseDN(username));
            Attributes attrs = ctx.getAttributes(userDN, fields.toArray(new String[0]));
            for (Map.Entry<String, PropertyMapping> entry : ldapMappings.entrySet()) {
                String attribute = entry.getKey();
                PropertyMapping mapping = entry.getValue();
                String value = mapping.getDisplayFormat();
                for (String field : mapping.getFields()) {
                    Attribute ldapField = attrs.get(field);
                    if (ldapField == null) continue;
                    Object ob = ldapField.get();
                    String answer = ob instanceof String ? (String)ob : Base64.encodeBytes((byte[])ob);
                    value = value.replace("{" + field + "}", answer);
                }
                userAttributes.put(attribute, value);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return userAttributes;
    }

    private Map<String, PropertyMapping> getLdapAttributes() {
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        if (this.profile.getName() != null && this.profile.getName().trim().length() > 0) {
            map.put(NAME, new PropertyMapping(this.profile.getName()));
        }
        if (this.profile.getEmail() != null && this.profile.getEmail().trim().length() > 0) {
            map.put(EMAIL, new PropertyMapping(this.profile.getEmail()));
        }
        if (this.profile.getFullName() != null && this.profile.getFullName().trim().length() > 0) {
            map.put(FULL_NAME, new PropertyMapping(this.profile.getFullName()));
        }
        if (this.profile.getNickname() != null && this.profile.getNickname().trim().length() > 0) {
            map.put(NICKNAME, new PropertyMapping(this.profile.getNickname()));
        }
        if (this.profile.getBirthday() != null && this.profile.getBirthday().trim().length() > 0) {
            map.put(BIRTHDAY, new PropertyMapping(this.profile.getBirthday()));
        }
        if (this.profile.getPhoto() != null && this.profile.getPhoto().trim().length() > 0) {
            map.put(PHOTO, new PropertyMapping(this.profile.getPhoto()));
        }
        if (this.profile.getHomeStreet() != null && this.profile.getHomeStreet().trim().length() > 0) {
            map.put(HOME_STREET, new PropertyMapping(this.profile.getHomeStreet()));
        }
        if (this.profile.getHomeCity() != null && this.profile.getHomeCity().trim().length() > 0) {
            map.put(HOME_CITY, new PropertyMapping(this.profile.getHomeCity()));
        }
        if (this.profile.getHomeState() != null && this.profile.getHomeState().trim().length() > 0) {
            map.put(HOME_STATE, new PropertyMapping(this.profile.getHomeState()));
        }
        if (this.profile.getHomeZip() != null && this.profile.getHomeZip().trim().length() > 0) {
            map.put(HOME_ZIP, new PropertyMapping(this.profile.getHomeZip()));
        }
        if (this.profile.getHomeCountry() != null && this.profile.getHomeCountry().trim().length() > 0) {
            map.put(HOME_COUNTRY, new PropertyMapping(this.profile.getHomeCountry()));
        }
        if (this.profile.getHomePhone() != null && this.profile.getHomePhone().trim().length() > 0) {
            map.put(HOME_PHONE, new PropertyMapping(this.profile.getHomePhone()));
        }
        if (this.profile.getHomeMobile() != null && this.profile.getHomeMobile().trim().length() > 0) {
            map.put(HOME_MOBILE, new PropertyMapping(this.profile.getHomeMobile()));
        }
        if (this.profile.getHomeFax() != null && this.profile.getHomeFax().trim().length() > 0) {
            map.put(HOME_FAX, new PropertyMapping(this.profile.getHomeFax()));
        }
        if (this.profile.getHomePager() != null && this.profile.getHomePager().trim().length() > 0) {
            map.put(HOME_PAGER, new PropertyMapping(this.profile.getHomePager()));
        }
        if (this.profile.getBusinessStreet() != null && this.profile.getBusinessStreet().trim().length() > 0) {
            map.put(BUSINESS_STREET, new PropertyMapping(this.profile.getBusinessStreet()));
        }
        if (this.profile.getBusinessCity() != null && this.profile.getBusinessCity().trim().length() > 0) {
            map.put(BUSINESS_CITY, new PropertyMapping(this.profile.getBusinessCity()));
        }
        if (this.profile.getBusinessState() != null && this.profile.getBusinessState().trim().length() > 0) {
            map.put(BUSINESS_STATE, new PropertyMapping(this.profile.getBusinessState()));
        }
        if (this.profile.getBusinessZip() != null && this.profile.getBusinessZip().trim().length() > 0) {
            map.put(BUSINESS_ZIP, new PropertyMapping(this.profile.getBusinessZip()));
        }
        if (this.profile.getBusinessCountry() != null && this.profile.getBusinessCountry().trim().length() > 0) {
            map.put(BUSINESS_COUNTRY, new PropertyMapping(this.profile.getBusinessCountry()));
        }
        if (this.profile.getBusinessJobTitle() != null && this.profile.getBusinessJobTitle().trim().length() > 0) {
            map.put(BUSINESS_JOB_TITLE, new PropertyMapping(this.profile.getBusinessJobTitle()));
        }
        if (this.profile.getBusinessDepartment() != null && this.profile.getBusinessDepartment().trim().length() > 0) {
            map.put(BUSINESS_DEPARTMENT, new PropertyMapping(this.profile.getBusinessDepartment()));
        }
        if (this.profile.getBusinessPhone() != null && this.profile.getBusinessPhone().trim().length() > 0) {
            map.put(BUSINESS_PHONE, new PropertyMapping(this.profile.getBusinessPhone()));
        }
        if (this.profile.getBusinessMobile() != null && this.profile.getBusinessMobile().trim().length() > 0) {
            map.put(BUSINESS_MOBILE, new PropertyMapping(this.profile.getBusinessMobile()));
        }
        if (this.profile.getBusinessFax() != null && this.profile.getBusinessFax().trim().length() > 0) {
            map.put(BUSINESS_FAX, new PropertyMapping(this.profile.getBusinessFax()));
        }
        if (this.profile.getBusinessPager() != null && this.profile.getBusinessPager().trim().length() > 0) {
            map.put(BUSINESS_PAGER, new PropertyMapping(this.profile.getBusinessPager()));
        }
        return map;
    }

    private static class PropertyMapping {
        private String displayFormat;
        private Collection<String> fields = new ArrayList<String>();

        public PropertyMapping(String displayFormat) {
            this.displayFormat = displayFormat;
            StringTokenizer st = new StringTokenizer(displayFormat.trim(), ", //{}");
            while (st.hasMoreTokens()) {
                this.fields.add(st.nextToken().replaceFirst("(\\{)([\\d\\D&&[^}]]+)(})", "$2"));
            }
        }

        public String getDisplayFormat() {
            return this.displayFormat;
        }

        public Collection<String> getFields() {
            return this.fields;
        }
    }
}

