/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapGroupTester {
    private static final Logger Log = LoggerFactory.getLogger(LdapGroupTester.class);
    private LdapManager manager;

    public LdapGroupTester(LdapManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroups(int maxGroups) {
        ArrayList<Group> groups = new ArrayList<Group>();
        LdapContext ctx = null;
        try {
            ctx = this.manager.getContext();
            Control[] searchControl = new Control[]{new SortControl(new String[]{this.manager.getGroupNameField()}, false)};
            ctx.setRequestControls(searchControl);
            SearchControls searchControls = new SearchControls();
            if (this.manager.isSubTreeSearch()) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            String[] standardAttributes = new String[]{this.manager.getGroupNameField(), this.manager.getGroupDescriptionField(), this.manager.getGroupMemberField()};
            searchControls.setReturningAttributes(standardAttributes);
            searchControls.setCountLimit(maxGroups);
            String filter = MessageFormat.format(this.manager.getGroupSearchFilter(), "*");
            NamingEnumeration<SearchResult> answer = ctx.search("", filter, searchControls);
            while (answer.hasMoreElements()) {
                Attributes attributes = answer.next().getAttributes();
                String groupName = (String)attributes.get(this.manager.getGroupNameField()).get();
                String description = "";
                int elements = 0;
                try {
                    description = (String)attributes.get(this.manager.getGroupDescriptionField()).get();
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception e) {
                    Log.error("Error retrieving group description", (Throwable)e);
                }
                Attribute memberField = attributes.get(this.manager.getGroupMemberField());
                if (memberField != null) {
                    NamingEnumeration<?> ne = memberField.getAll();
                    while (ne.hasMore()) {
                        ne.next();
                        ++elements;
                    }
                }
                groups.add(new Group(groupName, description, elements));
            }
            answer.close();
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.setRequestControls(null);
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return groups;
    }

    public static class Group {
        private String name;
        private String description;
        private int members;

        public Group(String name, String description, int members) {
            this.name = name;
            this.description = description;
            this.members = members;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getMembers() {
            return this.members;
        }
    }
}

