/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.admin.LoginLimitManager;
import org.jivesoftware.admin.ServletRequestAuthenticator;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.WebManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCheckFilter
implements Filter {
    private static final Logger Log = LoggerFactory.getLogger(AuthCheckFilter.class);
    private static AuthCheckFilter instance;
    private static Set<String> excludes;
    private final AdminManager adminManager;
    private final LoginLimitManager loginLimitManager;
    private final ServletRequestAuthenticator servletRequestAuthenticator;
    private ServletContext context;
    private String defaultLoginPage;

    public AuthCheckFilter() {
        this(AdminManager.getInstance(), LoginLimitManager.getInstance(), JiveGlobals.getProperty("adminConsole.servlet-request-authenticator", "").trim());
    }

    AuthCheckFilter(AdminManager adminManager, LoginLimitManager loginLimitManager, String servletRequestAuthenticatorClassName) {
        this.adminManager = adminManager;
        this.loginLimitManager = loginLimitManager;
        instance = this;
        ServletRequestAuthenticator authenticator = null;
        if (!servletRequestAuthenticatorClassName.isEmpty()) {
            try {
                Class clazz = ClassUtils.forName(servletRequestAuthenticatorClassName);
                authenticator = (ServletRequestAuthenticator)clazz.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading ServletRequestAuthenticator: " + servletRequestAuthenticatorClassName, (Throwable)e);
            }
        }
        this.servletRequestAuthenticator = authenticator;
    }

    public static AuthCheckFilter getInstance() {
        return instance;
    }

    public static boolean isServletRequestAuthenticatorInstanceOf(Class<? extends ServletRequestAuthenticator> clazz) {
        AuthCheckFilter instance = AuthCheckFilter.getInstance();
        if (instance == null) {
            return false;
        }
        ServletRequestAuthenticator authenticator = instance.servletRequestAuthenticator;
        return authenticator != null && clazz.isAssignableFrom(authenticator.getClass());
    }

    public static void addExclude(String exclude) {
        excludes.add(exclude);
    }

    public static void removeExclude(String exclude) {
        excludes.remove(exclude);
    }

    public static boolean testURLPassesExclude(String url, String exclude) {
        if (exclude.endsWith("*")) {
            if (url.startsWith(exclude.substring(0, exclude.length() - 1)) && !url.contains("..") && !url.toLowerCase().contains("%2e")) {
                return true;
            }
        } else if (exclude.contains("?")) {
            if (url.equals(exclude)) {
                return true;
            }
        } else {
            int paramIndex = url.indexOf("?");
            if (paramIndex != -1) {
                url = url.substring(0, paramIndex);
            }
            if (url.equals(exclude)) {
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
        this.defaultLoginPage = config.getInitParameter("defaultLoginPage");
        String excludesProp = config.getInitParameter("excludes");
        if (excludesProp != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludesProp, ",");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken().trim();
                excludes.add(tok);
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String url;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        response.addHeader("X-Frame-Options", JiveGlobals.getProperty("adminConsole.frame-options", "same"));
        String loginPage = this.defaultLoginPage;
        if (loginPage == null) {
            loginPage = request.getContextPath() + "/login.jsp";
        }
        if ((url = request.getRequestURI().substring(1)).startsWith("plugins/")) {
            url = url.substring("plugins/".length());
        }
        boolean doExclude = false;
        for (String exclude : excludes) {
            if (!AuthCheckFilter.testURLPassesExclude(url, exclude)) continue;
            doExclude = true;
            break;
        }
        if (!doExclude) {
            WebManager manager = new WebManager();
            manager.init(request, response, request.getSession(), this.context);
            if (manager.getUser() == null && !this.authUserFromRequest(request)) {
                response.sendRedirect(this.getRedirectURL(request, loginPage, null));
                return;
            }
        }
        chain.doFilter(req, res);
    }

    private boolean authUserFromRequest(HttpServletRequest request) {
        String userFromRequest;
        String string = userFromRequest = this.servletRequestAuthenticator == null ? null : this.servletRequestAuthenticator.authenticateRequest(request);
        if (userFromRequest == null) {
            return false;
        }
        if (!this.adminManager.isUserAdmin(userFromRequest, true)) {
            Log.warn("The user '" + userFromRequest + "' is not an Openfire administrator.");
            return false;
        }
        this.loginLimitManager.recordSuccessfulAttempt(userFromRequest, request.getRemoteAddr());
        request.getSession().setAttribute("jive.admin.authToken", (Object)new AuthToken(userFromRequest));
        return true;
    }

    public void destroy() {
    }

    private String getRedirectURL(HttpServletRequest request, String loginPage, String optionalParams) {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(request.getRequestURI());
            String qs = request.getQueryString();
            if (qs != null) {
                buf.append('?').append(qs);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            return loginPage + "?url=" + URLEncoder.encode(buf.toString(), "ISO-8859-1") + (optionalParams != null ? "&" + optionalParams : "");
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        excludes = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

