/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;

public class ASN1DERTag
extends BodyTagSupport {
    private byte[] value;

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int doEndTag() throws JspException {
        try {
            ASN1InputStream decoder = new ASN1InputStream(this.value);
            ASN1Primitive primitive = decoder.readObject();
            while (primitive != null && !(primitive instanceof ASN1Null)) {
                this.pageContext.getOut().write(this.doPrimitive(primitive));
                primitive = decoder.readObject();
            }
        }
        catch (Exception ex) {
            throw new JspException(ex.getMessage());
        }
        return super.doEndTag();
    }

    private String doPrimitive(ASN1Primitive primitive) throws IOException {
        if (primitive == null || primitive instanceof ASN1Null) {
            return "";
        }
        if (primitive instanceof ASN1Sequence) {
            return this.doCollection(((ASN1Sequence)primitive).toArray());
        }
        if (primitive instanceof ASN1Set) {
            return this.doCollection(((ASN1Set)primitive).toArray());
        }
        if (primitive instanceof DERTaggedObject) {
            DERTaggedObject tagged = (DERTaggedObject)primitive;
            return "<table><tr><td></td><td>" + this.doPrimitive(tagged.getObject()) + "</td></tr></table>";
        }
        return "<table><tr><td colspan='2'>" + this.asString(primitive) + "</td></tr></table>";
    }

    private String doCollection(ASN1Encodable[] asn1Encodables) throws IOException {
        switch (asn1Encodables.length) {
            case 1: {
                return "<table><tr><td colspan='2'>" + this.doPrimitive(asn1Encodables[0].toASN1Primitive()) + "</td></tr></table>";
            }
            case 2: {
                return "<table><tr><td>" + this.doPrimitive(asn1Encodables[0].toASN1Primitive()) + "</td><td>" + this.doPrimitive(asn1Encodables[1].toASN1Primitive()) + "</td></tr></table>";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (ASN1Encodable asn1Encodable : asn1Encodables) {
            sb.append("<table><tr><td colspan='2'>").append(this.doPrimitive(asn1Encodable.toASN1Primitive())).append("</td></tr></table>");
        }
        return sb.toString();
    }

    private String asString(ASN1Primitive primitive) {
        if (primitive == null || primitive instanceof ASN1Null) {
            return "";
        }
        if (primitive instanceof ASN1String) {
            return ((ASN1String)primitive).getString();
        }
        if (primitive instanceof DERUTCTime) {
            return ((DERUTCTime)primitive).getAdjustedTime();
        }
        if (primitive instanceof DERGeneralizedTime) {
            return ((DERGeneralizedTime)primitive).getTime();
        }
        if (primitive instanceof ASN1ObjectIdentifier) {
            switch (((ASN1ObjectIdentifier)primitive).getId()) {
                case "1.3.6.1.5.5.7.8.5": {
                    return "xmppAddr";
                }
            }
            return primitive.toString();
        }
        return primitive.toString();
    }
}

