/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.QName;
import org.dom4j.io.DispatchHandler;
import org.jivesoftware.openfire.net.MXParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMPPPacketReader {
    private DocumentFactory factory;
    private MXParser xppParser;
    private XmlPullParserFactory xppFactory;
    private DispatchHandler dispatchHandler;
    private long lastActive = System.currentTimeMillis();
    public static final Collection<String> IGNORED_NAMESPACE_ON_STANZA = Arrays.asList("jabber:client", "jabber:server", "jabber:connectionmanager", "jabber:component:accept", "http://jabber.org/protocol/httpbind");

    public XMPPPacketReader() {
    }

    public XMPPPacketReader(DocumentFactory factory) {
        this.factory = factory;
    }

    public Document read(File file) throws DocumentException, IOException, XmlPullParserException {
        String systemID = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), systemID);
    }

    public Document read(URL url) throws DocumentException, IOException, XmlPullParserException {
        String systemID = url.toExternalForm();
        return this.read(this.createReader(url.openStream()), systemID);
    }

    public Document read(String systemID) throws DocumentException, IOException, XmlPullParserException {
        if (systemID.indexOf(58) >= 0) {
            return this.read(new URL(systemID));
        }
        return this.read(new File(systemID));
    }

    public Document read(InputStream in) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(in));
    }

    public Document read(String charSet, InputStream in) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(in, charSet));
    }

    public Document read(Reader reader) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput(reader);
        return this.parseDocument();
    }

    public Document read(char[] text) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput(new CharArrayReader(text));
        return this.parseDocument();
    }

    public Document read(InputStream in, String systemID) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(in), systemID);
    }

    public Document read(Reader reader, String systemID) throws DocumentException, IOException, XmlPullParserException {
        Document document = this.read(reader);
        document.setName(systemID);
        return document;
    }

    public MXParser getXPPParser() throws XmlPullParserException {
        if (this.xppParser == null) {
            this.xppParser = (MXParser)this.getXPPFactory().newPullParser();
        }
        return this.xppParser;
    }

    public XmlPullParserFactory getXPPFactory() throws XmlPullParserException {
        if (this.xppFactory == null) {
            this.xppFactory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
        }
        this.xppFactory.setNamespaceAware(true);
        return this.xppFactory;
    }

    public void setXPPFactory(XmlPullParserFactory xppFactory) {
        this.xppFactory = xppFactory;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory factory) {
        this.factory = factory;
    }

    public void addHandler(String path, ElementHandler handler) {
        this.getDispatchHandler().addHandler(path, handler);
    }

    public void removeHandler(String path) {
        this.getDispatchHandler().removeHandler(path);
    }

    public void setDefaultHandler(ElementHandler handler) {
        this.getDispatchHandler().setDefaultHandler(handler);
    }

    public long getLastActive() {
        long lastHeartbeat = 0L;
        try {
            lastHeartbeat = this.getXPPParser().getLastHeartbeat();
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        return this.lastActive > lastHeartbeat ? this.lastActive : lastHeartbeat;
    }

    public Document parseDocument(String xml) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xml);
        return document;
    }

    public Document parseDocument() throws DocumentException, IOException, XmlPullParserException {
        DocumentFactory df = this.getDocumentFactory();
        Document document = df.createDocument();
        Element parent = null;
        MXParser pp = this.getXPPParser();
        int count = 0;
        while (true) {
            int type = -1;
            type = pp.nextToken();
            switch (type) {
                case 8: {
                    String text = pp.getText();
                    int loc = text.indexOf(" ");
                    if (loc >= 0) {
                        document.addProcessingInstruction(text.substring(0, loc), text.substring(loc + 1));
                        break;
                    }
                    document.addProcessingInstruction(text, "");
                    break;
                }
                case 9: {
                    if (parent != null) {
                        parent.addComment(pp.getText());
                        break;
                    }
                    document.addComment(pp.getText());
                    break;
                }
                case 5: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addCDATA(text);
                        break;
                    }
                    if (text.trim().length() <= 0) break;
                    throw new DocumentException("Cannot have text content outside of the root document");
                }
                case 6: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addText(text);
                        break;
                    }
                    if (text.trim().length() <= 0) break;
                    throw new DocumentException("Cannot have an entityref outside of the root document");
                }
                case 1: {
                    return document;
                }
                case 2: {
                    int i;
                    QName qname = pp.getPrefix() == null ? df.createQName(pp.getName(), pp.getNamespace()) : df.createQName(pp.getName(), pp.getPrefix(), pp.getNamespace());
                    boolean dropNamespace = false;
                    if (pp.getPrefix() == null && IGNORED_NAMESPACE_ON_STANZA.contains(qname.getNamespaceURI())) {
                        String defaultNS;
                        dropNamespace = true;
                        for (Element el = parent; el != null && !(defaultNS = el.getNamespaceForPrefix("").getURI()).equals(""); el = el.getParent()) {
                            if (defaultNS.equals(qname.getNamespaceURI())) continue;
                            dropNamespace = false;
                            break;
                        }
                    }
                    Element newElement = dropNamespace ? df.createElement(pp.getName()) : df.createElement(qname);
                    int nsStart = pp.getNamespaceCount(pp.getDepth() - 1);
                    int nsEnd = pp.getNamespaceCount(pp.getDepth());
                    for (i = nsStart; i < nsEnd; ++i) {
                        String namespacePrefix = pp.getNamespacePrefix(i);
                        String namespaceUri = pp.getNamespaceUri(i);
                        if (namespacePrefix != null) {
                            newElement.addNamespace(namespacePrefix, namespaceUri);
                            continue;
                        }
                        if (parent == null && IGNORED_NAMESPACE_ON_STANZA.contains(namespaceUri) || dropNamespace && namespaceUri.equals(qname.getNamespaceURI())) continue;
                        newElement.addNamespace("", namespaceUri);
                    }
                    for (i = 0; i < pp.getAttributeCount(); ++i) {
                        QName qa = pp.getAttributePrefix(i) == null ? df.createQName(pp.getAttributeName(i)) : df.createQName(pp.getAttributeName(i), pp.getAttributePrefix(i), pp.getAttributeNamespace(i));
                        newElement.addAttribute(qa, pp.getAttributeValue(i));
                    }
                    if (parent != null) {
                        parent.add(newElement);
                    } else {
                        document.add(newElement);
                    }
                    parent = newElement;
                    ++count;
                    break;
                }
                case 3: {
                    if (parent != null) {
                        parent = parent.getParent();
                    }
                    if (--count >= 1) break;
                    this.lastActive = System.currentTimeMillis();
                    return document;
                }
                case 4: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addText(text);
                        break;
                    }
                    if (text.trim().length() <= 0) break;
                    throw new DocumentException("Cannot have text content outside of the root document");
                }
            }
        }
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected Reader createReader(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in));
    }

    private Reader createReader(InputStream in, String charSet) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(in, charSet));
    }
}

