/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;

public class MINAStatCollector {
    public static final String KEY = MINAStatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private Queue<IoSession> polledSessions;
    private AtomicLong totalProcessedSessions = new AtomicLong();
    private AtomicLong totalMsgWritten = new AtomicLong();
    private AtomicLong totalMsgRead = new AtomicLong();
    private AtomicLong totalBytesWritten = new AtomicLong();
    private AtomicLong totalBytesRead = new AtomicLong();
    private AtomicLong totalScheduledWrites = new AtomicLong();
    private AtomicLong totalQueuedEvents = new AtomicLong();
    private final IoServiceListener serviceListener = new IoServiceListener(){

        public void sessionCreated(IoSession session) {
            MINAStatCollector.this.addSession(session);
        }

        public void sessionDestroyed(IoSession session) {
            MINAStatCollector.this.removeSession(session);
        }

        public void serviceActivated(IoService service) throws Exception {
        }

        public void serviceIdle(IoService service, IdleStatus idleStatus) throws Exception {
        }

        public void serviceDeactivated(IoService service) throws Exception {
        }
    };

    public MINAStatCollector(IoService service) {
        this(service, 5000);
    }

    public MINAStatCollector(IoService service, int pollingInterval) {
        this.service = service;
        this.pollingInterval = pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MINAStatCollector mINAStatCollector = this;
        synchronized (mINAStatCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ConcurrentLinkedQueue<IoSession>();
            Map sessions = this.service.getManagedSessions();
            if (sessions != null) {
                for (IoSession ioSession : sessions.values()) {
                    this.addSession(ioSession);
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MINAStatCollector mINAStatCollector = this;
        synchronized (mINAStatCollector) {
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            for (IoSession session : this.polledSessions) {
                session.removeAttribute((Object)KEY);
            }
            this.polledSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        MINAStatCollector mINAStatCollector = this;
        synchronized (mINAStatCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    private void addSession(IoSession session) {
        IoSessionStat sessionStats = new IoSessionStat();
        sessionStats.lastPollingTime = System.currentTimeMillis();
        session.setAttribute((Object)KEY, (Object)sessionStats);
        this.totalProcessedSessions.incrementAndGet();
        this.polledSessions.add(session);
    }

    private void removeSession(IoSession session) {
        this.polledSessions.remove(session);
        IoSessionStat sessStat = (IoSessionStat)session.removeAttribute((Object)KEY);
        if (sessStat != null) {
            this.totalMsgWritten.addAndGet(session.getWrittenMessages() - sessStat.lastMessageWrite);
            this.totalMsgRead.addAndGet(session.getReadMessages() - sessStat.lastMessageRead);
            this.totalBytesWritten.addAndGet(session.getWrittenBytes() - sessStat.lastByteWrite);
            this.totalBytesRead.addAndGet(session.getReadBytes() - sessStat.lastByteRead);
        }
    }

    public long getTotalProcessedSessions() {
        return this.totalProcessedSessions.longValue();
    }

    public long getBytesRead() {
        return this.totalBytesRead.get();
    }

    public long getBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getMsgRead() {
        return this.totalMsgRead.get();
    }

    public long getMsgWritten() {
        return this.totalMsgWritten.get();
    }

    public long getScheduledWrites() {
        return this.totalScheduledWrites.get();
    }

    public long getQueuedEvents() {
        return this.totalQueuedEvents.get();
    }

    public long getSessionCount() {
        return this.polledSessions.size();
    }

    public class IoSessionStat {
        long lastByteRead = -1L;
        long lastByteWrite = -1L;
        long lastMessageRead = -1L;
        long lastMessageWrite = -1L;
        float byteWrittenThroughput = 0.0f;
        float byteReadThroughput = 0.0f;
        float messageWrittenThroughput = 0.0f;
        float messageReadThroughput = 0.0f;
        long lastPollingTime = System.currentTimeMillis();

        public float getByteReadThroughput() {
            return this.byteReadThroughput;
        }

        public float getByteWrittenThroughput() {
            return this.byteWrittenThroughput;
        }

        public float getMessageReadThroughput() {
            return this.messageReadThroughput;
        }

        public float getMessageWrittenThroughput() {
            return this.messageWrittenThroughput;
        }

        long getLastByteRead() {
            return this.lastByteRead;
        }

        long getLastByteWrite() {
            return this.lastByteWrite;
        }

        long getLastMessageRead() {
            return this.lastMessageRead;
        }

        long getLastMessageWrite() {
            return this.lastMessageWrite;
        }
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + MINAStatCollector.this.id);
            this.stop = false;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(MINAStatCollector.this.pollingInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long tmpMsgWritten = 0L;
                long tmpMsgRead = 0L;
                long tmpBytesWritten = 0L;
                long tmpBytesRead = 0L;
                long tmpScheduledWrites = 0L;
                long tmpQueuevedEvents = 0L;
                for (IoSession session : MINAStatCollector.this.polledSessions) {
                    Executor executor;
                    IoSessionStat sessStat = (IoSessionStat)session.getAttribute((Object)KEY);
                    long currentTimestamp = System.currentTimeMillis();
                    float pollDelta = (float)(currentTimestamp - sessStat.lastPollingTime) / 1000.0f;
                    sessStat.lastPollingTime = currentTimestamp;
                    long readBytes = session.getReadBytes();
                    long writtenBytes = session.getWrittenBytes();
                    long readMessages = session.getReadMessages();
                    long writtenMessages = session.getWrittenMessages();
                    sessStat.byteReadThroughput = (float)(readBytes - sessStat.lastByteRead) / pollDelta;
                    sessStat.byteWrittenThroughput = (float)(writtenBytes - sessStat.lastByteWrite) / pollDelta;
                    sessStat.messageReadThroughput = (float)(readMessages - sessStat.lastMessageRead) / pollDelta;
                    sessStat.messageWrittenThroughput = (float)(writtenMessages - sessStat.lastMessageWrite) / pollDelta;
                    tmpMsgWritten += writtenMessages - sessStat.lastMessageWrite;
                    tmpMsgRead += readMessages - sessStat.lastMessageRead;
                    tmpBytesWritten += writtenBytes - sessStat.lastByteWrite;
                    tmpBytesRead += readBytes - sessStat.lastByteRead;
                    tmpScheduledWrites += (long)session.getScheduledWriteMessages();
                    ExecutorFilter executorFilter = (ExecutorFilter)session.getFilterChain().get("threadModel");
                    if (executorFilter != null && (executor = executorFilter.getExecutor()) instanceof OrderedThreadPoolExecutor) {
                        tmpQueuevedEvents += (long)((OrderedThreadPoolExecutor)executor).getActiveCount();
                    }
                    sessStat.lastByteRead = readBytes;
                    sessStat.lastByteWrite = writtenBytes;
                    sessStat.lastMessageRead = readMessages;
                    sessStat.lastMessageWrite = writtenMessages;
                }
                MINAStatCollector.this.totalMsgWritten.addAndGet(tmpMsgWritten);
                MINAStatCollector.this.totalMsgRead.addAndGet(tmpMsgRead);
                MINAStatCollector.this.totalBytesWritten.addAndGet(tmpBytesWritten);
                MINAStatCollector.this.totalBytesRead.addAndGet(tmpBytesRead);
                MINAStatCollector.this.totalScheduledWrites.set(tmpScheduledWrites);
                MINAStatCollector.this.totalQueuedEvents.set(tmpQueuevedEvents);
            }
        }
    }
}

