/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.InputFileProgressEvent;
import com.icesoft.faces.component.inputfile.InputFileSetFileEvent;
import com.icesoft.faces.component.inputfile.UploadConfig;
import com.icesoft.faces.component.inputfile.UploadStateHolder;
import com.icesoft.faces.component.style.OutputStyle;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.env.CommonEnvironmentRequest;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.DOMUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InputFile
extends UICommand
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)InputFile.class);
    public static final int DEFAULT = 0;
    public static final int UPLOADING = 1;
    public static final int SAVED = 2;
    public static final int INVALID = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int UNKNOWN_SIZE = 5;
    public static final int INVALID_NAME_PATTERN = 6;
    public static final int UNSPECIFIED_NAME = 7;
    public static final int INVALID_CONTENT_TYPE = 8;
    public static final String INVALID_FILE_MESSAGE_ID = "com.icesoft.faces.component.inputfile.INVALID_FILE";
    public static final String SIZE_LIMIT_EXCEEDED_MESSAGE_ID = "com.icesoft.faces.component.inputfile.SIZE_LIMIT_EXCEEDED";
    public static final String UNKNOWN_SIZE_MESSAGE_ID = "com.icesoft.faces.component.inputfile.UNKNOWN_SIZE";
    public static final String INVALID_NAME_PATTERN_MESSAGE_ID = "com.icesoft.faces.component.inputfile.INVALID_NAME_PATTERN";
    public static final String UNSPECIFIED_NAME_MESSAGE_ID = "com.icesoft.faces.component.inputfile.UNSPECIFIED_NAME";
    public static final String INVALID_CONTENT_TYPE_MESSAGE_ID = "com.icesoft.faces.component.inputfile.INVALID_CONTENT_TYPE";
    public static final String FILE_UPLOAD_PREFIX = "fileUpload";
    public static final String SUBMIT_NONE = "none";
    public static final String SUBMIT_PRE_UPLOAD = "preUpload";
    public static final String SUBMIT_POST_UPLOAD = "postUpload";
    public static final String SUBMIT_PRE_POST_UPLOAD = "preAndPostUpload";
    private Boolean disabled;
    private String style;
    private String styleClass;
    private String label;
    private String enabledOnUserRole;
    private String renderedOnUserRole;
    private String title;
    private int height = 30;
    private int width = 500;
    private int inputTextSize = 35;
    private String inputTextClass;
    private String fileNamePattern;
    private boolean uniqueFolder = true;
    private boolean uniqueFolderSet = false;
    private String uploadDirectory;
    private Boolean uploadDirectoryAbsolute;
    private FileInfo fileInfo = new FileInfo();
    private long sizeMax;
    private MethodBinding progressListener;
    private Boolean progressRender;
    private String submitOnUpload;
    private Boolean failOnEmptyFile;
    private String size = null;
    private String buttonClass = null;
    private String onfocus;
    private String onchange;
    private String accept;
    private String accesskey;
    private String onblur;
    private String tabindex;

    public String getComponentType() {
        return "com.icesoft.faces.File";
    }

    public String getRendererType() {
        return "com.icesoft.faces.Upload";
    }

    public String getFamily() {
        return "com.icesoft.faces.File";
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof InputFileProgressEvent) {
            if (this.progressListener != null) {
                this.progressListener.invoke(FacesContext.getCurrentInstance(), new Object[]{event});
            }
            this.setPreUpload(false);
            this.setPostUpload(false);
        } else if (event instanceof InputFileSetFileEvent) {
            this.updateFileValueBinding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadConfig storeContentAndConfig(BridgeFacesContext facesContext, String clientId, String iframeContent) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        UploadStateHolder uploadState = (UploadStateHolder)parameterMap.get(clientId);
        if (uploadState != null && uploadState.getFileInfo().isFinished()) {
            uploadState.setIframeContent(iframeContent);
        }
        UploadConfig uploadConfig = this.getComponentUploadConfig();
        Object sessionObj = facesContext.getExternalContext().getSession(false);
        if (sessionObj != null) {
            Object object = sessionObj;
            synchronized (object) {
                Map map = facesContext.getExternalContext().getSessionMap();
                String key = facesContext.getViewNumber() + " " + clientId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  session map key: " + key));
                }
                map.put(key, uploadConfig);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  uploadConfig: " + uploadConfig));
        }
        return uploadConfig;
    }

    protected void renderIFrame(Writer writer, BridgeFacesContext context) throws IOException {
        String title;
        writer.write("<html style=\"overflow:hidden;\">");
        ArrayList outputStyleComponents = InputFile.findOutputStyleComponents((UIComponent)context.getViewRoot());
        if (outputStyleComponents != null) {
            writer.write("<head>");
            for (int i = 0; i < outputStyleComponents.size(); ++i) {
                OutputStyle outputStyle = (OutputStyle)((Object)outputStyleComponents.get(i));
                String href = outputStyle.getHref();
                if (href == null || href.length() <= 0) continue;
                href = CoreUtils.resolveResourceURL((FacesContext)context, (String)href);
                writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + href + "\">");
            }
            writer.write("</head>");
        }
        String srv = this.getUploadServletPath(context);
        writer.write("<body style=\"background-color:transparent; overflow:hidden\"><form method=\"post\" action=\"" + srv + "\" enctype=\"multipart/form-data\" id=\"fileUploadForm\">");
        writer.write("<input type=\"hidden\" name=\"ice.component\" value=\"");
        writer.write(this.getClientId((FacesContext)context));
        writer.write("\"/>");
        writer.write("<input type=\"hidden\" name=\"ice.view\"");
        writer.write(" value=\"" + context.getViewNumber() + "\"/>");
        writer.write("<input type=\"file\" name=\"upload\"");
        writer.write(" size=\"" + this.getInputTextSize() + "\"");
        String inputTextClass = this.getInputTextClass();
        if (inputTextClass != null) {
            writer.write(" class=\"" + inputTextClass + "\"");
        }
        if ((title = this.getTitle()) != null) {
            writer.write(" title=\"" + title + "\"");
        }
        writer.write("/>");
        writer.write("<input type=\"submit\" value=\"" + this.getLabel() + "\"");
        String buttonClass = this.getButtonClass();
        if (buttonClass != null) {
            writer.write(" class=\"" + buttonClass + "\"");
        }
        if (this.isDisabled()) {
            writer.write(" disabled=\"disabled\"");
        }
        writer.write("/>");
        ResponseWriter responseWriter = context.getResponseWriter();
        Node node = ((DOMResponseWriter)responseWriter).getSavedNode();
        if (node != null) {
            Node copy = node.cloneNode(true);
            ((Element)copy).setAttribute("id", "fileUploadForm:" + ((Element)copy).getAttribute("id"));
            String divAsString = DOMUtils.nodeToString((Node)copy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("State saving view contents: " + divAsString));
            }
            writer.write(divAsString);
        }
        writer.write("</form>");
        writer.write("</body></html>");
    }

    private String getUploadServletPath(BridgeFacesContext context) {
        ExternalContext externalContext;
        String requestContextPath = null;
        if (context != null && (externalContext = context.getExternalContext()) != null) {
            requestContextPath = externalContext.getRequestContextPath();
        }
        if (requestContextPath == null || requestContextPath.length() == 0) {
            CommonEnvironmentRequest request = (CommonEnvironmentRequest)context.getExternalContext().getRequest();
            return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/uploadHtml";
        }
        return requestContextPath + "/uploadHtml";
    }

    public Throwable getUploadException() {
        return this.fileInfo.getException();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUniqueFolder(boolean uniqueFolder) {
        if (uniqueFolder != this.uniqueFolder) {
            this.uniqueFolder = uniqueFolder;
        }
        this.uniqueFolderSet = true;
    }

    public boolean isUniqueFolder() {
        if (this.uniqueFolderSet) {
            return this.uniqueFolder;
        }
        ValueBinding vb = this.getValueBinding("uniqueFolder");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    protected Boolean getUniqueFolder() {
        if (this.uniqueFolderSet) {
            return this.uniqueFolder;
        }
        ValueBinding vb = this.getValueBinding("uniqueFolder");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        ValueBinding vb = this.getValueBinding("label");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Upload";
    }

    public boolean isDisabled() {
        if (!Util.isEnabledOnUserRole((UIComponent)this)) {
            return true;
        }
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this.enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this.enabledOnUserRole != null) {
            return this.enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory;
    }

    public String getUploadDirectory() {
        if (this.uploadDirectory != null) {
            return this.uploadDirectory;
        }
        ValueBinding vb = this.getValueBinding("uploadDirectory");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setUploadDirectoryAbsolute(Boolean uploadDirectoryAbsolute) {
        this.uploadDirectoryAbsolute = uploadDirectoryAbsolute;
    }

    public Boolean getUploadDirectoryAbsolute() {
        if (this.uploadDirectoryAbsolute != null) {
            return this.uploadDirectoryAbsolute;
        }
        ValueBinding vb = this.getValueBinding("uploadDirectoryAbsolute");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
    }

    public void setProgressRender(Boolean progressRender) {
        this.progressRender = progressRender;
    }

    public Boolean getProgressRender() {
        if (this.progressRender != null) {
            return this.progressRender;
        }
        ValueBinding vb = this.getValueBinding("progressRender");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean renderOnProgress() {
        Boolean progRend = this.getProgressRender();
        return progRend != null ? progRend : true;
    }

    public void setSubmitOnUpload(String submitOnUpload) {
        this.submitOnUpload = submitOnUpload;
    }

    public String getSubmitOnUpload() {
        if (this.submitOnUpload != null) {
            return this.submitOnUpload;
        }
        ValueBinding vb = this.getValueBinding("submitOnUpload");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getValidatedSubmitOnUpload() {
        String sol = this.getSubmitOnUpload();
        if (sol == null || sol.length() == 0) {
            sol = SUBMIT_NONE;
        } else if (!(sol.equals(SUBMIT_NONE) || sol.equals(SUBMIT_PRE_UPLOAD) || sol.equals(SUBMIT_POST_UPLOAD) || sol.equals(SUBMIT_PRE_POST_UPLOAD))) {
            throw new FacesException((Throwable)new IllegalArgumentException("Invalid value for ice:inputFile's submitOnUpload property: " + sol));
        }
        return sol;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "border-collapse:collapse; border-spacing:0px; padding:0px;";
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceInpFile", "styleClass", this.isDisabled());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[31];
        values[0] = super.saveState(context);
        values[1] = this.disabled;
        values[2] = this.style;
        values[3] = this.styleClass;
        values[4] = this.label;
        values[5] = this.enabledOnUserRole;
        values[6] = this.renderedOnUserRole;
        values[7] = this.title;
        values[8] = new Integer(this.height);
        values[9] = new Integer(this.width);
        values[10] = new Integer(this.inputTextSize);
        values[11] = this.inputTextClass;
        values[12] = this.fileNamePattern;
        values[13] = this.uniqueFolder ? Boolean.TRUE : Boolean.FALSE;
        values[14] = this.uniqueFolderSet ? Boolean.TRUE : Boolean.FALSE;
        values[15] = this.uploadDirectory;
        values[16] = this.uploadDirectoryAbsolute;
        if (log.isDebugEnabled()) {
            log.debug((Object)("#### InputFile.saveState()  fileInfo: " + this.fileInfo));
        }
        values[17] = this.fileInfo;
        values[18] = new Long(this.sizeMax);
        values[19] = InputFile.saveAttachedState((FacesContext)context, (Object)this.progressListener);
        values[20] = this.progressRender;
        values[21] = this.submitOnUpload;
        values[22] = this.tabindex;
        values[23] = this.onchange;
        values[24] = this.accesskey;
        values[25] = this.onfocus;
        values[26] = this.accept;
        values[27] = this.onblur;
        values[28] = this.buttonClass;
        values[29] = this.size;
        values[30] = this.failOnEmptyFile;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.disabled = (Boolean)values[1];
        this.style = (String)values[2];
        this.styleClass = (String)values[3];
        this.label = (String)values[4];
        this.enabledOnUserRole = (String)values[5];
        this.renderedOnUserRole = (String)values[6];
        this.title = (String)values[7];
        this.height = (Integer)values[8];
        this.width = (Integer)values[9];
        this.inputTextSize = (Integer)values[10];
        this.inputTextClass = (String)values[11];
        this.fileNamePattern = (String)values[12];
        this.uniqueFolder = (Boolean)values[13];
        this.uniqueFolderSet = (Boolean)values[14];
        this.uploadDirectory = (String)values[15];
        this.uploadDirectoryAbsolute = (Boolean)values[16];
        this.fileInfo = (FileInfo)values[17];
        if (log.isDebugEnabled()) {
            log.debug((Object)("#### InputFile.restoreState()  fileInfo: " + this.fileInfo));
        }
        this.sizeMax = (Long)values[18];
        this.progressListener = (MethodBinding)InputFile.restoreAttachedState((FacesContext)context, (Object)values[19]);
        this.progressRender = (Boolean)values[20];
        this.submitOnUpload = (String)values[21];
        this.tabindex = (String)values[22];
        this.onchange = (String)values[23];
        this.accesskey = (String)values[24];
        this.onfocus = (String)values[25];
        this.accept = (String)values[26];
        this.onblur = (String)values[27];
        this.buttonClass = (String)values[28];
        this.size = (String)values[29];
        this.failOnEmptyFile = (Boolean)values[30];
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueBinding vb = this.getValueBinding("title");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueBinding vb = this.getValueBinding("size");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public int getHeight() {
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.height;
            }
            return value;
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.width;
            }
            return value;
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getInputTextSize() {
        ValueBinding vb = this.getValueBinding("inputTextSize");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.inputTextSize;
            }
            return value;
        }
        return this.inputTextSize;
    }

    public void setInputTextSize(int inputTextSize) {
        this.inputTextSize = inputTextSize;
    }

    public String getFileNamePattern() {
        if (this.fileNamePattern != null) {
            return this.fileNamePattern;
        }
        ValueBinding vb = this.getValueBinding("fileNamePattern");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : ".+";
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setInputTextClass(String inputTextClass) {
        this.inputTextClass = inputTextClass;
    }

    public String getInputTextClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.inputTextClass, "Txt", "inputTextClass", this.isDisabled());
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getButtonClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.buttonClass, "Btn", "buttonClass", this.isDisabled());
    }

    boolean isRegister() {
        return false;
    }

    public void setRegister(FacesContext facesContext) {
    }

    public FileInfo getFileInfo() {
        return (FileInfo)this.fileInfo.clone();
    }

    public void setFileInfo(FileInfo fileInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("#### InputFile.setFileInfo()  fileInfo: " + fileInfo));
        }
        this.fileInfo = fileInfo;
    }

    public UploadConfig getComponentUploadConfig() {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = this.getClientId(context);
        UIComponent form = DomBasicRenderer.findForm((UIComponent)this);
        String formClientId = form != null ? form.getClientId(context) : null;
        Long sizeMax = null;
        String fileNamePattern = this.getFileNamePattern();
        Boolean uniqueFolder = this.getUniqueFolder();
        String uploadDirectory = this.getUploadDirectory();
        Boolean uploadDirectoryAbsolute = this.getUploadDirectoryAbsolute();
        boolean progressRender = this.renderOnProgress();
        boolean progressListener = this.getProgressListener() != null;
        boolean failOnEmptyFile = this.isFailOnEmptyFile();
        UploadConfig uploadConfig = new UploadConfig(clientId, formClientId, sizeMax, fileNamePattern, uniqueFolder, uploadDirectory, uploadDirectoryAbsolute, progressRender, progressListener, failOnEmptyFile);
        return uploadConfig;
    }

    public File getFile() {
        return this.fileInfo.getFile();
    }

    public void setFile(File file) {
    }

    protected void updateFileValueBinding() {
        try {
            ValueBinding vb = this.getValueBinding("file");
            if (vb != null) {
                vb.setValue(FacesContext.getCurrentInstance(), (Object)this.getFile());
            }
        }
        catch (Exception e) {
            log.warn((Object)"The InputFile's file attribute has a ValueBinding, whose value could not be set", (Throwable)e);
        }
    }

    public int getStatus() {
        return this.fileInfo.getStatus();
    }

    public String getFilename() {
        return this.fileInfo.getFileName();
    }

    public void setFilename(String filename) {
        this.fileInfo.setFileName(filename);
    }

    public long getFilesize() {
        return this.fileInfo.getSize();
    }

    public void setFilesize(long filesize) {
        this.fileInfo.setSize(filesize);
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public MethodBinding getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(MethodBinding binding) {
        this.progressListener = binding;
    }

    public int getProgress() {
        return this.fileInfo.getPercent();
    }

    public void setProgress(int i) {
        this.fileInfo.setPercent(i);
        if (this.getProgressListener() != null) {
            this.getProgressListener().invoke(FacesContext.getCurrentInstance(), new Object[]{new InputFileProgressEvent((UIComponent)this)});
        }
    }

    void setPreUpload(boolean p) {
        this.fileInfo.setPreUpload(p);
    }

    void setPostUpload(boolean p) {
        this.fileInfo.setPostUpload(p);
    }

    public String getCssFile() {
        return null;
    }

    private String getDisabled() {
        return null;
    }

    private String getStyleClassString() {
        return null;
    }

    private String getStyleString() {
        return null;
    }

    private String getStyleInfo() {
        return null;
    }

    private String getInputTextClassString() {
        return null;
    }

    private String getButtonClassString() {
        return null;
    }

    private String getTitleAsString() {
        return null;
    }

    private static ArrayList findOutputStyleComponents(UIComponent parent) {
        ArrayList returnValue = null;
        if (parent.getChildCount() == 0) {
            return returnValue;
        }
        Iterator children = parent.getChildren().iterator();
        UIComponent childComponent = null;
        while (children.hasNext()) {
            childComponent = (UIComponent)children.next();
            if (childComponent instanceof OutputStyle) {
                if (returnValue == null) {
                    returnValue = new ArrayList();
                }
                returnValue.add(childComponent);
                continue;
            }
            ArrayList outputStyleComponents = InputFile.findOutputStyleComponents(childComponent);
            if (outputStyleComponents == null) continue;
            if (returnValue == null) {
                returnValue = outputStyleComponents;
                continue;
            }
            returnValue.addAll(outputStyleComponents);
        }
        return returnValue;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    public String getOnfocus() {
        if (this.onfocus != null) {
            return this.onfocus;
        }
        ValueBinding vb = this.getValueBinding("onfocus");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        ValueBinding vb = this.getValueBinding("onchange");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        if (this.accept != null) {
            return this.accept;
        }
        ValueBinding vb = this.getValueBinding("accept");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public String getAccesskey() {
        if (this.accesskey != null) {
            return this.accesskey;
        }
        ValueBinding vb = this.getValueBinding("accesskey");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public String getOnblur() {
        if (this.onblur != null) {
            return this.onblur;
        }
        ValueBinding vb = this.getValueBinding("onblur");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public String getTabindex() {
        if (this.tabindex != null) {
            return this.tabindex;
        }
        ValueBinding vb = this.getValueBinding("tabindex");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void reset() {
        String clientId;
        Iterator msgs;
        this.fileInfo = new FileInfo();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (msgs = facesContext.getMessages(clientId = this.getClientId(facesContext))) != null) {
            while (msgs.hasNext()) {
                FacesMessage msg = (FacesMessage)msgs.next();
                msgs.remove();
            }
        }
    }

    public void setFailOnEmptyFile(boolean failOnEmptyFile) {
        this.failOnEmptyFile = new Boolean(failOnEmptyFile);
    }

    public boolean isFailOnEmptyFile() {
        if (this.failOnEmptyFile != null) {
            return this.failOnEmptyFile;
        }
        ValueBinding vb = this.getValueBinding("failOnEmptyFile");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : true;
    }
}

