/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputrichtext;

import com.icesoft.faces.component.inputrichtext.InputRichText;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class InputRichTextRenderer
extends DomBasicInputRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        InputRichText inputRichText = (InputRichText)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            root.setAttribute("id", clientId + "container");
            Element div = domContext.createElement("div");
            root.setAttribute("class", inputRichText.getStyleClass());
            if (inputRichText.getStyle() != null) {
                root.setAttribute("style", inputRichText.getStyle());
            }
            root.appendChild(div);
            if (inputRichText.isToolbarOnly()) {
                div.setAttribute("id", inputRichText.getId());
                div.setAttribute("style", "width:" + inputRichText.getWidth() + "px; height:" + inputRichText.getHeight() + "px;");
                domContext.stepOver();
                return;
            }
            div.setAttribute("id", clientId + "editor");
            StringBuffer call = new StringBuffer();
            call.append("Ice.FCKeditor.register ('" + clientId + "', new Ice.FCKeditor('" + clientId + "', '" + inputRichText.getLanguage() + "', '" + inputRichText.getFor() + "', '" + inputRichText.getBaseURI().getPath() + "','" + inputRichText.getWidth() + "', '" + inputRichText.getHeight() + "', '" + inputRichText.getToolbar() + "', '" + inputRichText.getCustomConfigPath() + "', '" + inputRichText.getSkin() + "'));");
            String value = inputRichText.getEditorValue();
            if (value == null && inputRichText.getValue() != null) {
                value = inputRichText.getValue().toString();
            }
            this.addHiddenField(domContext, root, clientId + "valueHolder", value);
            this.addHiddenField(domContext, root, clientId + "Disabled", String.valueOf(inputRichText.isDisabled()));
            Element script = domContext.createElement("script");
            script.setAttribute("type", "text/javascript");
            script.appendChild(domContext.createTextNode(call.toString()));
            root.appendChild(script);
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.FCKeditorUtility.updateValue ('" + clientId + "');"));
            domContext.stepOver();
        }
    }

    private void addHiddenField(DOMContext domContext, Element root, String fieldName, String value) {
        Element hiddenFld = domContext.createElement("input");
        hiddenFld.setAttribute("type", "hidden");
        hiddenFld.setAttribute("id", fieldName);
        hiddenFld.setAttribute("name", fieldName);
        if (value != null) {
            hiddenFld.setAttribute("value", value);
        }
        root.appendChild(hiddenFld);
    }
}

