/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.menubar;

import com.icesoft.faces.component.CSS_DEFAULT;
import com.icesoft.faces.component.InvalidComponentTypeException;
import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.HtmlGraphicImage;
import com.icesoft.faces.component.ext.HtmlOutputText;
import com.icesoft.faces.component.ext.HtmlPanelGroup;
import com.icesoft.faces.component.menubar.MenuBar;
import com.icesoft.faces.component.menubar.MenuItem;
import com.icesoft.faces.component.menubar.MenuItemBase;
import com.icesoft.faces.component.menubar.MenuItemRendererBase;
import com.icesoft.faces.component.menubar.MenuItemSeparator;
import com.icesoft.faces.component.menubar.MenuItems;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.DOMUtils;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MenuItemRenderer
extends MenuItemRendererBase {
    private static final String HIDDEN_FIELD_NAME = "cl";
    private static String SUB = "_sub";
    private static String KEYWORD_NULL = "null";
    private static String KEYWORD_THIS = "this";
    private final String DEFAULT_IMAGEDIR = "/xmlhttp/css/xp/css-images/";
    private static final String SUBMENU_IMAGE = "submenu.gif";
    private static String LINK_SUFFIX = "link";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String hiddenFieldName;
        this.validateParameters(facesContext, uiComponent, null);
        if (MenuItemRenderer.isStatic((UIComponent)uiComponent)) {
            return;
        }
        String componentId = uiComponent.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String hiddenFieldNameInRequestMap = (String)requestParameterMap.get(hiddenFieldName = MenuItemRenderer.deriveCommonHiddenFieldName(facesContext, (UIComponent)((MenuItem)uiComponent)));
        if (hiddenFieldNameInRequestMap == null || hiddenFieldNameInRequestMap.equals("")) {
            return;
        }
        String commandLinkClientId = componentId + ":" + LINK_SUFFIX;
        if (hiddenFieldNameInRequestMap.equals(commandLinkClientId)) {
            ActionEvent actionEvent = new ActionEvent(uiComponent);
            uiComponent.queueEvent((FacesEvent)actionEvent);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element topLevelDiv;
        if (!(uiComponent.getParent() instanceof MenuBar) && !(uiComponent.getParent() instanceof MenuItems)) {
            throw new InvalidComponentTypeException("MenuBar expected as parent of top-level MenuItem");
        }
        MenuBar menuComponent = null;
        if (uiComponent.getParent() instanceof MenuBar) {
            menuComponent = (MenuBar)uiComponent.getParent();
        } else if (uiComponent.getParent().getParent() instanceof MenuBar) {
            menuComponent = (MenuBar)uiComponent.getParent().getParent();
        } else {
            throw new InvalidComponentTypeException("Expecting MenuBar");
        }
        boolean vertical = menuComponent.getOrientation().equalsIgnoreCase("vertical");
        this.validateParameters(facesContext, uiComponent, MenuItemBase.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            topLevelDiv = domContext.createRootElement("div");
            topLevelDiv.setAttribute("id", clientId);
        }
        topLevelDiv = (Element)domContext.getRootNode();
        topLevelDiv.setAttribute("name", "TOP_LEVEL");
        String rootItemSubClass = CSS_DEFAULT.MENU_BAR_ITEM_STYLE;
        if (vertical) {
            rootItemSubClass = CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE + rootItemSubClass;
        }
        topLevelDiv.setAttribute("class", ((MenuItem)uiComponent).getUserDefinedStyleClass(menuComponent.getItemStyleClass(), rootItemSubClass));
        if (uiComponent.getChildCount() > 0) {
            String displayEvent = "onmouseover";
            if (vertical) {
                topLevelDiv.setAttribute(displayEvent, "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand("this", clientId + "_sub", KEYWORD_THIS));
            } else {
                topLevelDiv.setAttribute(displayEvent, "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand("this", clientId + "_sub", KEYWORD_NULL));
            }
        } else {
            topLevelDiv.setAttribute("onmouseover", "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);");
        }
        DOMContext.removeChildren((Node)topLevelDiv);
        Element masterDiv = (Element)topLevelDiv.getParentNode();
        this.renderAnchor(facesContext, domContext, 0, (MenuItem)uiComponent, topLevelDiv, menuComponent, vertical);
        if (uiComponent.getChildCount() > 0 && ((MenuItem)uiComponent).isChildrenMenuItem()) {
            this.renderChildrenRecursive(facesContext, menuComponent, uiComponent, vertical, masterDiv);
        }
    }

    private String expand(String supermenu, String submenu, String submenuDiv) {
        if (!supermenu.equalsIgnoreCase(KEYWORD_NULL) && !supermenu.equalsIgnoreCase(KEYWORD_THIS)) {
            supermenu = "$('" + supermenu + "')";
        }
        if (!submenu.equalsIgnoreCase(KEYWORD_NULL) && !submenu.equalsIgnoreCase(KEYWORD_THIS)) {
            submenu = "$('" + submenu + "')";
        }
        if (!submenuDiv.equalsIgnoreCase(KEYWORD_NULL) && !submenuDiv.equalsIgnoreCase(KEYWORD_THIS)) {
            submenuDiv = "$('" + submenuDiv + "')";
        }
        return "Ice.Menu.show(" + supermenu + "," + submenu + "," + submenuDiv + ");";
    }

    protected static String deriveCommonHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        if (Beans.isDesignTime()) {
            return "";
        }
        UIComponent parentNamingContainer = MenuItemRenderer.findForm((UIComponent)uiComponent);
        String parentClientId = parentNamingContainer.getClientId(facesContext);
        String hiddenFieldName = parentClientId + ':' + "_id" + HIDDEN_FIELD_NAME;
        return hiddenFieldName;
    }

    private Element makeTopLevelAnchor(FacesContext facesContext, MenuItem menuItem, MenuBar menuBar) {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)menuItem);
        Element anchor = domContext.createElement("a");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("href", menuItem.getLink());
            if (menuItem.getTarget() != null) {
                anchor.setAttribute("target", menuItem.getTarget());
            }
        }
        Element div = domContext.createElement("div");
        anchor.appendChild(div);
        if (!menuBar.getNoIcons().equalsIgnoreCase("true") && this.getIcon((UIComponent)menuItem) != null && !this.getIcon((UIComponent)menuItem).endsWith("/xmlhttp/css/xp/css-images/menu_blank_icon.gif")) {
            Element iconImg = domContext.createElement("img");
            iconImg.setAttribute("src", this.getIcon((UIComponent)menuItem));
            iconImg.setAttribute("style", "border:none;");
            iconImg.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemImageStyleClass(), CSS_DEFAULT.MENU_BAR_ITEM_STYLE + CSS_DEFAULT.MENU_ITEM_IMAGE_STYLE));
            div.appendChild(iconImg);
        }
        Element span = domContext.createElement("span");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("styleClass", "iceLink");
        } else {
            anchor.setAttribute("styleClass", "iceLink-dis");
        }
        span.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemLabelStyleClass(), CSS_DEFAULT.MENU_BAR_ITEM_LABEL_STYLE));
        div.appendChild(span);
        Text text = domContext.createTextNode(DOMUtils.escapeAnsi((String)menuItem.getValue().toString()));
        span.appendChild(text);
        return anchor;
    }

    private Element makeTopLevelVerticalAnchor(FacesContext facesContext, MenuItem menuItem, MenuBar menuBar) {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)menuItem);
        Element anchor = domContext.createElement("a");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("href", menuItem.getLink());
            if (menuItem.getTarget() != null) {
                anchor.setAttribute("target", menuItem.getTarget());
            }
        }
        Element div = domContext.createElement("div");
        anchor.appendChild(div);
        if (menuItem.getChildCount() > 0) {
            Element subImg = domContext.createElement("img");
            subImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)this.getSubMenuImage(menuBar)));
            subImg.setAttribute("style", "border:none;");
            subImg.setAttribute("class", menuBar.getSubMenuIndicatorStyleClass());
            div.appendChild(subImg);
        }
        if (!menuBar.getNoIcons().equalsIgnoreCase("true") && this.getIcon((UIComponent)menuItem) != null) {
            Element iconImg = domContext.createElement("img");
            iconImg.setAttribute("src", this.getIcon((UIComponent)menuItem));
            iconImg.setAttribute("style", "border:none;");
            iconImg.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemImageStyleClass(), CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE + CSS_DEFAULT.MENU_BAR_ITEM_STYLE + CSS_DEFAULT.MENU_ITEM_IMAGE_STYLE));
            div.appendChild(iconImg);
        }
        Element span = domContext.createElement("span");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("styleClass", "iceLink");
        } else {
            anchor.setAttribute("styleClass", "iceLink-dis");
        }
        span.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemLabelStyleClass(), CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE + CSS_DEFAULT.MENU_BAR_ITEM_LABEL_STYLE));
        div.appendChild(span);
        Text text = domContext.createTextNode(DOMUtils.escapeAnsi((String)menuItem.getValue().toString()));
        span.appendChild(text);
        return anchor;
    }

    private Element makeAnchor(FacesContext facesContext, DOMContext domContext, MenuItem menuItem, MenuBar menuBar) {
        Element anchor = domContext.createElement("a");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("href", menuItem.getLink());
            if (menuItem.getTarget() != null) {
                anchor.setAttribute("target", menuItem.getTarget());
            }
        }
        Element div = domContext.createElement("div");
        anchor.appendChild(div);
        if (menuItem.getChildCount() > 0) {
            Element subImg = domContext.createElement("img");
            subImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)this.getSubMenuImage(menuBar)));
            subImg.setAttribute("style", "border:none;");
            subImg.setAttribute("class", menuBar.getSubMenuIndicatorStyleClass());
            div.appendChild(subImg);
        }
        if (!menuBar.getNoIcons().equalsIgnoreCase("true") && this.getIcon((UIComponent)menuItem) != null) {
            Element iconImg = domContext.createElement("img");
            iconImg.setAttribute("src", this.getIcon((UIComponent)menuItem));
            iconImg.setAttribute("style", "border:none;");
            iconImg.setAttribute("class", menuItem.getImageStyleClass());
            div.appendChild(iconImg);
        }
        Element span = domContext.createElement("span");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("styleClass", "iceLink");
        } else {
            anchor.setAttribute("styleClass", "iceLink-dis");
        }
        span.setAttribute("class", menuItem.getLabelStyleClass());
        div.appendChild(span);
        Text text = domContext.createTextNode(DOMUtils.escapeAnsi((String)menuItem.getValue().toString()));
        span.appendChild(text);
        return anchor;
    }

    private void renderChildrenRecursive(FacesContext facesContext, MenuBar menuComponent, UIComponent uiComponent, boolean vertical, Element masterDiv) {
        UIComponent nextSubMenuItem;
        int childIndex;
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element submenuDiv = domContext.createElement("div");
        submenuDiv.setAttribute("name", "SUBMENU");
        String subMenuDivId = uiComponent.getClientId(facesContext) + SUB;
        submenuDiv.setAttribute("id", subMenuDivId);
        submenuDiv.setAttribute("class", menuComponent.getSubMenuStyleClass());
        submenuDiv.setAttribute("style", "display:none");
        masterDiv.appendChild(submenuDiv);
        boolean disabled = ((MenuItem)uiComponent).isDisabled();
        for (childIndex = 0; childIndex < uiComponent.getChildCount(); ++childIndex) {
            nextSubMenuItem = (UIComponent)uiComponent.getChildren().get(childIndex);
            if (nextSubMenuItem instanceof UIParameter) continue;
            Element subMenuItemDiv = domContext.createElement("div");
            submenuDiv.appendChild(subMenuItemDiv);
            if (nextSubMenuItem instanceof MenuItemSeparator) {
                this.renderSeparatorDiv(domContext, subMenuItemDiv, (MenuItemSeparator)nextSubMenuItem);
                continue;
            }
            subMenuItemDiv.setAttribute("class", ((MenuItem)nextSubMenuItem).getStyleClass());
            subMenuItemDiv.setAttribute("name", "ITEM");
            String subMenuItemClientId = nextSubMenuItem.getClientId(facesContext);
            subMenuItemDiv.setAttribute("id", subMenuItemClientId);
            if (nextSubMenuItem.getChildCount() > 0 && ((MenuItem)nextSubMenuItem).isChildrenMenuItem()) {
                subMenuItemDiv.setAttribute("onmouseover", "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand(subMenuDivId, subMenuItemClientId + SUB, KEYWORD_THIS));
            } else {
                subMenuItemDiv.setAttribute("onmouseover", "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);");
            }
            subMenuItemDiv.setAttribute("id", nextSubMenuItem.getClientId(facesContext));
            if (disabled) {
                ((MenuItem)nextSubMenuItem).setDisabled(disabled);
            }
            if (!(nextSubMenuItem instanceof MenuItem)) continue;
            this.renderAnchor(facesContext, domContext, childIndex, (MenuItem)nextSubMenuItem, subMenuItemDiv, menuComponent, vertical);
        }
        for (childIndex = 0; childIndex < uiComponent.getChildCount(); ++childIndex) {
            nextSubMenuItem = (UIComponent)uiComponent.getChildren().get(childIndex);
            if (nextSubMenuItem.getChildCount() <= 0) continue;
            this.renderChildrenRecursive(facesContext, menuComponent, nextSubMenuItem, vertical, masterDiv);
        }
    }

    private void renderAnchor(FacesContext facesContext, DOMContext domContext, int childIndex, MenuItem nextSubMenuItem, Element subMenuItemDiv, MenuBar menuComponent, boolean vertical) {
        if (!nextSubMenuItem.isRendered()) {
            return;
        }
        if (nextSubMenuItem.getParent() instanceof MenuBar || nextSubMenuItem.getParent() instanceof MenuItems && nextSubMenuItem.getParent().getParent() instanceof MenuBar) {
            if (nextSubMenuItem.hasActionOrActionListener()) {
                HtmlCommandLink link = new HtmlCommandLink();
                if (nextSubMenuItem.isDisabled()) {
                    link.setDisabled(true);
                } else {
                    ActionListener[] actionListeners;
                    MethodBinding actionListener;
                    MethodBinding action = nextSubMenuItem.getAction();
                    if (action != null) {
                        link.setAction(action);
                    }
                    if ((actionListener = nextSubMenuItem.getActionListener()) != null) {
                        link.setActionListener(actionListener);
                    }
                    if ((actionListeners = nextSubMenuItem.getActionListeners()) != null) {
                        for (int i = 0; i < actionListeners.length; ++i) {
                            link.removeActionListener(actionListeners[i]);
                            link.addActionListener(actionListeners[i]);
                        }
                    }
                }
                link.setValue(nextSubMenuItem.getValue());
                link.setParent((UIComponent)nextSubMenuItem);
                link.setId(LINK_SUFFIX);
                Node lastCursorParent = domContext.getCursorParent();
                domContext.setCursorParent((Node)subMenuItemDiv);
                if (vertical) {
                    this.addChildren(link, nextSubMenuItem, menuComponent);
                } else {
                    this.addTopLevelChildren(link, nextSubMenuItem, menuComponent);
                }
                nextSubMenuItem.addParameter((UIComponent)link);
                try {
                    link.encodeBegin(facesContext);
                    link.encodeChildren(facesContext);
                    link.encodeEnd(facesContext);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                domContext.setCursorParent(lastCursorParent);
            } else {
                Element anchor = null;
                anchor = vertical ? this.makeTopLevelVerticalAnchor(facesContext, nextSubMenuItem, menuComponent) : this.makeTopLevelAnchor(facesContext, nextSubMenuItem, menuComponent);
                subMenuItemDiv.appendChild(anchor);
            }
        } else if (nextSubMenuItem.hasActionOrActionListener()) {
            HtmlCommandLink link = new HtmlCommandLink();
            if (nextSubMenuItem.isDisabled()) {
                link.setDisabled(true);
            } else {
                ActionListener[] actionListeners;
                MethodBinding actionListener;
                MethodBinding action = nextSubMenuItem.getAction();
                if (action != null) {
                    link.setAction(action);
                }
                if ((actionListener = nextSubMenuItem.getActionListener()) != null) {
                    link.setActionListener(actionListener);
                }
                if ((actionListeners = nextSubMenuItem.getActionListeners()) != null) {
                    for (int i = 0; i < actionListeners.length; ++i) {
                        link.removeActionListener(actionListeners[i]);
                        link.addActionListener(actionListeners[i]);
                    }
                }
            }
            link.setValue(nextSubMenuItem.getValue());
            link.setParent((UIComponent)nextSubMenuItem);
            link.setId(LINK_SUFFIX);
            Node lastCursorParent = domContext.getCursorParent();
            domContext.setCursorParent((Node)subMenuItemDiv);
            this.addChildren(link, nextSubMenuItem, menuComponent);
            nextSubMenuItem.addParameter((UIComponent)link);
            try {
                link.encodeBegin(facesContext);
                link.encodeChildren(facesContext);
                link.encodeEnd(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            domContext.setCursorParent(lastCursorParent);
        } else {
            Element anchor = this.makeAnchor(facesContext, domContext, nextSubMenuItem, menuComponent);
            subMenuItemDiv.appendChild(anchor);
        }
    }

    private void addTopLevelChildren(HtmlCommandLink link, MenuItem nextSubMenuItem, MenuBar menuComponent) {
        HtmlPanelGroup div = new HtmlPanelGroup();
        if (!menuComponent.getNoIcons().equalsIgnoreCase("true") && this.getIcon((UIComponent)nextSubMenuItem) != null) {
            HtmlGraphicImage image = new HtmlGraphicImage();
            image.setUrl(this.getIcon((UIComponent)nextSubMenuItem));
            image.setStyle("border:none;");
            image.setStyleClass(nextSubMenuItem.getImageStyleClass());
            div.getChildren().add(image);
        }
        HtmlOutputText outputText = new HtmlOutputText();
        outputText.setValue(link.getValue());
        outputText.setStyleClass(nextSubMenuItem.getLabelStyleClass());
        link.setValue("");
        div.getChildren().add(outputText);
        link.getChildren().add(div);
    }

    void addChildren(HtmlCommandLink link, MenuItem nextSubMenuItem, MenuBar menuComponent) {
        HtmlGraphicImage image;
        HtmlPanelGroup div = new HtmlPanelGroup();
        if (nextSubMenuItem.getChildCount() > 0 && nextSubMenuItem.isChildrenMenuItem()) {
            image = new HtmlGraphicImage();
            image.setUrl(this.getSubMenuImage(menuComponent));
            image.setStyle("border:none;");
            image.setStyleClass(menuComponent.getSubMenuIndicatorStyleClass());
            div.getChildren().add(image);
        }
        if (!menuComponent.getNoIcons().equalsIgnoreCase("true") && this.getIcon((UIComponent)nextSubMenuItem) != null) {
            image = new HtmlGraphicImage();
            image.setUrl(this.getIcon((UIComponent)nextSubMenuItem));
            image.setStyle("border:none;");
            image.setStyleClass(nextSubMenuItem.getImageStyleClass());
            div.getChildren().add(image);
        }
        HtmlOutputText outputText = new HtmlOutputText();
        outputText.setValue(link.getValue());
        outputText.setStyleClass(nextSubMenuItem.getLabelStyleClass());
        link.setValue("");
        div.getChildren().add(outputText);
        link.getChildren().add(div);
    }

    private void renderSeparatorDiv(DOMContext domContext, Element parent, MenuItemSeparator menuItemSeparator) {
        Element hr = domContext.createElement("hr");
        parent.setAttribute("class", menuItemSeparator.getStyleClass());
        parent.appendChild(hr);
    }

    private String getSubMenuImage(MenuBar menuComponent) {
        String customPath = null;
        customPath = menuComponent.getImageDir();
        if (customPath != null) {
            return customPath + SUBMENU_IMAGE;
        }
        return "/xmlhttp/css/xp/css-images/submenu.gif";
    }

    protected String getTextValue(UIComponent component) {
        if (component instanceof MenuItem) {
            return ((MenuItem)component).getValue().toString();
        }
        return null;
    }

    protected String getIcon(UIComponent component) {
        if (component instanceof MenuItem) {
            return ((MenuItem)component).getIcon();
        }
        return null;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void examineRequest(FacesContext facesContext, UIComponent uiComponent, Map requestParameterMap, String hiddenFieldName, String hiddenValue) {
        Iterator entries = requestParameterMap.entrySet().iterator();
        System.out.println("decoding " + ((MenuItem)uiComponent).getValue());
        System.out.println("request map");
        while (entries.hasNext()) {
            Map.Entry next = entries.next();
            if (next.getKey().toString().equals("rand")) continue;
            System.out.println("[" + next.getKey().toString() + "=" + next.getValue() + "]");
        }
        System.out.println("looking for hidden field [" + hiddenFieldName + "]");
        System.out.println("client id = [" + uiComponent.getClientId(facesContext));
        System.out.println("################################################ QUEUEING for hidden field [" + hiddenValue + "]");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        super.encodeEnd(facesContext, uiComponent);
        domContext.streamWrite(facesContext, uiComponent);
    }
}

