/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.datapaginator;

import com.icesoft.faces.component.datapaginator.DataPaginatorGroup;
import com.icesoft.faces.component.datapaginator.PaginatorActionEvent;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.util.CoreComponentUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPaginator
extends HtmlPanelGroup
implements ActionSource,
Serializable {
    private final Log log = LogFactory.getLog(DataPaginator.class);
    private static final String FIRST_FACET_NAME = "first";
    private static final String LAST_FACET_NAME = "last";
    private static final String NEXT_FACET_NAME = "next";
    private static final String PREVIOUS_FACET_NAME = "previous";
    private static final String FAST_FORWARD_FACET_NAME = "fastforward";
    private static final String FAST_REWIND_FACET_NAME = "fastrewind";
    private int oldRow = -1;
    private int pageIndex;
    private transient UIData _UIData;
    private Boolean keyboardNavigationEnabled;
    private MethodBinding _actionListener;
    private Boolean disabled = null;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.DataScroller";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.DataScroller";
    private static final boolean DEFAULT_IMMEDIATE = false;
    private static final boolean DEFAULT_VERTICAL = false;
    private String _for = null;
    private Integer _fastStep = null;
    private String _pageIndexVar = null;
    private String _pageCountVar = null;
    private String _rowsCountVar = null;
    private String _displayedRowsCountVar = null;
    private String _firstRowIndexVar = null;
    private String _lastRowIndexVar = null;
    private String _style = null;
    private String _styleClass = null;
    private String _columnClasses = null;
    private Boolean _paginator = null;
    private Integer _paginatorMaxPages = null;
    private Boolean _renderFacetsIfSinglePage = null;
    private Boolean _immediate;
    private Boolean _vertical;
    public static final String FACET_FIRST = "first".intern();
    public static final String FACET_PREVIOUS = "previous".intern();
    public static final String FACET_NEXT = "next".intern();
    public static final String FACET_LAST = "last".intern();
    public static final String FACET_FAST_FORWARD = "fastf".intern();
    public static final String FACET_FAST_REWIND = "fastr".intern();
    private Integer tabindex = null;
    private String enabledOnUserRole = null;
    private String renderedOnUserRole = null;
    private transient Boolean modelResultSet = null;

    public String getComponentType() {
        return "com.icesoft.faces.DataScroller";
    }

    public String getRendererType() {
        return "com.icesoft.faces.DataScroller";
    }

    public void setDisabled(boolean disabled) {
        this.disabled = new Boolean(disabled);
        ValueBinding vb = this.getValueBinding("disabled");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this.disabled);
            this.disabled = null;
        }
    }

    public boolean isDisabled() {
        if (!Util.isEnabledOnUserRole((UIComponent)this)) {
            return true;
        }
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void queueEvent(FacesEvent event) {
        if (event != null && event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof PaginatorActionEvent) {
            PaginatorActionEvent scrollerEvent = (PaginatorActionEvent)event;
            UIData uiData = this.getUIData();
            if (uiData == null) {
                return;
            }
            int pageindex = scrollerEvent.getPageIndex();
            if (pageindex == -1) {
                String facet = scrollerEvent.getScrollerfacet();
                if (FACET_FIRST.equals(facet)) {
                    this.gotoFirstPage();
                } else if (FACET_PREVIOUS.equals(facet)) {
                    this.gotoPreviousPage();
                } else if (FACET_NEXT.equals(facet)) {
                    this.gotoNextPage();
                } else if (FACET_FAST_FORWARD.equals(facet)) {
                    this.gotoFastForward();
                } else if (FACET_FAST_REWIND.equals(facet)) {
                    this.gotoFastRewind();
                } else if (FACET_LAST.equals(facet)) {
                    this.gotoLastPage();
                }
                scrollerEvent.setPageIndex(this.getPageIndex());
            } else {
                int pageCount = this.getPageCount();
                if (pageindex > pageCount) {
                    pageindex = pageCount;
                }
                if (pageindex <= 0) {
                    pageindex = 1;
                }
                uiData.setFirst(uiData.getRows() * (pageindex - 1));
            }
            if (this.isImmediate()) {
                this.getFacesContext().renderResponse();
            }
            this.broadcastToActionListener(scrollerEvent);
        }
    }

    protected void broadcastToActionListener(PaginatorActionEvent event) {
        FacesContext context = this.getFacesContext();
        try {
            MethodBinding actionListenerBinding = this.getActionListener();
            if (actionListenerBinding != null) {
                actionListenerBinding.invoke(context, new Object[]{event});
            }
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }

    public UIData getUIData() {
        if (this._UIData == null) {
            this._UIData = this.findUIData();
        }
        return this._UIData;
    }

    public void setUIData(UIData uiData) {
        this._UIData = uiData;
    }

    public int getPageIndex() {
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        int pageCount = this.getPageCount();
        int first = uiData.getFirst();
        if (this.oldRow != -1 && this.oldRow != rows) {
            first = rows * (this.pageIndex - 1);
        }
        int tempPageIndex = this.pageIndex;
        if (rows > 0) {
            this.pageIndex = first / rows + 1;
            if (this.pageIndex > pageCount) {
                this.pageIndex = pageCount;
            }
        } else {
            this.log.warn((Object)("DataTable " + uiData.getClientId(FacesContext.getCurrentInstance()) + " has invalid rows attribute."));
            this.pageIndex = 0;
        }
        if (tempPageIndex != this.pageIndex) {
            first = rows * this.pageIndex - rows;
        }
        if (this.oldRow != -1 && this.oldRow != rows) {
            uiData.setFirst(first < 0 ? 0 : first);
        }
        this.oldRow = rows;
        if (rows == 0) {
            this.pageIndex = 1;
        } else if (uiData.getFirst() % rows > 0) {
            ++this.pageIndex;
        }
        return this.pageIndex;
    }

    private void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageCount() {
        int pageCount;
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : uiData.getRowCount() / rows;
            if (uiData.getRowCount() % rows > 0) {
                ++pageCount;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getRowCount() {
        return this.getUIData().getRowCount();
    }

    public int getRows() {
        return this.getUIData().getRows();
    }

    public int getFirstRow() {
        return this.getUIData().getFirst();
    }

    protected UIData findUIData() {
        String forStr = this.getFor();
        UIComponent forComp = forStr == null ? this.getParent() : CoreComponentUtils.findComponent(forStr, (UIComponent)this);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find UIData referenced by attribute dataScroller@for = '" + forStr + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute dataScroller@for = '" + forStr + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public void setFirst(UIComponent first) {
        this.getFacets().put(FIRST_FACET_NAME, first);
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public void setLast(UIComponent last) {
        this.getFacets().put(LAST_FACET_NAME, last);
    }

    public UIComponent getLast() {
        return this.getFacet(LAST_FACET_NAME);
    }

    public void setNext(UIComponent next) {
        this.getFacets().put(NEXT_FACET_NAME, next);
    }

    public UIComponent getNext() {
        return this.getFacet(NEXT_FACET_NAME);
    }

    public void setFastForward(UIComponent previous) {
        this.getFacets().put(FAST_FORWARD_FACET_NAME, previous);
    }

    public UIComponent getFastForward() {
        return this.getFacet(FAST_FORWARD_FACET_NAME);
    }

    public void setFastRewind(UIComponent previous) {
        this.getFacets().put(FAST_REWIND_FACET_NAME, previous);
    }

    public UIComponent getFastRewind() {
        return this.getFacet(FAST_REWIND_FACET_NAME);
    }

    public void setPrevious(UIComponent previous) {
        this.getFacets().put(PREVIOUS_FACET_NAME, previous);
    }

    public UIComponent getPrevious() {
        return this.getFacet(PREVIOUS_FACET_NAME);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public MethodBinding getAction() {
        return null;
    }

    public void setAction(MethodBinding action) {
        throw new UnsupportedOperationException("Defining an action is not supported. Use an actionListener");
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
    }

    public MethodBinding getActionListener() {
        return this._actionListener;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public DataPaginator() {
        this.setRendererType("com.icesoft.faces.DataScroller");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setFor(String forValue) {
        this._for = forValue;
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFastStep(int fastStep) {
        this._fastStep = new Integer(fastStep);
    }

    public int getFastStep() {
        if (this._fastStep != null) {
            return this._fastStep;
        }
        ValueBinding vb = this.getValueBinding("fastStep");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Integer.MIN_VALUE;
    }

    public void setPageIndexVar(String pageIndexVar) {
        this._pageIndexVar = pageIndexVar;
    }

    public String getPageIndexVar() {
        if (this._pageIndexVar != null) {
            return this._pageIndexVar;
        }
        ValueBinding vb = this.getValueBinding("pageIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPageCountVar(String pageCountVar) {
        this._pageCountVar = pageCountVar;
    }

    public String getPageCountVar() {
        if (this._pageCountVar != null) {
            return this._pageCountVar;
        }
        ValueBinding vb = this.getValueBinding("pageCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowsCountVar(String rowsCountVar) {
        this._rowsCountVar = rowsCountVar;
    }

    public String getRowsCountVar() {
        if (this._rowsCountVar != null) {
            return this._rowsCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowsCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setDisplayedRowsCountVar(String displayedRowsCountVar) {
        this._displayedRowsCountVar = displayedRowsCountVar;
    }

    public String getDisplayedRowsCountVar() {
        if (this._displayedRowsCountVar != null) {
            return this._displayedRowsCountVar;
        }
        ValueBinding vb = this.getValueBinding("displayedRowsCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFirstRowIndexVar(String firstRowIndexVar) {
        this._firstRowIndexVar = firstRowIndexVar;
    }

    public String getFirstRowIndexVar() {
        if (this._firstRowIndexVar != null) {
            return this._firstRowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("firstRowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setLastRowIndexVar(String lastRowIndexVar) {
        this._lastRowIndexVar = lastRowIndexVar;
    }

    public String getLastRowIndexVar() {
        if (this._lastRowIndexVar != null) {
            return this._lastRowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("lastRowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyle(String style) {
        this._style = style;
    }

    public String getStyle() {
        if (this._style != null) {
            return this._style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this._styleClass, "iceDatPgr", "styleClass", this.isDisabled());
    }

    public String getBaseStyleClass() {
        return "iceDatPgr";
    }

    public void setPaginator(boolean paginator) {
        this._paginator = paginator;
    }

    public boolean isPaginator() {
        if (this._paginator != null) {
            return this._paginator;
        }
        ValueBinding vb = this.getValueBinding("paginator");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setPaginatorMaxPages(int paginatorMaxPages) {
        this._paginatorMaxPages = new Integer(paginatorMaxPages);
    }

    public int getPaginatorMaxPages() {
        if (this._paginatorMaxPages != null) {
            return this._paginatorMaxPages;
        }
        ValueBinding vb = this.getValueBinding("paginatorMaxPages");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Integer.MIN_VALUE;
    }

    public String getPaginatorTableClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Tbl", this.isDisabled());
    }

    public String getPaginatorColumnClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Col", this.isDisabled());
    }

    public String getscrollButtonCellClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "ScrBtn", this.isDisabled());
    }

    public String getPaginatorActiveColumnClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "ScrCol", this.isDisabled());
    }

    public void setRenderFacetsIfSinglePage(boolean renderFacetsIfSinglePage) {
        this._renderFacetsIfSinglePage = renderFacetsIfSinglePage;
    }

    public boolean isRenderFacetsIfSinglePage() {
        if (this._renderFacetsIfSinglePage != null) {
            return this._renderFacetsIfSinglePage;
        }
        ValueBinding vb = this.getValueBinding("renderFacetsIfSinglePage");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
    }

    public boolean isImmediate() {
        if (this._immediate != null) {
            return this._immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setVertical(boolean vertical) {
        this._vertical = vertical;
    }

    public boolean isVertical() {
        if (this._vertical != null) {
            return this._vertical;
        }
        ValueBinding vb = this.getValueBinding("vertical");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._for, this._fastStep, this._pageIndexVar, this._pageCountVar, this._rowsCountVar, this._displayedRowsCountVar, this._firstRowIndexVar, this._lastRowIndexVar, this._style, this._styleClass, this._columnClasses, this._paginator, this._paginatorMaxPages, this._renderFacetsIfSinglePage, this._immediate, DataPaginator.saveAttachedState((FacesContext)context, (Object)this._actionListener), this._vertical, this.renderedOnUserRole, this.enabledOnUserRole, this.disabled, new Integer(this.oldRow), new Integer(this.pageIndex), this.keyboardNavigationEnabled, this.tabindex};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
        this._fastStep = (Integer)values[2];
        this._pageIndexVar = (String)values[3];
        this._pageCountVar = (String)values[4];
        this._rowsCountVar = (String)values[5];
        this._displayedRowsCountVar = (String)values[6];
        this._firstRowIndexVar = (String)values[7];
        this._lastRowIndexVar = (String)values[8];
        this._style = (String)values[9];
        this._styleClass = (String)values[10];
        this._columnClasses = (String)values[11];
        this._paginator = (Boolean)values[12];
        this._paginatorMaxPages = (Integer)values[13];
        this._renderFacetsIfSinglePage = (Boolean)values[14];
        this._immediate = (Boolean)values[15];
        this._actionListener = (MethodBinding)DataPaginator.restoreAttachedState((FacesContext)context, (Object)values[16]);
        this._vertical = (Boolean)values[17];
        this.renderedOnUserRole = (String)values[18];
        this.enabledOnUserRole = (String)values[19];
        this.disabled = (Boolean)values[20];
        this.oldRow = (Integer)values[21];
        this.pageIndex = (Integer)values[22];
        this.keyboardNavigationEnabled = (Boolean)values[23];
        this.tabindex = (Integer)values[24];
    }

    public void gotoFirstPage() {
        this.getUIData().setFirst(0);
        UIData uiData = this.getUIData();
        DataPaginatorGroup.execute(uiData, new DataPaginatorGroup.Invoker(){

            public void invoke(DataPaginator dataPaginator) {
                dataPaginator.setPageIndex(1);
            }
        });
    }

    public void gotoPreviousPage() {
        if (this.isModelResultSet()) {
            int first = this.getUIData().getFirst() - this.getUIData().getRows();
            if (first < 0) {
                first = 0;
            }
            this.getUIData().setFirst(first);
        } else {
            int previous = this.getUIData().getFirst() - this.getUIData().getRows();
            int rowCount = this.getRowCount();
            if (previous >= 0) {
                if (previous > rowCount) {
                    previous = rowCount;
                }
                this.getUIData().setFirst(previous);
            }
        }
    }

    public void gotoNextPage() {
        int next = this.getUIData().getFirst() + this.getUIData().getRows();
        if (this.isModelResultSet()) {
            this.getUIData().setRowIndex(next);
            if (this.getUIData().isRowAvailable()) {
                this.getUIData().setFirst(next);
            }
        } else if (next < this.getUIData().getRowCount()) {
            this.getUIData().setFirst(next);
        }
    }

    public void gotoFastForward() {
        int rowcount;
        int next;
        int fastStep = this.getFastStep();
        if (fastStep <= 0) {
            fastStep = 1;
        }
        if ((next = this.getUIData().getFirst() + this.getUIData().getRows() * fastStep) >= (rowcount = this.getUIData().getRowCount())) {
            next = rowcount - 1 - (rowcount - 1) % this.getUIData().getRows();
        }
        this.getUIData().setFirst(next);
    }

    public void gotoFastRewind() {
        int previous;
        int fastStep = this.getFastStep();
        if (fastStep <= 0) {
            fastStep = 1;
        }
        if ((previous = this.getUIData().getFirst() - this.getUIData().getRows() * fastStep) < 0) {
            previous = 0;
        }
        this.getUIData().setFirst(previous);
    }

    public void gotoLastPage() {
        if (this.isModelResultSet()) {
            int first = this.getUIData().getFirst();
            while (true) {
                this.getUIData().setRowIndex(first + 1);
                if (!this.getUIData().isRowAvailable()) break;
                ++first;
            }
            this.getUIData().setFirst(first - first % this.getUIData().getRows());
        } else {
            int first;
            int rows;
            int rowcount = this.getUIData().getRowCount();
            int delta = rowcount % (rows = this.getUIData().getRows());
            int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
            if (first >= 0) {
                this.getUIData().setFirst(first);
            } else {
                this.getUIData().setFirst(0);
            }
        }
    }

    public boolean isLastPage() {
        return this.getPageIndex() >= this.getPageCount();
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this.enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this.enabledOnUserRole != null) {
            return this.enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isModelResultSet() {
        if (this.modelResultSet == null) {
            if (this.getUIData().getValue() instanceof ResultSet) {
                this.modelResultSet = Boolean.TRUE;
            } else {
                DataModel dataModel;
                if (this.getUIData().getValue() instanceof DataModel && (dataModel = (DataModel)this.getUIData().getValue()).getRowCount() == -1) {
                    this.modelResultSet = Boolean.TRUE;
                    return this.modelResultSet;
                }
                this.modelResultSet = Boolean.FALSE;
            }
        }
        return this.modelResultSet;
    }

    public boolean isKeyboardNavigationEnabled() {
        if (this.keyboardNavigationEnabled != null) {
            return this.keyboardNavigationEnabled;
        }
        ValueBinding vb = this.getValueBinding("keyboardNavigationEnabled");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : true;
    }

    public void setKeyboardNavigationEnabled(boolean keyboardNavigationEnabled) {
        this.keyboardNavigationEnabled = new Boolean(keyboardNavigationEnabled);
    }

    public void decode(FacesContext context) {
        DataPaginatorGroup.add(context, this);
        super.decode(context);
    }

    public void setTabindex(int tabindex) {
        this.tabindex = new Integer(tabindex);
    }

    public int getTabindex() {
        if (this.tabindex != null) {
            return this.tabindex;
        }
        ValueBinding vb = this.getValueBinding("tabindex");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Integer.MIN_VALUE;
    }
}

