/*
 * Copyright 2004-2014 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.icefaces.ace.component.panelstack;

import org.icefaces.ace.api.StackPaneController;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class PanelStack extends PanelStackBase implements StackPaneController, NamingContainer {

	public String getContainerClientId(FacesContext context) {
		if (isPrependId()) {
			setId(getId()); // cause to re-calculate client ID to include naming container ID
			return this.getClientId(context);
		} else {
			UIComponent parent = getParent();
			if (parent != null) return parent.getContainerClientId(context);
			else return "";
		}
	}
}


