/*
 * Original Code Copyright Prime Technology.
 * Subsequent Code Modifications Copyright 2011-2014 ICEsoft Technologies Canada Corp. (c)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * NOTE THIS CODE HAS BEEN MODIFIED FROM ORIGINAL FORM
 *
 * Subsequent Code Modifications have been made and contributed by ICEsoft Technologies Canada Corp. (c).
 *
 * Code Modification 1: Integrated with ICEfaces Advanced Component Environment.
 * Contributors: ICEsoft Technologies Canada Corp. (c)
 *
 * Code Modification 2: [ADD BRIEF DESCRIPTION HERE]
 * Contributors: ______________________
 * Contributors: ______________________
 */


package org.icefaces.ace.component.accordion;


import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import java.util.ArrayList;
import java.util.List;

public class Accordion extends AccordionBase implements NamingContainer {

	private static final String OPTIMIZED_PACKAGE = "org.icefaces.ace.component.";

    public boolean isTabChangeRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_tabChange");
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    private boolean isSelfRequest(FacesContext context) {
        return isTabChangeRequest(context) || isContentLoadRequest(context);
    }

	public void broadcast(javax.faces.event.FacesEvent event) throws AbortProcessingException {
		super.broadcast(event);

		FacesContext facesContext = FacesContext.getCurrentInstance();
		MethodExpression me = getPaneChangeListener();

		if(me != null && event instanceof org.icefaces.ace.event.AccordionPaneChangeEvent) {
			me.invoke(facesContext.getELContext(), new Object[] {event});
		}
	}

    public AccordionPane findTabToLoad(FacesContext context) {
        String newTabId = context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_newTab");

        for(UIComponent component : getChildren()) {
            if(component.getClientId().equals(newTabId))
                return (AccordionPane) component;
        }

        return null;
    }

    @Override
    public void processDecodes(FacesContext context) {
        if(isSelfRequest(context)) {
            this.decode(context);
        }
        else {
            super.processDecodes(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if(!isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if(!isSelfRequest(context)) {
            super.processUpdates(context);
        }

        ValueExpression expr = this.getValueExpression("activeIndex");
        if(expr != null) {
            expr.setValue(getFacesContext().getELContext(), getActiveIndex());
            resetActiveIndex();
        }
    }

    protected void resetActiveIndex() {
		getStateHelper().remove(PropertyKeys.activeIndex);
    }

	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}

	public String getContainerClientId(FacesContext context) {
		if (isPrependId()) {
			setId(getId()); // cause to re-calculate client ID to include naming container ID
			return this.getClientId(context);
		} else {
			UIComponent parent = getParent();
			if (parent != null) return parent.getContainerClientId(context);
			else return "";
		}
	}
}