/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.facelets;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class returnTypeClass;
    private final Class[] params;

    public MethodRule(String methodName, Class returnTypeClass, Class[] params) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodBinding.class.equals((Object)meta.getPropertyType(name))) {
            Method method2 = meta.getWriteMethod(name);
            if (method2 != null) {
                return new MethodBindingMetadata(method2, attribute, this.returnTypeClass, this.params);
            }
        } else if (MethodExpression.class.equals((Object)meta.getPropertyType(name)) && (method = meta.getWriteMethod(name)) != null) {
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private static class LegacyMethodBinding
    extends MethodBinding
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final MethodExpression m;

        public LegacyMethodBinding(MethodExpression m) {
            this.m = m;
        }

        public Class getType(FacesContext context) throws javax.faces.el.MethodNotFoundException {
            try {
                return this.m.getMethodInfo(context.getELContext()).getReturnType();
            }
            catch (MethodNotFoundException e) {
                throw new javax.faces.el.MethodNotFoundException(e.getMessage(), e.getCause());
            }
            catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }

        public Object invoke(FacesContext context, Object[] params) throws EvaluationException, javax.faces.el.MethodNotFoundException {
            try {
                return this.m.invoke(context.getELContext(), params);
            }
            catch (MethodNotFoundException e) {
                throw new javax.faces.el.MethodNotFoundException(e.getMessage(), e.getCause());
            }
            catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }

        public String getExpressionString() {
            return this.m.getExpressionString();
        }
    }

    private static class MethodExpressionMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class returnType, Class[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, this._paramList);
            try {
                this._method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }

    private static class MethodBindingMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;

        public MethodBindingMetadata(Method method, TagAttribute attribute, Class returnType, Class[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, this._paramList);
            try {
                this._method.invoke(instance, new LegacyMethodBinding(expr));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

