/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tabset;

import java.io.IOException;
import java.util.ArrayList;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.ace.component.tabset.TabPane;
import org.icefaces.ace.component.tabset.TabSetBase;
import org.icefaces.ace.component.tabset.TabSetRenderer;

public class TabSet
extends TabSetBase {
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event != null && event instanceof ValueChangeEvent) {
            ValueExpression ve = this.getValueExpression("selectedIndex");
            if (this.isCancelOnInvalid()) {
                this.getFacesContext().renderResponse();
            }
            if (ve != null) {
                try {
                    ve.setValue(this.getFacesContext().getELContext(), ((ValueChangeEvent)event).getNewValue());
                }
                catch (ELException ee) {
                    ee.printStackTrace();
                }
            } else {
                this.setSelectedIndex((Integer)((ValueChangeEvent)event).getNewValue());
            }
            MethodExpression method = this.getTabChangeListener();
            if (method != null) {
                method.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getComponent() instanceof TabSet) {
            if (this.isImmediate() || !this.isCancelOnInvalid()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setPreDecodeSelectedIndex(this.getSelectedIndex());
        super.processDecodes(context);
    }

    boolean isExecutingTabPaneContents(FacesContext context, TabPane tabPane) {
        if (this.isClientSide()) {
            return true;
        }
        Integer executeIndex = this.getPreDecodeSelectedIndex();
        if (executeIndex == null) {
            return true;
        }
        ArrayList<String> tabPaneClientIds = new ArrayList<String>();
        try {
            TabSetRenderer.doTabs(context, (UIComponent)this, TabSetRenderer.Do.GET_CLIENT_IDS_ONLY, tabPaneClientIds, null, null);
        }
        catch (IOException e) {
            throw new FacesException("Problem retrieving list of TabPane children of TabSet", (Throwable)e);
        }
        String tabPaneClientId = tabPane.getClientId(context);
        boolean ret = executeIndex >= 0 && executeIndex < tabPaneClientIds.size() && ((String)tabPaneClientIds.get(executeIndex)).equals(tabPaneClientId);
        return ret;
    }
}

