/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.panel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.icefaces.ace.component.menu.Menu;
import org.icefaces.ace.component.panel.PanelBase;
import org.icefaces.ace.event.CloseEvent;
import org.icefaces.ace.event.ToggleEvent;
import org.icefaces.ace.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panel
extends PanelBase {
    private static final String OPTIMIZED_PACKAGE = "org.icefaces.ace.component.";
    public static final String PANEL_CLASS = "ui-panel ui-widget ui-widget-content ui-corner-all";
    public static final String PANEL_TITLEBAR_CLASS = "ui-panel-titlebar ui-widget-header ui-corner-all";
    public static final String PANEL_TITLE_CLASS = "ui-panel-title";
    public static final String PANEL_TITLE_ICON_CLASS = "ui-panel-titlebar-icon ui-corner-all ui-state-default";
    public static final String PANEL_CONTENT_CLASS = "ui-panel-content ui-widget-content";
    public static final String PANEL_FOOTER_CLASS = "ui-panel-footer ui-widget-content";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("toggle", "close"));
    private Menu optionsMenu;

    public Menu getOptionsMenu() {
        UIComponent optionsFacet;
        if (this.optionsMenu == null && (optionsFacet = this.getFacet("options")) != null) {
            this.optionsMenu = optionsFacet instanceof Menu ? (Menu)optionsFacet : (Menu)((Object)optionsFacet.getChildren().get(0));
        }
        return this.optionsMenu;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String source = (String)params.get("javax.faces.source");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("toggle")) {
                boolean collapsed = Boolean.valueOf((String)params.get(clientId + "_collapsed"));
                Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
                super.queueEvent((FacesEvent)new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility));
            } else if (eventName.equals("close")) {
                super.queueEvent((FacesEvent)new CloseEvent((UIComponent)this, behaviorEvent.getBehavior()));
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext context) {
        if (this.isSelfRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processUpdates(context);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

