/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menu;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.icefaces.ace.model.MenuModel;

public abstract class AbstractMenu
extends UIComponentBase {
    private static final String BUILT_FROM_MODEL_PARAM = "_builtFromModel";

    public void buildMenuFromModel() {
        MenuModel model = this.getModel();
        if (model != null) {
            this.getChildren().clear();
            for (UIComponent kid : model.getMenus()) {
                this.setTransientRecursive(kid);
                this.getChildren().add(kid);
            }
            this.markAsBuiltFromModel();
        }
    }

    public void processDecodes(FacesContext context) {
        if (this.shouldBuildFromModel()) {
            this.buildMenuFromModel();
        }
        super.processDecodes(context);
    }

    protected void setTransientRecursive(UIComponent comp) {
        comp.setTransient(true);
        Iterator it = comp.getFacetsAndChildren();
        while (it.hasNext()) {
            this.setTransientRecursive((UIComponent)it.next());
        }
    }

    public abstract MenuModel getModel();

    public boolean isDynamic() {
        return this.getValueExpression("model") != null;
    }

    public boolean isBuiltFromModel() {
        return this.getFacesContext().getViewRoot().getViewMap().containsKey(this.getClientId() + BUILT_FROM_MODEL_PARAM);
    }

    public void markAsBuiltFromModel() {
        this.getFacesContext().getViewRoot().getViewMap().put(this.getClientId() + BUILT_FROM_MODEL_PARAM, true);
    }

    public boolean shouldBuildFromModel() {
        return this.isDynamic();
    }
}

