/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datetimeentry;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.icefaces.ace.component.datetimeentry.DateTimeEntryBase;
import org.icefaces.ace.event.DateSelectEvent;
import org.icefaces.ace.event.DateTextChangeEvent;

public class DateTimeEntry
extends DateTimeEntryBase {
    public static final String INPUT_STYLE_CLASS = "ui-inputfield ui-widget ui-state-default ui-corner-all";
    public static String POPUP_ICON = "datetimeentry/calendar_icon.png";
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();
    private Locale appropriateLocale;
    private TimeZone appropriateTimeZone;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locale calculateLocale(FacesContext facesContext) {
        if (this.appropriateLocale != null) return this.appropriateLocale;
        Object userLocale = this.getLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                String[] tokens = ((String)userLocale).split("_");
                this.appropriateLocale = tokens.length == 1 ? new Locale(tokens[0], "") : new Locale(tokens[0], tokens[1]);
                return this.appropriateLocale;
            } else {
                if (!(userLocale instanceof Locale)) throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for calendar:" + this.getClientId(facesContext));
                this.appropriateLocale = (Locale)userLocale;
            }
            return this.appropriateLocale;
        } else {
            this.appropriateLocale = facesContext.getViewRoot().getLocale();
        }
        return this.appropriateLocale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeZone calculateTimeZone() {
        if (this.appropriateTimeZone != null) return this.appropriateTimeZone;
        Object usertimeZone = this.getTimeZone();
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                this.appropriateTimeZone = TimeZone.getTimeZone((String)usertimeZone);
                return this.appropriateTimeZone;
            } else {
                if (!(usertimeZone instanceof TimeZone)) throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
                this.appropriateTimeZone = (TimeZone)usertimeZone;
            }
            return this.appropriateTimeZone;
        } else {
            this.appropriateTimeZone = TimeZone.getDefault();
        }
        return this.appropriateTimeZone;
    }

    public boolean isPopup() {
        return this.isRenderAsPopup();
    }

    public boolean hasTime() {
        String pattern = this.getPattern();
        return pattern != null && pattern.indexOf(":") != -1;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        String eventName = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.behavior.event");
        if (eventName != null && event instanceof AjaxBehaviorEvent) {
            this.customEvents.put(eventName, (AjaxBehaviorEvent)event);
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid()) {
            AjaxBehaviorEvent newEvent = null;
            for (String eventName : this.customEvents.keySet()) {
                AjaxBehaviorEvent behaviorEvent = this.customEvents.get(eventName);
                if (eventName.equals("dateSelect")) {
                    newEvent = new DateSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), (Date)this.getValue());
                } else if (eventName.equals("dateTextChange")) {
                    String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_input");
                    newEvent = new DateTextChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), submittedValue, (Date)this.getValue());
                }
                if (newEvent != null && behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    newEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                }
                super.queueEvent(newEvent);
            }
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

