/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.icefaces.ace.component.dataexporter.DataExporterBase;
import org.icefaces.ace.component.dataexporter.Exporter;
import org.icefaces.ace.component.dataexporter.ExporterFactory;
import org.icefaces.ace.component.datatable.DataTable;

public class DataExporter
extends DataExporterBase {
    private transient String path = null;
    private transient String source = "";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event != null) {
            try {
                String path;
                FacesContext facesContext = this.getFacesContext();
                Exporter exporter = ExporterFactory.getExporterForType(this.getType());
                UIComponent targetComponent = event.getComponent().findComponent(this.getTarget());
                if (targetComponent == null) {
                    targetComponent = this.findComponentCustom((UIComponent)facesContext.getViewRoot(), this.getTarget());
                }
                if (targetComponent == null) {
                    throw new FacesException("Cannot find component \"" + this.getTarget() + "\" in view.");
                }
                if (!(targetComponent instanceof DataTable)) {
                    throw new FacesException("Unsupported datasource target:\"" + targetComponent.getClass().getName() + "\", exporter must target a ACE DataTable.");
                }
                int[] excludedColumnIndexes = this.resolveExcludedColumnIndexes(this.getExcludeColumns());
                DataTable table = (DataTable)targetComponent;
                this.path = path = exporter.export(facesContext, table, this.getFileName(), this.isPageOnly(), excludedColumnIndexes, this.getEncoding(), this.getPreProcessor(), this.getPostProcessor(), this.isIncludeHeaders(), this.isIncludeFooters(), this.isSelectedRowsOnly());
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private int[] resolveExcludedColumnIndexes(String columnsToExclude) {
        if (columnsToExclude == null || columnsToExclude.equals("")) {
            return null;
        }
        String[] columnIndexesAsString = columnsToExclude.split(",");
        int[] indexes = new int[columnIndexesAsString.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Integer.parseInt(columnIndexesAsString[i].trim());
        }
        return indexes;
    }

    private UIComponent findComponentCustom(UIComponent base, String id) {
        UIComponent child;
        if (base.getId().equals(id)) {
            return base;
        }
        List children = base.getChildren();
        UIComponent result = null;
        Iterator i$ = children.iterator();
        while (i$.hasNext() && (result = this.findComponentCustom(child = (UIComponent)i$.next(), id)) == null) {
        }
        return result;
    }

    public String getPath(String clientId) {
        if (this.source.equals(clientId)) {
            return this.path;
        }
        return null;
    }

    public void setSource(String clientId) {
        this.source = clientId;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

