/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.animation;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.FacesContext;
import org.icefaces.component.animation.Anim;
import org.icefaces.component.animation.Appear;
import org.icefaces.component.animation.BehaviorBase;
import org.icefaces.component.animation.Effect;
import org.icefaces.component.animation.Fade;
import org.icefaces.component.animation.Highlight;

@FacesBehavior(value="org.icefaces.animation.Animation")
@ResourceDependencies(value={@ResourceDependency(name="yui/yui-min.js", library="yui/3_1_1"), @ResourceDependency(name="loader/loader-min.js", library="yui/3_1_1"), @ResourceDependency(name="util.js", library="org.icefaces.component.util"), @ResourceDependency(name="component.js", library="org.icefaces.component.util"), @ResourceDependency(name="yui3.js", library="org.icefaces.component.util"), @ResourceDependency(name="animation.js", library="org.icefaces.component.animation"), @ResourceDependency(name="animation.css", library="org.icefaces.component.animation")})
public class AnimationBehavior
extends BehaviorBase {
    public static final String BEHAVIOR_ID = "org.icefaces.animation.Animation";
    private String effectsLib = "ice.animation.";
    private boolean usingStyleClass;
    private boolean run;
    Effect effect = new Anim();
    private String style;
    private String to;
    private String from;
    private String easing;
    private Integer iterations;
    private Double duration;
    private String styleClass;

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getEasing() {
        return this.easing;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public void setIterations(Integer iterations) {
        this.iterations = iterations;
    }

    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setEffectObject(Effect effect) {
        this.effect = effect;
        this.clearInitialState();
    }

    public Effect getEffect() {
        return (Effect)this.eval("effectObject", this.effect);
    }

    public void setName(String name) {
        this.use(name);
        this.clearInitialState();
    }

    public String getName() {
        return this.effect.getClass().getSimpleName();
    }

    public void setRun(boolean run) {
        ValueExpression expression = this.getValueExpression("run");
        if (expression != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            expression.setValue(ctx.getELContext(), (Object)run);
        } else {
            this.run = run;
        }
        this.clearInitialState();
    }

    public boolean isRun() {
        return (Boolean)this.eval("run", this.run);
    }

    private void run(FacesContext facesContext, UIComponent uiComponent) {
    }

    private void use(String name) {
        if ("Fade".equalsIgnoreCase(name)) {
            this.effect = new Fade();
        } else if ("Appear".equalsIgnoreCase(name)) {
            this.effect = new Appear();
        } else if ("Highlight".equalsIgnoreCase(name)) {
            this.effect = new Highlight();
        } else if ("Anim".equalsIgnoreCase(name)) {
            this.effect = new Anim();
        }
    }

    protected String getEffectsLib() {
        return this.effectsLib;
    }

    protected void setEffectsLib(String effectsLib) {
        this.effectsLib = effectsLib;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setUsingStyleClass(boolean usingStyleClass) {
        this.usingStyleClass = usingStyleClass;
    }

    public boolean isUsingStyleClass() {
        return this.usingStyleClass;
    }

    public String getScript(ClientBehaviorContext behaviorContext) {
        return this.getScript(behaviorContext, true);
    }

    public String getScript(ClientBehaviorContext behaviorContext, boolean run) {
        if ("Anim".equals(this.effect.getName())) {
            if (this.getTo() != null && !this.effect.getProperties().containsKey("to")) {
                this.effect.getProperties().put("to", this.getTo());
            }
            if (this.getFrom() != null && !this.effect.getProperties().containsKey("from")) {
                this.effect.getProperties().put("from", this.getFrom());
            }
        }
        if (this.getIterations() != null && !this.effect.getProperties().containsKey("iterations")) {
            this.effect.getProperties().put("iterations", this.getIterations());
        }
        if (this.getDuration() != null && !this.effect.getProperties().containsKey("duration")) {
            this.effect.getProperties().put("duration", this.getDuration());
        }
        if (this.getEasing() != null && !this.effect.getProperties().containsKey("easing")) {
            this.effect.getProperties().put("easing", this.getEasing());
        }
        if (!this.effect.getProperties().containsKey("event")) {
            this.effect.getProperties().put("event", behaviorContext.getEventName());
        }
        if (!this.effect.getProperties().containsKey("name")) {
            this.effect.getProperties().put("name", this.getName());
        }
        this.effect.setSourceElement(behaviorContext.getComponent().getClientId());
        if (behaviorContext.getComponent().getAttributes().get("styleClass") != null) {
            this.effect.getProperties().put("componentStyleClass", behaviorContext.getComponent().getAttributes().get("styleClass"));
        }
        StringBuilder call = new StringBuilder();
        call.append(this.getEffectsLib());
        if (run) {
            call.append("run");
        } else {
            call.append("register");
        }
        call.append("(");
        call.append(this.effect.getPropertiesAsJSON());
        call.append(");");
        return call.toString();
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        Map map = context.getExternalContext().getRequestParameterMap();
        String id = "effect_style" + component.getClientId();
        if (map.containsKey(id)) {
            this.setStyle(map.get(id).toString());
        }
    }

    public void encodeBegin(FacesContext context, UIComponent uiComponent) {
        this.run(context, uiComponent);
    }

    protected Object eval(String propertyName, Object value) {
        ValueExpression expression = this.getValueExpression(propertyName);
        if (expression != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return expression.getValue(ctx.getELContext());
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.bindings == null ? null : (ValueExpression)this.bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (binding != null) {
            if (binding.isLiteralText()) {
                this.setLiteralValue(name, binding);
            } else {
                if (this.bindings == null) {
                    this.bindings = new HashMap();
                }
                this.bindings.put(name, binding);
                if ("effectObject".equals(name)) {
                    this.effect = (Effect)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.effect.setEffectBehavior(this);
                } else if ("name".equals(name)) {
                    String effectName = (String)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.use(effectName);
                } else if ("to".equals(name)) {
                    String to = (String)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.setTo(to);
                } else if ("from".equals(name)) {
                    String from = (String)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.setFrom(from);
                } else if ("easing".equals(name)) {
                    String easing = (String)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.setEasing(easing);
                } else if ("iterations".equals(name)) {
                    Integer iterations = (Integer)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.setIterations(iterations);
                } else if ("duration".equals(name)) {
                    Double duration = (Double)binding.getValue(FacesContext.getCurrentInstance().getELContext());
                    this.setDuration(duration);
                }
            }
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.isEmpty()) {
                this.bindings = null;
            }
        }
        this.clearInitialState();
    }

    protected void setLiteralValue(String propertyName, ValueExpression expression) {
        Object value;
        assert (expression.isLiteralText());
        ELContext context = FacesContext.getCurrentInstance().getELContext();
        try {
            value = expression.getValue(context);
        }
        catch (ELException ele) {
            throw new FacesException((Throwable)ele);
        }
        if ("run".equals(propertyName)) {
            this.run = (Boolean)value;
        } else if ("name".equals(propertyName)) {
            this.setName((String)value);
        } else if ("to".equals(propertyName)) {
            this.setTo((String)value);
        } else if ("from".equals(propertyName)) {
            this.setFrom((String)value);
        } else if ("easing".equals(propertyName)) {
            this.setEasing((String)value);
        } else if ("iterations".equals(propertyName)) {
            this.setIterations((Integer)value);
        } else if ("duration".equals(propertyName)) {
            this.setDuration((Double)value);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] returnVal = new Object[]{this.saveBindingsState(context), this.effectsLib, this.run, this.usingStyleClass, this.style, this.to, this.from, this.iterations, this.duration};
        return returnVal;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] stateArray = (Object[])state;
        this.bindings = AnimationBehavior.restoreBindingsState(context, stateArray[0]);
        this.effectsLib = (String)stateArray[1];
        this.run = (Boolean)stateArray[2];
        this.usingStyleClass = (Boolean)stateArray[3];
        this.style = (String)stateArray[4];
        this.to = (String)stateArray[5];
        this.from = (String)stateArray[6];
        this.iterations = (Integer)stateArray[7];
        this.duration = (Double)stateArray[8];
    }

    public static abstract class Iterator
    implements IIterator {
        private UIComponent uiComponent;

        private Iterator() {
        }

        public Iterator(UIComponent uiComponent) {
            this.uiComponent = uiComponent;
        }

        public UIComponent getUIComponent() {
            return this.uiComponent;
        }
    }

    public static interface IIterator {
        public void next(String var1, AnimationBehavior var2);
    }
}

