/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.protos.discovery;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldBuilder;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hyperledger.fabric.protos.discovery.EndorsementDescriptorOrBuilder;
import org.hyperledger.fabric.protos.discovery.Layout;
import org.hyperledger.fabric.protos.discovery.LayoutOrBuilder;
import org.hyperledger.fabric.protos.discovery.Peers;
import org.hyperledger.fabric.protos.discovery.PeersOrBuilder;
import org.hyperledger.fabric.protos.discovery.ProtocolProto;

public final class EndorsementDescriptor
extends GeneratedMessage
implements EndorsementDescriptorOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CHAINCODE_FIELD_NUMBER = 1;
    private volatile Object chaincode_ = "";
    public static final int ENDORSERS_BY_GROUPS_FIELD_NUMBER = 2;
    private MapField<String, Peers> endorsersByGroups_;
    public static final int LAYOUTS_FIELD_NUMBER = 3;
    private List<Layout> layouts_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final EndorsementDescriptor DEFAULT_INSTANCE;
    private static final Parser<EndorsementDescriptor> PARSER;

    private EndorsementDescriptor(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private EndorsementDescriptor() {
        this.chaincode_ = "";
        this.layouts_ = Collections.emptyList();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ProtocolProto.internal_static_discovery_EndorsementDescriptor_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 2: {
                return this.internalGetEndorsersByGroups();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return ProtocolProto.internal_static_discovery_EndorsementDescriptor_fieldAccessorTable.ensureFieldAccessorsInitialized(EndorsementDescriptor.class, Builder.class);
    }

    @Override
    public String getChaincode() {
        Object ref = this.chaincode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.chaincode_ = s;
        return s;
    }

    @Override
    public ByteString getChaincodeBytes() {
        Object ref = this.chaincode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.chaincode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, Peers> internalGetEndorsersByGroups() {
        if (this.endorsersByGroups_ == null) {
            return MapField.emptyMapField(EndorsersByGroupsDefaultEntryHolder.defaultEntry);
        }
        return this.endorsersByGroups_;
    }

    @Override
    public int getEndorsersByGroupsCount() {
        return this.internalGetEndorsersByGroups().getMap().size();
    }

    @Override
    public boolean containsEndorsersByGroups(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetEndorsersByGroups().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, Peers> getEndorsersByGroups() {
        return this.getEndorsersByGroupsMap();
    }

    @Override
    public Map<String, Peers> getEndorsersByGroupsMap() {
        return this.internalGetEndorsersByGroups().getMap();
    }

    @Override
    public Peers getEndorsersByGroupsOrDefault(String key, Peers defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetEndorsersByGroups().getMap();
        return map.containsKey(key) ? (Peers)map.get(key) : defaultValue;
    }

    @Override
    public Peers getEndorsersByGroupsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetEndorsersByGroups().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (Peers)map.get(key);
    }

    @Override
    public List<Layout> getLayoutsList() {
        return this.layouts_;
    }

    @Override
    public List<? extends LayoutOrBuilder> getLayoutsOrBuilderList() {
        return this.layouts_;
    }

    @Override
    public int getLayoutsCount() {
        return this.layouts_.size();
    }

    @Override
    public Layout getLayouts(int index) {
        return this.layouts_.get(index);
    }

    @Override
    public LayoutOrBuilder getLayoutsOrBuilder(int index) {
        return this.layouts_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessage.isStringEmpty((Object)this.chaincode_)) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)1, (Object)this.chaincode_);
        }
        GeneratedMessage.serializeStringMapTo((CodedOutputStream)output, this.internalGetEndorsersByGroups(), EndorsersByGroupsDefaultEntryHolder.defaultEntry, (int)2);
        for (int i = 0; i < this.layouts_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.layouts_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessage.isStringEmpty((Object)this.chaincode_)) {
            size += GeneratedMessage.computeStringSize((int)1, (Object)this.chaincode_);
        }
        for (Map.Entry entry : this.internalGetEndorsersByGroups().getMap().entrySet()) {
            MapEntry endorsersByGroups__ = EndorsersByGroupsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey((Object)((String)entry.getKey())).setValue((Object)((Peers)entry.getValue())).build();
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)endorsersByGroups__);
        }
        for (int i = 0; i < this.layouts_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.layouts_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EndorsementDescriptor)) {
            return super.equals(obj);
        }
        EndorsementDescriptor other = (EndorsementDescriptor)obj;
        if (!this.getChaincode().equals(other.getChaincode())) {
            return false;
        }
        if (!this.internalGetEndorsersByGroups().equals(other.internalGetEndorsersByGroups())) {
            return false;
        }
        if (!this.getLayoutsList().equals(other.getLayoutsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + EndorsementDescriptor.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getChaincode().hashCode();
        if (!this.internalGetEndorsersByGroups().getMap().isEmpty()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.internalGetEndorsersByGroups().hashCode();
        }
        if (this.getLayoutsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getLayoutsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static EndorsementDescriptor parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data);
    }

    public static EndorsementDescriptor parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorsementDescriptor parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data);
    }

    public static EndorsementDescriptor parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorsementDescriptor parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data);
    }

    public static EndorsementDescriptor parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorsementDescriptor)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorsementDescriptor parseFrom(InputStream input) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static EndorsementDescriptor parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EndorsementDescriptor parseDelimitedFrom(InputStream input) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static EndorsementDescriptor parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EndorsementDescriptor parseFrom(CodedInputStream input) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static EndorsementDescriptor parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorsementDescriptor)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return EndorsementDescriptor.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(EndorsementDescriptor prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static EndorsementDescriptor getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<EndorsementDescriptor> parser() {
        return PARSER;
    }

    public Parser<EndorsementDescriptor> getParserForType() {
        return PARSER;
    }

    public EndorsementDescriptor getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)28, (int)2, (String)"", (String)EndorsementDescriptor.class.getName());
        DEFAULT_INSTANCE = new EndorsementDescriptor();
        PARSER = new AbstractParser<EndorsementDescriptor>(){

            public EndorsementDescriptor parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = EndorsementDescriptor.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements EndorsementDescriptorOrBuilder {
        private int bitField0_;
        private Object chaincode_ = "";
        private static final EndorsersByGroupsConverter endorsersByGroupsConverter = new EndorsersByGroupsConverter();
        private MapFieldBuilder<String, PeersOrBuilder, Peers, Peers.Builder> endorsersByGroups_;
        private List<Layout> layouts_ = Collections.emptyList();
        private RepeatedFieldBuilder<Layout, Layout.Builder, LayoutOrBuilder> layoutsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ProtocolProto.internal_static_discovery_EndorsementDescriptor_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 2: {
                    return this.internalGetEndorsersByGroups();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 2: {
                    return this.internalGetMutableEndorsersByGroups();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProtocolProto.internal_static_discovery_EndorsementDescriptor_fieldAccessorTable.ensureFieldAccessorsInitialized(EndorsementDescriptor.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.chaincode_ = "";
            this.internalGetMutableEndorsersByGroups().clear();
            if (this.layoutsBuilder_ == null) {
                this.layouts_ = Collections.emptyList();
            } else {
                this.layouts_ = null;
                this.layoutsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ProtocolProto.internal_static_discovery_EndorsementDescriptor_descriptor;
        }

        public EndorsementDescriptor getDefaultInstanceForType() {
            return EndorsementDescriptor.getDefaultInstance();
        }

        public EndorsementDescriptor build() {
            EndorsementDescriptor result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public EndorsementDescriptor buildPartial() {
            EndorsementDescriptor result = new EndorsementDescriptor(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(EndorsementDescriptor result) {
            if (this.layoutsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.layouts_ = Collections.unmodifiableList(this.layouts_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.layouts_ = this.layouts_;
            } else {
                result.layouts_ = this.layoutsBuilder_.build();
            }
        }

        private void buildPartial0(EndorsementDescriptor result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.chaincode_ = this.chaincode_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.endorsersByGroups_ = this.internalGetEndorsersByGroups().build(EndorsersByGroupsDefaultEntryHolder.defaultEntry);
            }
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof EndorsementDescriptor) {
                return this.mergeFrom((EndorsementDescriptor)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(EndorsementDescriptor other) {
            if (other == EndorsementDescriptor.getDefaultInstance()) {
                return this;
            }
            if (!other.getChaincode().isEmpty()) {
                this.chaincode_ = other.chaincode_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            this.internalGetMutableEndorsersByGroups().mergeFrom(other.internalGetEndorsersByGroups());
            this.bitField0_ |= 2;
            if (this.layoutsBuilder_ == null) {
                if (!other.layouts_.isEmpty()) {
                    if (this.layouts_.isEmpty()) {
                        this.layouts_ = other.layouts_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureLayoutsIsMutable();
                        this.layouts_.addAll(other.layouts_);
                    }
                    this.onChanged();
                }
            } else if (!other.layouts_.isEmpty()) {
                if (this.layoutsBuilder_.isEmpty()) {
                    this.layoutsBuilder_.dispose();
                    this.layoutsBuilder_ = null;
                    this.layouts_ = other.layouts_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.layoutsBuilder_ = alwaysUseFieldBuilders ? this.getLayoutsFieldBuilder() : null;
                } else {
                    this.layoutsBuilder_.addAllMessages((Iterable)other.layouts_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            this.chaincode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            MapEntry endorsersByGroups__ = (MapEntry)input.readMessage(EndorsersByGroupsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableEndorsersByGroups().ensureBuilderMap().put((String)endorsersByGroups__.getKey(), (PeersOrBuilder)endorsersByGroups__.getValue());
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 26: {
                            Layout m = (Layout)input.readMessage(Layout.parser(), extensionRegistry);
                            if (this.layoutsBuilder_ == null) {
                                this.ensureLayoutsIsMutable();
                                this.layouts_.add(m);
                                continue block11;
                            }
                            this.layoutsBuilder_.addMessage((GeneratedMessage)m);
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getChaincode() {
            Object ref = this.chaincode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.chaincode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getChaincodeBytes() {
            Object ref = this.chaincode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.chaincode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setChaincode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.chaincode_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearChaincode() {
            this.chaincode_ = EndorsementDescriptor.getDefaultInstance().getChaincode();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setChaincodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EndorsementDescriptor.checkByteStringIsUtf8((ByteString)value);
            this.chaincode_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private MapFieldBuilder<String, PeersOrBuilder, Peers, Peers.Builder> internalGetEndorsersByGroups() {
            if (this.endorsersByGroups_ == null) {
                return new MapFieldBuilder((MapFieldBuilder.Converter)endorsersByGroupsConverter);
            }
            return this.endorsersByGroups_;
        }

        private MapFieldBuilder<String, PeersOrBuilder, Peers, Peers.Builder> internalGetMutableEndorsersByGroups() {
            if (this.endorsersByGroups_ == null) {
                this.endorsersByGroups_ = new MapFieldBuilder((MapFieldBuilder.Converter)endorsersByGroupsConverter);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this.endorsersByGroups_;
        }

        @Override
        public int getEndorsersByGroupsCount() {
            return this.internalGetEndorsersByGroups().ensureBuilderMap().size();
        }

        @Override
        public boolean containsEndorsersByGroups(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetEndorsersByGroups().ensureBuilderMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Peers> getEndorsersByGroups() {
            return this.getEndorsersByGroupsMap();
        }

        @Override
        public Map<String, Peers> getEndorsersByGroupsMap() {
            return this.internalGetEndorsersByGroups().getImmutableMap();
        }

        @Override
        public Peers getEndorsersByGroupsOrDefault(String key, Peers defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableEndorsersByGroups().ensureBuilderMap();
            return map.containsKey(key) ? endorsersByGroupsConverter.build((PeersOrBuilder)map.get(key)) : defaultValue;
        }

        @Override
        public Peers getEndorsersByGroupsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableEndorsersByGroups().ensureBuilderMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return endorsersByGroupsConverter.build((PeersOrBuilder)map.get(key));
        }

        public Builder clearEndorsersByGroups() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.internalGetMutableEndorsersByGroups().clear();
            return this;
        }

        public Builder removeEndorsersByGroups(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableEndorsersByGroups().ensureBuilderMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, Peers> getMutableEndorsersByGroups() {
            this.bitField0_ |= 2;
            return this.internalGetMutableEndorsersByGroups().ensureMessageMap();
        }

        public Builder putEndorsersByGroups(String key, Peers value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableEndorsersByGroups().ensureBuilderMap().put(key, value);
            this.bitField0_ |= 2;
            return this;
        }

        public Builder putAllEndorsersByGroups(Map<String, Peers> values) {
            for (Map.Entry<String, Peers> e : values.entrySet()) {
                if (e.getKey() != null && e.getValue() != null) continue;
                throw new NullPointerException();
            }
            this.internalGetMutableEndorsersByGroups().ensureBuilderMap().putAll(values);
            this.bitField0_ |= 2;
            return this;
        }

        public Peers.Builder putEndorsersByGroupsBuilderIfAbsent(String key) {
            Map builderMap = this.internalGetMutableEndorsersByGroups().ensureBuilderMap();
            PeersOrBuilder entry = (PeersOrBuilder)builderMap.get(key);
            if (entry == null) {
                entry = Peers.newBuilder();
                builderMap.put(key, entry);
            }
            if (entry instanceof Peers) {
                entry = ((Peers)entry).toBuilder();
                builderMap.put(key, entry);
            }
            return (Peers.Builder)entry;
        }

        private void ensureLayoutsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.layouts_ = new ArrayList<Layout>(this.layouts_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Layout> getLayoutsList() {
            if (this.layoutsBuilder_ == null) {
                return Collections.unmodifiableList(this.layouts_);
            }
            return this.layoutsBuilder_.getMessageList();
        }

        @Override
        public int getLayoutsCount() {
            if (this.layoutsBuilder_ == null) {
                return this.layouts_.size();
            }
            return this.layoutsBuilder_.getCount();
        }

        @Override
        public Layout getLayouts(int index) {
            if (this.layoutsBuilder_ == null) {
                return this.layouts_.get(index);
            }
            return (Layout)this.layoutsBuilder_.getMessage(index);
        }

        public Builder setLayouts(int index, Layout value) {
            if (this.layoutsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLayoutsIsMutable();
                this.layouts_.set(index, value);
                this.onChanged();
            } else {
                this.layoutsBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setLayouts(int index, Layout.Builder builderForValue) {
            if (this.layoutsBuilder_ == null) {
                this.ensureLayoutsIsMutable();
                this.layouts_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.layoutsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLayouts(Layout value) {
            if (this.layoutsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLayoutsIsMutable();
                this.layouts_.add(value);
                this.onChanged();
            } else {
                this.layoutsBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addLayouts(int index, Layout value) {
            if (this.layoutsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLayoutsIsMutable();
                this.layouts_.add(index, value);
                this.onChanged();
            } else {
                this.layoutsBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addLayouts(Layout.Builder builderForValue) {
            if (this.layoutsBuilder_ == null) {
                this.ensureLayoutsIsMutable();
                this.layouts_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.layoutsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLayouts(int index, Layout.Builder builderForValue) {
            if (this.layoutsBuilder_ == null) {
                this.ensureLayoutsIsMutable();
                this.layouts_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.layoutsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllLayouts(Iterable<? extends Layout> values) {
            if (this.layoutsBuilder_ == null) {
                this.ensureLayoutsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.layouts_);
                this.onChanged();
            } else {
                this.layoutsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearLayouts() {
            if (this.layoutsBuilder_ == null) {
                this.layouts_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.layoutsBuilder_.clear();
            }
            return this;
        }

        public Builder removeLayouts(int index) {
            if (this.layoutsBuilder_ == null) {
                this.ensureLayoutsIsMutable();
                this.layouts_.remove(index);
                this.onChanged();
            } else {
                this.layoutsBuilder_.remove(index);
            }
            return this;
        }

        public Layout.Builder getLayoutsBuilder(int index) {
            return (Layout.Builder)this.getLayoutsFieldBuilder().getBuilder(index);
        }

        @Override
        public LayoutOrBuilder getLayoutsOrBuilder(int index) {
            if (this.layoutsBuilder_ == null) {
                return this.layouts_.get(index);
            }
            return (LayoutOrBuilder)this.layoutsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LayoutOrBuilder> getLayoutsOrBuilderList() {
            if (this.layoutsBuilder_ != null) {
                return this.layoutsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.layouts_);
        }

        public Layout.Builder addLayoutsBuilder() {
            return (Layout.Builder)this.getLayoutsFieldBuilder().addBuilder((GeneratedMessage)Layout.getDefaultInstance());
        }

        public Layout.Builder addLayoutsBuilder(int index) {
            return (Layout.Builder)this.getLayoutsFieldBuilder().addBuilder(index, (GeneratedMessage)Layout.getDefaultInstance());
        }

        public List<Layout.Builder> getLayoutsBuilderList() {
            return this.getLayoutsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Layout, Layout.Builder, LayoutOrBuilder> getLayoutsFieldBuilder() {
            if (this.layoutsBuilder_ == null) {
                this.layoutsBuilder_ = new RepeatedFieldBuilder(this.layouts_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                this.layouts_ = null;
            }
            return this.layoutsBuilder_;
        }

        private static final class EndorsersByGroupsConverter
        implements MapFieldBuilder.Converter<String, PeersOrBuilder, Peers> {
            private EndorsersByGroupsConverter() {
            }

            public Peers build(PeersOrBuilder val) {
                if (val instanceof Peers) {
                    return (Peers)val;
                }
                return ((Peers.Builder)val).build();
            }

            public MapEntry<String, Peers> defaultEntry() {
                return EndorsersByGroupsDefaultEntryHolder.defaultEntry;
            }
        }
    }

    private static final class EndorsersByGroupsDefaultEntryHolder {
        static final MapEntry<String, Peers> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ProtocolProto.internal_static_discovery_EndorsementDescriptor_EndorsersByGroupsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)Peers.getDefaultInstance());

        private EndorsersByGroupsDefaultEntryHolder() {
        }
    }
}

