/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.protos.gateway;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.hyperledger.fabric.protos.gateway.EndorseRequestOrBuilder;
import org.hyperledger.fabric.protos.gateway.GatewayProto;
import org.hyperledger.fabric.protos.peer.SignedProposal;
import org.hyperledger.fabric.protos.peer.SignedProposalOrBuilder;

public final class EndorseRequest
extends GeneratedMessageV3
implements EndorseRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TRANSACTION_ID_FIELD_NUMBER = 1;
    private volatile Object transactionId_;
    public static final int CHANNEL_ID_FIELD_NUMBER = 2;
    private volatile Object channelId_;
    public static final int PROPOSED_TRANSACTION_FIELD_NUMBER = 3;
    private SignedProposal proposedTransaction_;
    public static final int ENDORSING_ORGANIZATIONS_FIELD_NUMBER = 4;
    private LazyStringList endorsingOrganizations_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final EndorseRequest DEFAULT_INSTANCE = new EndorseRequest();
    private static final Parser<EndorseRequest> PARSER = new AbstractParser<EndorseRequest>(){

        public EndorseRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new EndorseRequest(input, extensionRegistry);
        }
    };

    private EndorseRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private EndorseRequest() {
        this.transactionId_ = "";
        this.channelId_ = "";
        this.endorsingOrganizations_ = LazyStringArrayList.EMPTY;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new EndorseRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private EndorseRequest(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block13: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block13;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.transactionId_ = s;
                        continue block13;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.channelId_ = s;
                        continue block13;
                    }
                    case 26: {
                        SignedProposal.Builder subBuilder = null;
                        if (this.proposedTransaction_ != null) {
                            subBuilder = this.proposedTransaction_.toBuilder();
                        }
                        this.proposedTransaction_ = (SignedProposal)input.readMessage(SignedProposal.parser(), extensionRegistry);
                        if (subBuilder == null) continue block13;
                        subBuilder.mergeFrom(this.proposedTransaction_);
                        this.proposedTransaction_ = subBuilder.buildPartial();
                        continue block13;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        if (!(mutable_bitField0_ & true)) {
                            this.endorsingOrganizations_ = new LazyStringArrayList();
                            mutable_bitField0_ |= true;
                        }
                        this.endorsingOrganizations_.add((Object)s);
                        continue block13;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.endorsingOrganizations_ = this.endorsingOrganizations_.getUnmodifiableView();
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return GatewayProto.internal_static_gateway_EndorseRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return GatewayProto.internal_static_gateway_EndorseRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(EndorseRequest.class, Builder.class);
    }

    @Override
    public String getTransactionId() {
        Object ref = this.transactionId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.transactionId_ = s;
        return s;
    }

    @Override
    public ByteString getTransactionIdBytes() {
        Object ref = this.transactionId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.transactionId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getChannelId() {
        Object ref = this.channelId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.channelId_ = s;
        return s;
    }

    @Override
    public ByteString getChannelIdBytes() {
        Object ref = this.channelId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.channelId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasProposedTransaction() {
        return this.proposedTransaction_ != null;
    }

    @Override
    public SignedProposal getProposedTransaction() {
        return this.proposedTransaction_ == null ? SignedProposal.getDefaultInstance() : this.proposedTransaction_;
    }

    @Override
    public SignedProposalOrBuilder getProposedTransactionOrBuilder() {
        return this.getProposedTransaction();
    }

    public ProtocolStringList getEndorsingOrganizationsList() {
        return this.endorsingOrganizations_;
    }

    @Override
    public int getEndorsingOrganizationsCount() {
        return this.endorsingOrganizations_.size();
    }

    @Override
    public String getEndorsingOrganizations(int index) {
        return (String)this.endorsingOrganizations_.get(index);
    }

    @Override
    public ByteString getEndorsingOrganizationsBytes(int index) {
        return this.endorsingOrganizations_.getByteString(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.transactionId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.transactionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.channelId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.channelId_);
        }
        if (this.proposedTransaction_ != null) {
            output.writeMessage(3, (MessageLite)this.getProposedTransaction());
        }
        for (int i = 0; i < this.endorsingOrganizations_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.endorsingOrganizations_.getRaw(i));
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.transactionId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.transactionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.channelId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.channelId_);
        }
        if (this.proposedTransaction_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getProposedTransaction());
        }
        int dataSize = 0;
        for (int i = 0; i < this.endorsingOrganizations_.size(); ++i) {
            dataSize += EndorseRequest.computeStringSizeNoTag((Object)this.endorsingOrganizations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getEndorsingOrganizationsList().size();
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EndorseRequest)) {
            return super.equals(obj);
        }
        EndorseRequest other = (EndorseRequest)obj;
        if (!this.getTransactionId().equals(other.getTransactionId())) {
            return false;
        }
        if (!this.getChannelId().equals(other.getChannelId())) {
            return false;
        }
        if (this.hasProposedTransaction() != other.hasProposedTransaction()) {
            return false;
        }
        if (this.hasProposedTransaction() && !this.getProposedTransaction().equals(other.getProposedTransaction())) {
            return false;
        }
        if (!this.getEndorsingOrganizationsList().equals(other.getEndorsingOrganizationsList())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + EndorseRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTransactionId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getChannelId().hashCode();
        if (this.hasProposedTransaction()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getProposedTransaction().hashCode();
        }
        if (this.getEndorsingOrganizationsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getEndorsingOrganizationsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static EndorseRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data);
    }

    public static EndorseRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorseRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data);
    }

    public static EndorseRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorseRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data);
    }

    public static EndorseRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EndorseRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EndorseRequest parseFrom(InputStream input) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static EndorseRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EndorseRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static EndorseRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EndorseRequest parseFrom(CodedInputStream input) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static EndorseRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EndorseRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return EndorseRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(EndorseRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static EndorseRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<EndorseRequest> parser() {
        return PARSER;
    }

    public Parser<EndorseRequest> getParserForType() {
        return PARSER;
    }

    public EndorseRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements EndorseRequestOrBuilder {
        private int bitField0_;
        private Object transactionId_ = "";
        private Object channelId_ = "";
        private SignedProposal proposedTransaction_;
        private SingleFieldBuilderV3<SignedProposal, SignedProposal.Builder, SignedProposalOrBuilder> proposedTransactionBuilder_;
        private LazyStringList endorsingOrganizations_ = LazyStringArrayList.EMPTY;

        public static final Descriptors.Descriptor getDescriptor() {
            return GatewayProto.internal_static_gateway_EndorseRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return GatewayProto.internal_static_gateway_EndorseRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(EndorseRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.transactionId_ = "";
            this.channelId_ = "";
            if (this.proposedTransactionBuilder_ == null) {
                this.proposedTransaction_ = null;
            } else {
                this.proposedTransaction_ = null;
                this.proposedTransactionBuilder_ = null;
            }
            this.endorsingOrganizations_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return GatewayProto.internal_static_gateway_EndorseRequest_descriptor;
        }

        public EndorseRequest getDefaultInstanceForType() {
            return EndorseRequest.getDefaultInstance();
        }

        public EndorseRequest build() {
            EndorseRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public EndorseRequest buildPartial() {
            EndorseRequest result = new EndorseRequest(this);
            int from_bitField0_ = this.bitField0_;
            result.transactionId_ = this.transactionId_;
            result.channelId_ = this.channelId_;
            if (this.proposedTransactionBuilder_ == null) {
                result.proposedTransaction_ = this.proposedTransaction_;
            } else {
                result.proposedTransaction_ = (SignedProposal)this.proposedTransactionBuilder_.build();
            }
            if ((this.bitField0_ & 1) != 0) {
                this.endorsingOrganizations_ = this.endorsingOrganizations_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.endorsingOrganizations_ = this.endorsingOrganizations_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof EndorseRequest) {
                return this.mergeFrom((EndorseRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(EndorseRequest other) {
            if (other == EndorseRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getTransactionId().isEmpty()) {
                this.transactionId_ = other.transactionId_;
                this.onChanged();
            }
            if (!other.getChannelId().isEmpty()) {
                this.channelId_ = other.channelId_;
                this.onChanged();
            }
            if (other.hasProposedTransaction()) {
                this.mergeProposedTransaction(other.getProposedTransaction());
            }
            if (!other.endorsingOrganizations_.isEmpty()) {
                if (this.endorsingOrganizations_.isEmpty()) {
                    this.endorsingOrganizations_ = other.endorsingOrganizations_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureEndorsingOrganizationsIsMutable();
                    this.endorsingOrganizations_.addAll((Collection)other.endorsingOrganizations_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            EndorseRequest parsedMessage = null;
            try {
                parsedMessage = (EndorseRequest)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (EndorseRequest)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getTransactionId() {
            Object ref = this.transactionId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.transactionId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTransactionIdBytes() {
            Object ref = this.transactionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.transactionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTransactionId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.transactionId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTransactionId() {
            this.transactionId_ = EndorseRequest.getDefaultInstance().getTransactionId();
            this.onChanged();
            return this;
        }

        public Builder setTransactionIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EndorseRequest.checkByteStringIsUtf8((ByteString)value);
            this.transactionId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getChannelId() {
            Object ref = this.channelId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.channelId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getChannelIdBytes() {
            Object ref = this.channelId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.channelId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setChannelId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.channelId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearChannelId() {
            this.channelId_ = EndorseRequest.getDefaultInstance().getChannelId();
            this.onChanged();
            return this;
        }

        public Builder setChannelIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EndorseRequest.checkByteStringIsUtf8((ByteString)value);
            this.channelId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasProposedTransaction() {
            return this.proposedTransactionBuilder_ != null || this.proposedTransaction_ != null;
        }

        @Override
        public SignedProposal getProposedTransaction() {
            if (this.proposedTransactionBuilder_ == null) {
                return this.proposedTransaction_ == null ? SignedProposal.getDefaultInstance() : this.proposedTransaction_;
            }
            return (SignedProposal)this.proposedTransactionBuilder_.getMessage();
        }

        public Builder setProposedTransaction(SignedProposal value) {
            if (this.proposedTransactionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.proposedTransaction_ = value;
                this.onChanged();
            } else {
                this.proposedTransactionBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setProposedTransaction(SignedProposal.Builder builderForValue) {
            if (this.proposedTransactionBuilder_ == null) {
                this.proposedTransaction_ = builderForValue.build();
                this.onChanged();
            } else {
                this.proposedTransactionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeProposedTransaction(SignedProposal value) {
            if (this.proposedTransactionBuilder_ == null) {
                this.proposedTransaction_ = this.proposedTransaction_ != null ? SignedProposal.newBuilder(this.proposedTransaction_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.proposedTransactionBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearProposedTransaction() {
            if (this.proposedTransactionBuilder_ == null) {
                this.proposedTransaction_ = null;
                this.onChanged();
            } else {
                this.proposedTransaction_ = null;
                this.proposedTransactionBuilder_ = null;
            }
            return this;
        }

        public SignedProposal.Builder getProposedTransactionBuilder() {
            this.onChanged();
            return (SignedProposal.Builder)this.getProposedTransactionFieldBuilder().getBuilder();
        }

        @Override
        public SignedProposalOrBuilder getProposedTransactionOrBuilder() {
            if (this.proposedTransactionBuilder_ != null) {
                return (SignedProposalOrBuilder)this.proposedTransactionBuilder_.getMessageOrBuilder();
            }
            return this.proposedTransaction_ == null ? SignedProposal.getDefaultInstance() : this.proposedTransaction_;
        }

        private SingleFieldBuilderV3<SignedProposal, SignedProposal.Builder, SignedProposalOrBuilder> getProposedTransactionFieldBuilder() {
            if (this.proposedTransactionBuilder_ == null) {
                this.proposedTransactionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getProposedTransaction(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.proposedTransaction_ = null;
            }
            return this.proposedTransactionBuilder_;
        }

        private void ensureEndorsingOrganizationsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.endorsingOrganizations_ = new LazyStringArrayList(this.endorsingOrganizations_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getEndorsingOrganizationsList() {
            return this.endorsingOrganizations_.getUnmodifiableView();
        }

        @Override
        public int getEndorsingOrganizationsCount() {
            return this.endorsingOrganizations_.size();
        }

        @Override
        public String getEndorsingOrganizations(int index) {
            return (String)this.endorsingOrganizations_.get(index);
        }

        @Override
        public ByteString getEndorsingOrganizationsBytes(int index) {
            return this.endorsingOrganizations_.getByteString(index);
        }

        public Builder setEndorsingOrganizations(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEndorsingOrganizationsIsMutable();
            this.endorsingOrganizations_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addEndorsingOrganizations(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEndorsingOrganizationsIsMutable();
            this.endorsingOrganizations_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllEndorsingOrganizations(Iterable<String> values) {
            this.ensureEndorsingOrganizationsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.endorsingOrganizations_);
            this.onChanged();
            return this;
        }

        public Builder clearEndorsingOrganizations() {
            this.endorsingOrganizations_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addEndorsingOrganizationsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EndorseRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureEndorsingOrganizationsIsMutable();
            this.endorsingOrganizations_.add(value);
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

