/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.logging.Logger;
import org.hyperledger.fabric.protos.peer.QueryResponse;
import org.hyperledger.fabric.protos.peer.QueryResponseMetadata;
import org.hyperledger.fabric.protos.peer.QueryResultBytes;
import org.hyperledger.fabric.shim.impl.ChaincodeInvocationTask;
import org.hyperledger.fabric.shim.impl.QueryResultsIteratorImpl;
import org.hyperledger.fabric.shim.ledger.QueryResultsIteratorWithMetadata;

public final class QueryResultsIteratorWithMetadataImpl<T>
extends QueryResultsIteratorImpl<T>
implements QueryResultsIteratorWithMetadata<T> {
    private static final Logger LOGGER = Logger.getLogger(QueryResultsIteratorWithMetadataImpl.class.getName());
    private final QueryResponseMetadata metadata;

    public QueryResultsIteratorWithMetadataImpl(ChaincodeInvocationTask handler, String channelId, String txId, ByteString responseBuffer, Function<QueryResultBytes, T> mapper) {
        super(handler, channelId, txId, responseBuffer, mapper);
        try {
            QueryResponse queryResponse = QueryResponse.parseFrom((ByteString)responseBuffer);
            this.metadata = QueryResponseMetadata.parseFrom((ByteString)queryResponse.getMetadata());
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.warning("can't parse response metadata");
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Override
    public QueryResponseMetadata getMetadata() {
        return this.metadata;
    }
}

